/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.web.client.util;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import java.io.File;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public final class LogService {
    public static final Level _SEVERE = Level.ERROR;
    public static final Level _WARNING = Level.WARN;
    public static final Level _INFO = Level.INFO;
    public static final Level _CONFIG = Level.INFO;
    public static final Level _FINE = Level.DEBUG;
    public static final Level _FINER = Level.TRACE;
    public static final Level _FINEST = Level.TRACE;
    private static boolean _Initialized = false;
    private static Logger _Logger = Logger.getLogger((String)"FM.web");
    private static Logger _UsrActLogger = Logger.getLogger((String)"FM.WebUsrAct");
    private static final LogService _Instance = new LogService();
    public static String _LoggingPropFile = null;

    protected LogService() {
        LogService.initialize();
    }

    public static final LogService instance() {
        return _Instance;
    }

    private static final void initialize() {
        if (_Initialized) {
            return;
        }
        try {
            LogService.loadLoggingConfiguration();
            GenUtil.loadServerProperties(_Logger);
            _Initialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String loadLoggingConfiguration() {
        System.setProperty("log.dir", ClientCache.getInstallLocation() + File.separator + "logs");
        String logConfFile = System.getProperty("org.apache.log4j.file");
        if (logConfFile == null || logConfFile.length() == 0) {
            logConfFile = ClientCache.getConfDir() + "log4j_fms.xml";
        }
        DOMConfigurator.configure((String)logConfFile);
        return logConfFile;
    }

    public static final void log(Level pLogLevel, String sMessage) {
        try {
            LogService.initialize();
            String wholeMsg = LogService.getSourceClass() + " " + LogService.getSourceMethod() + " " + sMessage;
            switch (pLogLevel.toInt()) {
                case 10000: {
                    _Logger.debug((Object)wholeMsg);
                    break;
                }
                case 20000: {
                    _Logger.info((Object)wholeMsg);
                    break;
                }
                case 30000: {
                    _Logger.warn((Object)wholeMsg);
                    break;
                }
                case 40000: {
                    _Logger.error((Object)wholeMsg);
                    break;
                }
                case 50000: {
                    _Logger.fatal((Object)wholeMsg);
                    break;
                }
                default: {
                    _Logger.debug((Object)wholeMsg);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void log(Level pLogLevel, Throwable ex) {
        try {
            LogService.initialize();
            String wholeMsg = LogService.getSourceClass() + " " + LogService.getSourceMethod() + "EXCEPTION: " + ex;
            switch (pLogLevel.toInt()) {
                case 10000: {
                    _Logger.debug((Object)wholeMsg, ex);
                    break;
                }
                case 20000: {
                    _Logger.info((Object)wholeMsg, ex);
                    break;
                }
                case 30000: {
                    _Logger.warn((Object)wholeMsg, ex);
                    break;
                }
                case 40000: {
                    _Logger.error((Object)wholeMsg, ex);
                    break;
                }
                case 50000: {
                    _Logger.fatal((Object)wholeMsg, ex);
                    break;
                }
                default: {
                    _Logger.debug((Object)wholeMsg, ex);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void log(Level pLogLevel, String sMessage, Throwable ex) {
        try {
            LogService.initialize();
            String wholeMsg = LogService.getSourceClass() + " " + LogService.getSourceMethod() + " " + sMessage;
            switch (pLogLevel.toInt()) {
                case 10000: {
                    _Logger.debug((Object)wholeMsg, ex);
                    break;
                }
                case 20000: {
                    _Logger.info((Object)wholeMsg, ex);
                    break;
                }
                case 30000: {
                    _Logger.warn((Object)wholeMsg, ex);
                    break;
                }
                case 40000: {
                    _Logger.error((Object)wholeMsg, ex);
                    break;
                }
                case 50000: {
                    _Logger.fatal((Object)wholeMsg, ex);
                    break;
                }
                default: {
                    _Logger.debug((Object)wholeMsg, ex);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void log(String sMessage) {
        try {
            LogService.initialize();
            _Logger.info((Object)(LogService.getSourceClass() + " " + LogService.getSourceMethod() + " " + sMessage));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void traceUsrAction(String userName, String sMessage) {
        try {
            LogService.initialize();
            _UsrActLogger.info((Object)(userName + " " + sMessage));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void logTime(Date start, Date end) {
        try {
            LogService.initialize();
            long time = end.getTime() - start.getTime();
            _Logger.debug((Object)(LogService.getSourceClass().toString() + " " + LogService.getSourceMethod().toString() + "  execution took " + (time < 1000L ? time + " msecs." : time / 1000L + " secs.")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSourceClass() {
        String str = "";
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] trace = t.getStackTrace();
        if (trace.length > 2) {
            str = trace[2].toString();
            if (str.lastIndexOf(40) != -1) {
                str = str.substring(0, str.lastIndexOf(40));
            }
            if (str.lastIndexOf(46) != -1) {
                str = str.substring(0, str.lastIndexOf(46));
            }
            return str;
        }
        return "";
    }

    private static String getSourceMethod() {
        String str = "";
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] trace = t.getStackTrace();
        if (trace.length > 2) {
            str = trace[2].toString();
            if (str.lastIndexOf(40) != -1) {
                str = str.substring(0, str.lastIndexOf(40));
            }
            if (str.lastIndexOf(46) != -1) {
                str = str.substring(str.lastIndexOf(46) + 1);
            }
            return str + "()";
        }
        return "";
    }
}

