/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.ws;

import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.ws.EnclosureWs;
import com.cisco.dcbu.ws.FabricManagerWsif;
import com.cisco.dcbu.ws.FabricPKWs;
import com.cisco.dcbu.ws.FabricWs;
import com.cisco.dcbu.ws.SwitchWs;
import com.cisco.dcbu.ws.WSDelegator;
import java.rmi.RemoteException;

public class FabricManagerSoapBindingImpl
implements FabricManagerWsif {
    @Override
    public FabricPKWs[] getFabricPKs() throws RemoteException {
        try {
            ModelFacadeRif rif = WSDelegator.getInstance().getModelFacadeRif();
            FabricPK[] pks = rif.getFabricPKs();
            FabricPKWs[] ret = new FabricPKWs[pks.length];
            for (int i = 0; i < pks.length; ++i) {
                ret[i] = new FabricPKWs();
                ret[i].fromBase(pks[i]);
            }
            return ret;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.err.println(ex.toString());
            throw new RemoteException("caught a remote exception during call", ex);
        }
    }

    @Override
    public FabricWs getFabric(FabricPKWs in0) throws RemoteException {
        FabricBase f = WSDelegator.getInstance().getWebServiceRif().getFabric(in0.toBase());
        FabricWs ret = new FabricWs();
        ret.fromBase(f);
        return ret;
    }

    @Override
    public EnclosureWs[] findAllHosts() throws RemoteException {
        EnclosureBase[] encls = WSDelegator.getInstance().getDDMServerRif().findAllHosts();
        EnclosureWs[] ret = new EnclosureWs[encls.length];
        for (int i = 0; i < encls.length; ++i) {
            ret[i] = new EnclosureWs();
            ret[i].fromBase(encls[i]);
        }
        return ret;
    }

    @Override
    public EnclosureWs[] findAllEnclosures() throws RemoteException {
        EnclosureBase[] encls = WSDelegator.getInstance().getWebServiceRif().findAllEnclosures();
        EnclosureWs[] ret = new EnclosureWs[encls.length];
        for (int i = 0; i < encls.length; ++i) {
            ret[i] = new EnclosureWs();
            ret[i].fromBase(encls[i]);
        }
        return ret;
    }

    @Override
    public boolean openFabric(String seedAddr, SnmpUserOpt snmpUserOpt) throws RemoteException {
        try {
            String encryptString = StringEncrypter.encryptString("DESede", snmpUserOpt.getPassword());
            snmpUserOpt.setPassword(encryptString);
            return WSDelegator.getInstance().getSessionRif().openFabric(seedAddr, snmpUserOpt, null, null);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public SwitchWs[] findAllSwitches() throws RemoteException {
        SwitchBase[] bases = WSDelegator.getInstance().getWebServiceRif().findAllSwitches();
        SwitchWs[] ret = new SwitchWs[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            ret[i] = new SwitchWs();
            ret[i].fromBase(bases[i]);
        }
        return ret;
    }
}

