/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.ws.services;

import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.ScsiTarget;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.rif.WebServiceRif;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.ws.wo.Enclosure;
import com.cisco.dcbu.ws.wo.Fabric;
import com.cisco.dcbu.ws.wo.FabricPK;
import com.cisco.dcbu.ws.wo.Vsan;
import com.cisco.dcbu.ws.wo.Wwn;

public class WebService {
    private static WebServiceRif local;

    private WebService() {
    }

    public static Vsan[] fromVsanDomain(VsanBase[] domain) {
        if (domain == null) {
            return null;
        }
        Vsan[] retVsans = new Vsan[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            retVsans[i].setAdminState(domain[i].getAdminState());
            retVsans[i].setEnfZoneSetActivateTime(domain[i].getEnforcedZoneSetActivateTime());
            retVsans[i].setEnfZoneSetName(domain[i].getEnforcedZoneSetName());
            retVsans[i].setFabricPK(WebService.fromFabricDomain(domain[i].getFabricPK()));
            retVsans[i].setFcAliasSeedPK(WebService.fromWwnDomain(domain[i].getFcAliasSeedPK()._wwn));
            retVsans[i].setFiconState(domain[i].getFiconState());
            retVsans[i].setInorderDelivery(domain[i].isInorderDelivery());
            retVsans[i].setInterOperMode(domain[i].getInterOperMode());
            retVsans[i].setLoadBalancingType(domain[i].getLoadBalancingType());
            retVsans[i].setMtu(domain[i].getMtu());
            retVsans[i].setName(domain[i].getName());
            retVsans[i].setNetworkDropLatency(domain[i].getNetworkDropLatency());
            retVsans[i].setOperState(domain[i].getOperState());
            retVsans[i].setPkey(WebService.fromVsanPKDomain((VsanPK)domain[i].getPK()));
            retVsans[i].setSeedSwitchPK(WebService.fromWwnDomain(domain[i].getSeedSwitchPK()._wwn));
            retVsans[i].setSegmented(domain[i].isSegmented());
        }
        return retVsans;
    }

    public static Fabric[] fromFabricDomain(FabricBase[] domain) {
        if (domain == null) {
            return null;
        }
        Fabric[] retFabrics = new Fabric[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            retFabrics[i] = WebService.fromFabricDomain(domain[i]);
        }
        return retFabrics;
    }

    public static Fabric fromFabricDomain(FabricBase domain) {
        if (domain == null) {
            return null;
        }
        Fabric retFabric = new Fabric();
        retFabric.setAliasSeedSwPK(WebService.fromWwnDomain(domain.getAliasSeedSwitchPK()._wwn));
        retFabric.setIsPersistent(domain.isPersistent());
        retFabric.setIvrEnfZoneSetActivateTime(domain.getIvrEnforcedZoneSetActivateTime());
        return retFabric;
    }

    public static FabricPK fromFabricDomain(com.cisco.dcbu.sm.common.type.FabricPK domain) {
        FabricPK retPK = new FabricPK(domain._fid, domain.getName());
        return retPK;
    }

    public static Wwn fromWwnDomain(com.cisco.dcbu.lib.jnm.Wwn domain) {
        Wwn wwn = new Wwn(domain.getValue(), domain.toString());
        return wwn;
    }

    public static com.cisco.dcbu.ws.wo.VsanPK fromVsanPKDomain(VsanPK domain) {
        com.cisco.dcbu.ws.wo.VsanPK retPK = new com.cisco.dcbu.ws.wo.VsanPK(domain._id, WebService.fromWwnDomain(domain._prinSwwn));
        return retPK;
    }

    public static Enclosure[] fromEnclosureDomain(EnclosureBase[] domain) {
        Enclosure[] ens = new Enclosure[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            ens[i] = WebService.fromEnclosureDomain(domain[i]);
        }
        return ens;
    }

    public static Enclosure fromEnclosureDomain(EnclosureBase domain) {
        Enclosure en = new Enclosure();
        en.setDmPath(domain.getDMPath());
        en.setIpAddress(domain.getIpAddress());
        en.setIsVirtual(domain.isVirtual());
        en.setModel(domain.getModel());
        en.setOsInfo(domain.getOSInfo());
        en.setPkey(domain.getPK().toString());
        en.setTarget(WebService.fromScsiTargetDomain(domain.getScsiTarget()));
        en.setType(domain.getType());
        en.setVendor(domain.getVendor());
        en.setVersion(domain.getVersion());
        return en;
    }

    public static com.cisco.dcbu.ws.wo.ScsiTarget fromScsiTargetDomain(ScsiTarget domain) {
        com.cisco.dcbu.ws.wo.ScsiTarget scsi = new com.cisco.dcbu.ws.wo.ScsiTarget(WebService.fromWwnDomain(domain.getScsiName()), domain.getDevType(), domain.getVendorId(), domain.getProductId(), domain.getRevLevel(), domain.getOtherInfoValue());
        return scsi;
    }
}

