/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

class PortWatcher
implements Runnable {
    private static Vector pool = new Vector();
    Session session;
    int lport;
    int rport;
    String host;
    InetAddress boundaddress;
    ServerSocket ss;
    Runnable thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        int i;
        Vector<String> foo = new Vector<String>();
        Vector vector = pool;
        synchronized (vector) {
            for (i = 0; i < pool.size(); ++i) {
                PortWatcher p = (PortWatcher)pool.elementAt(i);
                if (p.session != session) continue;
                foo.addElement(p.lport + ":" + p.host + ":" + p.rport);
            }
        }
        String[] bar = new String[foo.size()];
        for (i = 0; i < foo.size(); ++i) {
            bar[i] = (String)foo.elementAt(i);
        }
        return bar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PortWatcher getPort(Session session, String address, int lport) throws JSchException {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(address);
        }
        catch (UnknownHostException uhe) {
            throw new JSchException("PortForwardingL: invalid address " + address + " specified.");
        }
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                PortWatcher p = (PortWatcher)pool.elementAt(i);
                if (p.session != session || p.lport != lport || !p.boundaddress.isAnyLocalAddress() && !p.boundaddress.equals(addr)) continue;
                return p;
            }
            return null;
        }
    }

    static PortWatcher addPort(Session session, String address, int lport, String host, int rport) throws JSchException {
        if (PortWatcher.getPort(session, address, lport) != null) {
            throw new JSchException("PortForwardingL: local port " + address + ":" + lport + " is already registered.");
        }
        PortWatcher pw = new PortWatcher(session, address, lport, host, rport);
        pool.addElement(pw);
        return pw;
    }

    static void delPort(Session session, String address, int lport) throws JSchException {
        PortWatcher pw = PortWatcher.getPort(session, address, lport);
        if (pw == null) {
            throw new JSchException("PortForwardingL: local port " + address + ":" + lport + " is not registered.");
        }
        pw.delete();
        pool.removeElement(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        Vector vector = pool;
        synchronized (vector) {
            PortWatcher p;
            int i;
            PortWatcher[] foo = new PortWatcher[pool.size()];
            int count = 0;
            for (i = 0; i < pool.size(); ++i) {
                p = (PortWatcher)pool.elementAt(i);
                if (p.session != session) continue;
                p.delete();
                foo[count++] = p;
            }
            for (i = 0; i < count; ++i) {
                p = foo[i];
                pool.removeElement(p);
            }
        }
    }

    PortWatcher(Session session, String address, int lport, String host, int rport) throws JSchException {
        this.session = session;
        this.lport = lport;
        this.host = host;
        this.rport = rport;
        try {
            this.boundaddress = InetAddress.getByName(address);
            this.ss = new ServerSocket(lport, 0, this.boundaddress);
        }
        catch (Exception e) {
            System.out.println(e);
            throw new JSchException("PortForwardingL: local port " + address + ":" + lport + " cannot be bound.");
        }
    }

    @Override
    public void run() {
        Buffer buf = new Buffer(300);
        Packet packet = new Packet(buf);
        this.thread = this;
        try {
            while (this.thread != null) {
                Socket socket = this.ss.accept();
                socket.setTcpNoDelay(true);
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                ChannelDirectTCPIP channel = new ChannelDirectTCPIP();
                channel.init();
                channel.setInputStream(in);
                channel.setOutputStream(out);
                this.session.addChannel(channel);
                channel.setHost(this.host);
                channel.setPort(this.rport);
                channel.setOrgIPAddress(socket.getInetAddress().getHostAddress());
                channel.setOrgPort(socket.getPort());
                channel.connect();
                if (channel.exitstatus == -1) continue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void delete() {
        this.thread = null;
        try {
            if (this.ss != null) {
                this.ss.close();
            }
            this.ss = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

