/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.DHParams;
import iaik.pkcs.pkcs11.objects.DSAParams;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X942DHParams;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class DomainParameters
extends Storage {
    protected static VendorDefinedDomainParametersBuilder vendorDomainParametersBuilder_;
    protected KeyTypeAttribute keyType_;
    protected BooleanAttribute local_;

    public DomainParameters() {
        this.objectClass_.setLongValue(Object.ObjectClass.DOMAIN_PARAMETERS);
    }

    protected DomainParameters(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass_.setLongValue(Object.ObjectClass.DOMAIN_PARAMETERS);
    }

    public static void setVendorDefinedDomainParametersBuilder(VendorDefinedDomainParametersBuilder builder) {
        vendorDomainParametersBuilder_ = builder;
    }

    public static VendorDefinedDomainParametersBuilder getVendorDefinedDomainParametersBuilder() {
        return vendorDomainParametersBuilder_;
    }

    public static Object getInstance(Session session, long objectHandle) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        DomainParameters.getAttributeValue(session, objectHandle, keyTypeAttribute);
        Long keyType = keyTypeAttribute.getLongValue();
        Object newObject = keyTypeAttribute.isPresent() && keyType != null ? (keyType.equals(Key.KeyType.DSA) ? DSAParams.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.DH) ? DHParams.getInstance(session, objectHandle) : (keyType.equals(Key.KeyType.X9_42_DH) ? X942DHParams.getInstance(session, objectHandle) : ((keyType & Key.KeyType.VENDOR_DEFINED) != 0L ? DomainParameters.getUnknownDomainParameters(session, objectHandle) : DomainParameters.getUnknownDomainParameters(session, objectHandle))))) : DomainParameters.getUnknownDomainParameters(session, objectHandle);
        return newObject;
    }

    protected static Object getUnknownDomainParameters(Session session, long objectHandle) throws TokenException {
        Object newObject;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (vendorDomainParametersBuilder_ != null) {
            try {
                newObject = vendorDomainParametersBuilder_.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new DomainParameters(session, objectHandle);
            }
        } else {
            newObject = new DomainParameters(session, objectHandle);
        }
        return newObject;
    }

    protected static void putAttributesInTable(DomainParameters object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        object.attributeTable_.put(Attribute.KEY_TYPE, object.keyType_);
        object.attributeTable_.put(Attribute.LOCAL, object.local_);
    }

    @Override
    protected void allocateAttributes() {
        super.allocateAttributes();
        this.keyType_ = new KeyTypeAttribute();
        this.local_ = new BooleanAttribute(Attribute.LOCAL);
        DomainParameters.putAttributesInTable(this);
    }

    @Override
    public java.lang.Object clone() {
        DomainParameters clone = (DomainParameters)super.clone();
        clone.keyType_ = (KeyTypeAttribute)this.keyType_.clone();
        clone.local_ = (BooleanAttribute)this.local_.clone();
        DomainParameters.putAttributesInTable(clone);
        return clone;
    }

    @Override
    public boolean equals(java.lang.Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof DomainParameters) {
            DomainParameters other = (DomainParameters)otherObject;
            equal = this == other || super.equals(other) && this.keyType_.equals(other.keyType_) && this.local_.equals(other.local_);
        }
        return equal;
    }

    public LongAttribute getKeyType() {
        return this.keyType_;
    }

    @Override
    public int hashCode() {
        return this.keyType_.hashCode() ^ this.local_.hashCode();
    }

    public BooleanAttribute isLocal() {
        return this.local_;
    }

    @Override
    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.local_);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Key Type: ");
        if (this.keyType_ != null) {
            buffer.append(this.keyType_.toString());
        } else {
            buffer.append("<unavailable>");
        }
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Local: ");
        buffer.append(this.local_.toString());
        return buffer.toString();
    }

    public static interface VendorDefinedDomainParametersBuilder {
        public Object build(Session var1, long var2) throws PKCS11Exception;
    }
}

