/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.ArrayList;
import org.jrobin.core.ArcDef;
import org.jrobin.core.ArcState;
import org.jrobin.core.Datasource;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.Robin;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDouble;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFile;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdString;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlReader;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Archive
implements RrdUpdater {
    RrdDb parentDb;
    private RrdString consolFun;
    private RrdDouble xff;
    private RrdInt steps;
    private RrdInt rows;
    private Robin[] robins;
    private ArcState[] states;

    Archive(RrdDb parentDb, ArcDef arcDef) throws IOException {
        this.parentDb = parentDb;
        this.consolFun = new RrdString(arcDef.getConsolFun(), this);
        this.xff = new RrdDouble(arcDef.getXff(), this);
        this.steps = new RrdInt(arcDef.getSteps(), this);
        this.rows = new RrdInt(arcDef.getRows(), this);
        int n = parentDb.getHeader().getDsCount();
        this.robins = new Robin[n];
        this.states = new ArcState[n];
        for (int i = 0; i < n; ++i) {
            this.states[i] = new ArcState(this, true);
            this.robins[i] = new Robin(this, this.rows.get(), true);
        }
    }

    Archive(RrdDb parentDb) throws IOException {
        this.parentDb = parentDb;
        this.consolFun = new RrdString(this);
        this.xff = new RrdDouble(this);
        this.steps = new RrdInt(this);
        this.rows = new RrdInt(this);
        int n = parentDb.getHeader().getDsCount();
        this.states = new ArcState[n];
        this.robins = new Robin[n];
        for (int i = 0; i < n; ++i) {
            this.states[i] = new ArcState(this, false);
            this.robins[i] = new Robin(this, this.rows.get(), false);
        }
    }

    Archive(RrdDb parentDb, XmlReader reader, int arcIndex) throws IOException, RrdException {
        this.parentDb = parentDb;
        this.consolFun = new RrdString(reader.getConsolFun(arcIndex), this);
        this.xff = new RrdDouble(reader.getXff(arcIndex), this);
        this.steps = new RrdInt(reader.getSteps(arcIndex), this);
        this.rows = new RrdInt(reader.getRows(arcIndex), this);
        int dsCount = reader.getDsCount();
        this.robins = new Robin[dsCount];
        this.states = new ArcState[dsCount];
        for (int dsIndex = 0; dsIndex < dsCount; ++dsIndex) {
            this.states[dsIndex] = new ArcState(this, true);
            this.states[dsIndex].setAccumValue(reader.getStateAccumValue(arcIndex, dsIndex));
            this.states[dsIndex].setNanSteps(reader.getStateNanSteps(arcIndex, dsIndex));
            this.robins[dsIndex] = new Robin(this, this.rows.get(), true);
            double[] values = reader.getValues(arcIndex, dsIndex);
            for (int j = 0; j < values.length; ++j) {
                this.robins[dsIndex].store(values[j]);
            }
        }
    }

    public long getArcStep() throws IOException {
        long step = this.parentDb.getHeader().getStep();
        return step * (long)this.steps.get();
    }

    public String dump() throws IOException {
        StringBuffer buffer = new StringBuffer("== ARCHIVE ==\n");
        buffer.append("RRA:" + this.consolFun.get() + ":" + this.xff.get() + ":" + this.steps.get() + ":" + this.rows.get() + "\n");
        buffer.append("interval [" + this.getStartTime() + ", " + this.getEndTime() + "]" + "\n");
        for (int i = 0; i < this.robins.length; ++i) {
            buffer.append(this.states[i].dump());
            buffer.append(this.robins[i].dump());
        }
        return buffer.toString();
    }

    public Robin getRobin(int dsIndex) {
        return this.robins[dsIndex];
    }

    public Robin[] getRobins() {
        return this.robins;
    }

    RrdDb getParentDb() {
        return this.parentDb;
    }

    @Override
    public RrdFile getRrdFile() {
        return this.parentDb.getRrdFile();
    }

    void archive(int dsIndex, double value, long numUpdates) throws IOException {
        Robin robin = this.robins[dsIndex];
        ArcState state = this.states[dsIndex];
        long step = this.parentDb.getHeader().getStep();
        long lastUpdateTime = this.parentDb.getDatasource(dsIndex).getLastUpdateTime();
        long updateTime = Util.normalize(lastUpdateTime, step) + step;
        long arcStep = this.getArcStep();
        while (numUpdates > 0L) {
            this.accumulate(state, value);
            --numUpdates;
            if (updateTime % arcStep == 0L) {
                this.finalizeStep(state, robin);
                break;
            }
            updateTime += step;
        }
        long bulkUpdates = Math.min(numUpdates / (long)this.steps.get(), (long)this.rows.get());
        for (long i = 0L; i < bulkUpdates; ++i) {
            robin.store(value);
        }
        long remainingUpdates = numUpdates % (long)this.steps.get();
        for (long i = 0L; i < remainingUpdates; ++i) {
            this.accumulate(state, value);
        }
    }

    private void accumulate(ArcState state, double value) throws IOException {
        if (Double.isNaN(value)) {
            state.setNanSteps(state.getNanSteps() + 1L);
        } else if (this.consolFun.get().equals("MIN")) {
            state.setAccumValue(Util.min(state.getAccumValue(), value));
        } else if (this.consolFun.get().equals("MAX")) {
            state.setAccumValue(Util.max(state.getAccumValue(), value));
        } else if (this.consolFun.get().equals("LAST")) {
            state.setAccumValue(Util.sum(state.getAccumValue(), value));
        } else if (this.consolFun.get().equals("AVERAGE")) {
            state.setAccumValue(Util.sum(state.getAccumValue(), value));
        }
    }

    private void finalizeStep(ArcState state, Robin robin) throws IOException {
        long arcSteps = this.steps.get();
        long nanSteps = state.getNanSteps();
        double nanPct = (double)nanSteps / (double)arcSteps;
        double accumValue = state.getAccumValue();
        if (nanPct <= this.xff.get() && !Double.isNaN(accumValue)) {
            if (this.parentDb.getDatasources()[0].getDsType().equals("COUNTER") && this.consolFun.get().equals("AVERAGE")) {
                accumValue /= (double)(arcSteps - nanSteps);
            } else if (this.parentDb.getDatasources()[0].getDsType().equals("GAUGE") && this.consolFun.get().equals("AVERAGE")) {
                accumValue /= (double)(arcSteps - nanSteps);
            }
            robin.store(accumValue);
        } else {
            robin.store(Double.NaN);
        }
        state.setAccumValue(Double.NaN);
        state.setNanSteps(0L);
    }

    public String getConsolFun() throws IOException {
        return this.consolFun.get();
    }

    public double getXff() throws IOException {
        return this.xff.get();
    }

    public int getSteps() throws IOException {
        return this.steps.get();
    }

    public int getRows() throws IOException {
        return this.rows.get();
    }

    public long getStartTime() throws IOException {
        long endTime = this.getEndTime();
        long arcStep = this.getArcStep();
        long numRows = this.rows.get();
        return endTime - (numRows - 1L) * arcStep;
    }

    public long getStartTime(Datasource ds) throws IOException {
        long endTime = this.getEndTime(ds);
        long arcStep = this.getArcStep();
        long numRows = this.rows.get();
        return endTime - (numRows - 1L) * arcStep;
    }

    public long getEndTime(Datasource ds) throws IOException {
        long arcStep = this.getArcStep();
        long lastUpdateTime = ds.getLastUpdateTime();
        return Util.normalize(lastUpdateTime, arcStep);
    }

    public long getEndTime() throws IOException {
        long arcStep = this.getArcStep();
        long lastUpdateTime = this.parentDb.getHeader().getLastUpdateTime();
        return Util.normalize(lastUpdateTime, arcStep);
    }

    public FetchPoint[] fetch(FetchRequest request) throws IOException, RrdException {
        long endTime;
        long startTime;
        long arcStep = this.getArcStep();
        long fetchStart = Util.normalize(request.getFetchStart(), arcStep);
        long fetchEnd = Util.normalize(request.getFetchEnd(), arcStep);
        if (fetchEnd < request.getFetchEnd()) {
            fetchEnd += arcStep;
        }
        Robin[] matchingRobins = null;
        matchingRobins = request.getIndexes() != null ? this.getMatchingRobins(request.getIndexes()) : this.getMatchingRobins(request.getDsPattern());
        int dsCount = matchingRobins.length;
        if (dsCount == 0) {
            throw new RrdException("Did not find matching DS");
        }
        if (request.getDsPattern() != null) {
            Datasource ds = this.getDataSource(request.getDsPattern())[0];
            startTime = this.getStartTime(ds);
            endTime = this.getEndTime(ds);
        } else {
            startTime = this.getStartTime();
            endTime = this.getEndTime();
        }
        int ptsCount = (int)((fetchEnd - fetchStart) / arcStep + 1L);
        FetchPoint[] points = new FetchPoint[ptsCount];
        for (int i = 0; i < ptsCount; ++i) {
            long time = fetchStart + (long)i * arcStep;
            FetchPoint point = new FetchPoint(time, dsCount);
            if (time >= startTime && time <= endTime) {
                int robinIndex = (int)((time - startTime) / arcStep);
                for (int j = 0; j < dsCount; ++j) {
                    point.setValue(j, matchingRobins[j].getValue(robinIndex));
                }
            }
            points[i] = point;
        }
        return points;
    }

    private Datasource[] getDataSource(String dsPattern) throws IOException {
        if (dsPattern == null) {
            return this.parentDb.getDatasources();
        }
        Datasource[] dss = this.parentDb.getDatasources();
        ArrayList<Datasource> list = new ArrayList<Datasource>();
        for (int i = 0; i < dss.length; ++i) {
            if (!dss[i].getDsName().startsWith(dsPattern)) continue;
            list.add(dss[i]);
        }
        return list.toArray(new Datasource[list.size()]);
    }

    private Robin[] getMatchingRobins(int[] index) throws IOException {
        if (index == null) {
            return this.robins;
        }
        Datasource[] dss = this.parentDb.getDatasources();
        ArrayList<Robin> list = new ArrayList<Robin>();
        for (int i = 0; i < index.length; ++i) {
            list.add(this.robins[index[i]]);
        }
        return list.toArray(new Robin[list.size()]);
    }

    private Robin[] getMatchingRobins(String dsPattern) throws IOException {
        if (dsPattern == null) {
            return this.robins;
        }
        Datasource[] dss = this.parentDb.getDatasources();
        ArrayList<Robin> list = new ArrayList<Robin>();
        for (int i = 0; i < dss.length; ++i) {
            if (!dss[i].getDsName().startsWith(dsPattern)) continue;
            list.add(this.robins[i]);
        }
        return list.toArray(new Robin[list.size()]);
    }

    private ArcState[] getMatchingArcState(String dsPattern) throws IOException {
        if (dsPattern == null) {
            return this.states;
        }
        Datasource[] dss = this.parentDb.getDatasources();
        ArrayList<ArcState> list = new ArrayList<ArcState>();
        for (int i = 0; i < dss.length; ++i) {
            if (!dss[i].getDsName().startsWith(dsPattern)) continue;
            list.add(this.states[i]);
        }
        return list.toArray(new ArcState[list.size()]);
    }

    public ArcState getArcState(int dsIndex) {
        return this.states[dsIndex];
    }

    public void copy(String dsPattern, Archive source) throws IOException {
        int i;
        Robin[] destRobins = this.getMatchingRobins(dsPattern);
        ArcState[] destStates = this.getMatchingArcState(dsPattern);
        Robin[] srcRobins = source.getRobins();
        ArcState[] srcStates = source.getMatchingArcState(null);
        if (destRobins.length != srcRobins.length) {
            throw new IOException(" source and dest Robin does not match");
        }
        if (destRobins.length != destStates.length) {
            throw new IOException(" dest state and dest Robin does not match");
        }
        for (i = 0; i < srcRobins.length; ++i) {
            if (this.rows.get() != source.rows.get()) {
                throw new IOException("Source robin rows: " + source.rows.get() + " dest " + this.rows.get() + " not match");
            }
            for (int j = 0; j < this.rows.get(); ++j) {
                double value = srcRobins[i].getValue(j);
                destRobins[i].store(value);
            }
        }
        for (i = 0; i < srcStates.length; ++i) {
            destStates[i].copy(srcStates[i]);
        }
    }

    void appendXml(Element parent) throws IOException {
        Document doc = parent.getOwnerDocument();
        Element rraElem = doc.createElement("rra");
        Element cfElem = doc.createElement("cf");
        cfElem.appendChild(doc.createTextNode(this.consolFun.get()));
        long arcStep = this.getArcStep();
        Comment pdpComment = doc.createComment(arcStep + " seconds");
        Element pdpElem = doc.createElement("pdp_per_row");
        pdpElem.appendChild(doc.createTextNode("" + this.steps.get()));
        Element xffElem = doc.createElement("xff");
        xffElem.appendChild(doc.createTextNode("" + Util.formatDoubleXml(this.xff.get())));
        Element cdpElem = doc.createElement("cdp_prep");
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i].appendXml(cdpElem);
        }
        Element dbElem = doc.createElement("database");
        long startTime = this.getStartTime();
        for (int i = 0; i < this.rows.get(); ++i) {
            long time = startTime + (long)i * arcStep;
            Comment rowComment = doc.createComment(Util.getDate(time) + " / " + time);
            dbElem.appendChild(rowComment);
            Element rowElem = doc.createElement("row");
            for (int j = 0; j < this.robins.length; ++j) {
                Element vElem = doc.createElement("v");
                vElem.appendChild(doc.createTextNode(Util.formatDoubleXml(this.robins[j].getValue(i))));
                rowElem.appendChild(vElem);
            }
            dbElem.appendChild(rowElem);
        }
        parent.appendChild(rraElem);
        rraElem.appendChild(cfElem);
        rraElem.appendChild(pdpComment);
        rraElem.appendChild(pdpElem);
        rraElem.appendChild(xffElem);
        rraElem.appendChild(cdpElem);
        rraElem.appendChild(dbElem);
    }
}

