/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdFile;
import org.jrobin.core.RrdUpdater;

class RrdString {
    private RrdFile file;
    private long pointer;
    private boolean cached = false;
    private String cachedValue;

    RrdString(RrdUpdater updater, int count) throws IOException {
        this.file = updater.getRrdFile();
        this.pointer = this.file.allocate(RrdFile.STRING_SIZE, count);
    }

    RrdString(RrdUpdater updater) throws IOException {
        this(updater, 1);
    }

    RrdString(String initValue, RrdUpdater updater) throws IOException {
        this.file = updater.getRrdFile();
        this.pointer = this.file.allocate(initValue);
        this.cached = true;
        this.cachedValue = initValue;
    }

    void set(int index, String value) throws IOException {
        long readPointer = this.pointer + (long)(index * RrdFile.STRING_SIZE);
        this.file.writeString(readPointer, value);
    }

    void set(String value) throws IOException {
        this.cached = true;
        this.cachedValue = value;
        this.set(0, value);
    }

    String get(int index) throws IOException {
        long readPointer = this.pointer + (long)(index * RrdFile.STRING_SIZE);
        return this.file.readString(readPointer);
    }

    String get() throws IOException {
        if (!this.cached) {
            this.cachedValue = this.get(0);
            this.cached = true;
        }
        return this.cachedValue;
    }
}

