/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;

class RrdNode {
    private int dsIndex = -1;
    private int arcIndex = -1;
    private String label;

    RrdNode(RrdDb rrd) {
        String path = rrd.getRrdFile().getFilePath();
        this.label = new File(path).getName();
    }

    RrdNode(RrdDb rrd, int dsIndex) throws IOException, RrdException {
        this.dsIndex = dsIndex;
        RrdDef def = rrd.getRrdDef();
        DsDef[] dsDefs = def.getDsDefs();
        this.label = dsDefs[dsIndex].dump();
    }

    RrdNode(RrdDb rrd, int dsIndex, int arcIndex) throws IOException, RrdException {
        this.dsIndex = dsIndex;
        this.arcIndex = arcIndex;
        ArcDef[] arcDefs = rrd.getRrdDef().getArcDefs();
        this.label = arcDefs[arcIndex].dump();
    }

    int getDsIndex() {
        return this.dsIndex;
    }

    int getArcIndex() {
        return this.arcIndex;
    }

    public String toString() {
        return this.label;
    }
}

