/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import jclass.chart.ActionHandler;
import jclass.chart.Changeable;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDraw;
import jclass.chart.ChartRegion;
import jclass.chart.EventTrigger;
import jclass.chart.Extents;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartConverter;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCMarker;
import jclass.chart.PlotArea;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

public class JCChartArea
extends ChartRegion
implements HTMLHandler {
    JCVector xaxes = new JCVector();
    JCVector yaxes = new JCVector();
    int angleUnit = 1;
    JCVector markers = new JCVector();
    JCAxis horizActionAxis;
    JCAxis vertActionAxis;
    boolean axisBoundingBox = false;
    boolean fastAction = false;
    boolean inAction = false;
    int depth = 0;
    int elevation = 0;
    int rotation = 0;
    static final String[] angleUnit_strings = new String[]{"DEGREES", "RADIANS", "GRADS"};
    static final int[] angleUnit_values = new int[]{1, 2, 3};
    private transient Hashtable drawables = new Hashtable();
    public transient Hashtable axisHashtable;
    private PlotArea plotArea = new PlotArea(this);
    Rectangle chartAreaRect = new Rectangle(0, 0, 0, 0);
    Rectangle plotRect = new Rectangle(0, 0, 0, 0);
    int deltaX = 0;
    int deltaY = 0;
    boolean draw3D = false;
    boolean hasBar = false;
    private boolean axisDrawOkay = false;
    private Rectangle backplane;
    transient ActionHandler handler = null;
    transient boolean saveDBState = false;
    Graphics rbGC = null;
    Point last = new Point(0, 0);
    boolean inSuperReshape = false;

    public JCChartArea() {
        JCAxis jCAxis = new JCAxis(this, false, 0);
        jCAxis.setParent(this.getParent());
        jCAxis.name = JCChartBundle.string("jclass.chart.Key28");
        JCAxis jCAxis2 = new JCAxis(this, true, 0);
        jCAxis2.setParent(this.getParent());
        jCAxis2.name = JCChartBundle.string("jclass.chart.Key29");
        this.xaxes.addElement(jCAxis);
        this.yaxes.addElement(jCAxis2);
        this.setHorizActionAxis(jCAxis);
        this.setVertActionAxis(jCAxis2);
        this.transparent = false;
    }

    private void addAxis(int n, JCVector jCVector, JCAxis jCAxis) {
        jCAxis.setParent(this.getParent());
        jCVector.insertElementAt(jCAxis, n);
    }

    private synchronized void addDrawable(ChartDataView chartDataView) {
        if (chartDataView == null) {
            return;
        }
        if (this.hasMatchingDrawable(chartDataView)) {
            this.removeDrawable(chartDataView);
        }
        ChartDraw chartDraw = ChartDraw.makeDrawObject(chartDataView);
        this.drawables.put(chartDataView, chartDraw);
    }

    private void adjust(JCVector jCVector, int n, int n2, int n3, int n4) {
        this.adjust(jCVector, n, n2, n3, n4, 0);
    }

    private void adjust(JCVector jCVector, int n, int n2, int n3, int n4, int n5) {
        if (jCVector == null) {
            return;
        }
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return;
        }
        int n6 = 0;
        while (n6 < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n6);
            if (n5 == 0 || n5 == jCAxis.getAdjustedRealPlacement()) {
                int n7 = jCAxis.getLeft() + n;
                int n8 = jCAxis.getTop() + n2;
                int n9 = jCAxis.getWidth() + n3;
                int n10 = jCAxis.getHeight() + n4;
                jCAxis.reshape(n7, n8, n9, n10);
            }
            ++n6;
        }
    }

    private void adjustForExtents(JCVector jCVector, JCVector jCVector2) {
        Extents extents = new Extents();
        Extents extents2 = new Extents();
        this.findMaxExtents(jCVector, extents);
        this.findMaxExtents(jCVector2, extents2);
        int n = extents.minor - this.plotRect.x;
        if (n > 0 && this.plotArea.left.isDefault) {
            this.plotRect.width -= n;
            this.plotRect.x += n;
            this.adjust(jCVector, n, 0, -n, 0);
            this.adjust(jCVector2, n, 0, 0, 0, 1);
        }
        if ((n = extents.major - (this.chartAreaRect.width - this.plotRect.x - this.plotRect.width)) > 0 && this.plotArea.right.isDefault) {
            this.plotRect.width -= n;
            this.adjust(jCVector, 0, 0, -n, 0);
            this.adjust(jCVector2, -n, 0, 0, 0, 2);
        }
        if ((n = extents2.major - (this.chartAreaRect.height - this.plotRect.y - this.plotRect.height)) > 0 && this.plotArea.bottom.isDefault) {
            this.plotRect.height -= n;
            this.adjust(jCVector2, 0, -n, 0, -n);
            this.adjust(jCVector, 0, -n, 0, 0, 1);
        }
        if ((n = extents2.minor - this.plotRect.y) > 0 && this.plotArea.top.isDefault) {
            this.plotRect.y += n;
            this.plotRect.height -= n;
            this.adjust(jCVector2, 0, n, 0, -n);
            this.adjust(jCVector, 0, n, 0, 0, 2);
        }
    }

    private void adjustForOrthoExtents(JCVector jCVector, JCVector jCVector2) {
        Rectangle rectangle = new Rectangle(this.plotRect.x, this.plotRect.y, this.plotRect.width, this.plotRect.height);
        int n = 0;
        while (n < jCVector.size()) {
            ((JCAxis)jCVector.elementAt(n)).adjustForOrthoExtent();
            ++n;
        }
        int n2 = 0;
        while (n2 < jCVector2.size()) {
            ((JCAxis)jCVector2.elementAt(n2)).adjustForOrthoExtent();
            ++n2;
        }
        if (this.plotRect.equals(rectangle)) {
            return;
        }
        this.adjust(jCVector2, 0, this.plotRect.y - rectangle.y, 0, this.plotRect.height - rectangle.height);
        this.adjust(jCVector, this.plotRect.x - rectangle.x, 0, this.plotRect.width - rectangle.width, 0);
        this.layoutOrigins(jCVector);
        this.layoutOrigins(jCVector2);
    }

    private void adjustPlotRectForAxes(JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n5);
            if (jCAxis.isShowing) {
                if (jCAxis.isVertical) {
                    if (jCAxis.annoHandler.extents.ortho > jCAxis.getWidth()) {
                        jCAxis.resize(jCAxis.annoHandler.extents.ortho, jCAxis.getHeight());
                    }
                    if (jCAxis.isLeftSide()) {
                        n = this.draw3D ? Math.max(n, jCAxis.getWidth()) : (n += jCAxis.getWidth());
                    } else if (jCAxis.isRightSide()) {
                        n2 = this.draw3D ? Math.max(n2, jCAxis.getWidth()) : (n2 += jCAxis.getWidth());
                    }
                } else {
                    if (jCAxis.annoHandler.extents.ortho > jCAxis.getHeight()) {
                        jCAxis.resize(jCAxis.getWidth(), jCAxis.annoHandler.extents.ortho);
                    }
                    if (jCAxis.isTopSide()) {
                        n3 = this.draw3D ? Math.max(n3, jCAxis.getHeight()) : (n3 += jCAxis.getHeight());
                    } else if (jCAxis.isBottomSide()) {
                        n4 = this.draw3D ? Math.max(n4, jCAxis.getHeight()) : (n4 += jCAxis.getHeight());
                    }
                }
            }
            ++n5;
        }
        if (!this.getPlotArea().getLeftIsDefault()) {
            this.plotRect.x = this.getPlotArea().getLeft();
        }
        if (!this.getPlotArea().getTopIsDefault()) {
            this.plotRect.y = this.getPlotArea().getTop();
        }
        int n6 = this.plotRect.x;
        int n7 = this.getPlotArea().getRightIsDefault() ? this.plotRect.x + this.plotRect.width : this.chartAreaRect.width - this.getPlotArea().getRight();
        int n8 = this.plotRect.y;
        int n9 = this.getPlotArea().getBottomIsDefault() ? this.plotRect.y + this.plotRect.height : this.chartAreaRect.height - this.getPlotArea().getBottom();
        int n10 = 0;
        while (n10 < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n10);
            if (jCAxis.isShowing) {
                if (jCAxis.isVertical) {
                    if (jCAxis.isLeftSide()) {
                        if (this.getPlotArea().getLeftIsDefault()) {
                            if (this.draw3D) {
                                jCAxis.move(n6 + n - jCAxis.getWidth(), jCAxis.getTop());
                            } else {
                                jCAxis.move(n6, jCAxis.getTop());
                                n6 += jCAxis.getWidth();
                            }
                        } else if (this.draw3D) {
                            jCAxis.move(n6 - jCAxis.getWidth(), jCAxis.getTop());
                        } else {
                            jCAxis.move(n6 - n, jCAxis.getTop());
                            n6 += jCAxis.getWidth();
                        }
                    } else if (jCAxis.isRightSide()) {
                        if (this.getPlotArea().getRightIsDefault()) {
                            if (this.draw3D) {
                                jCAxis.move(n7 - n2, jCAxis.getTop());
                            } else {
                                jCAxis.move(n7 - n2, jCAxis.getTop());
                                n7 += jCAxis.getWidth();
                            }
                        } else if (this.draw3D) {
                            jCAxis.move(n7, jCAxis.getTop());
                        } else {
                            jCAxis.move(n7, jCAxis.getTop());
                            n7 += jCAxis.getWidth();
                        }
                    }
                } else if (jCAxis.isTopSide()) {
                    if (this.getPlotArea().getTopIsDefault()) {
                        if (this.draw3D) {
                            jCAxis.move(jCAxis.getLeft(), n8 + n3 - jCAxis.getHeight());
                        } else {
                            jCAxis.move(jCAxis.getLeft(), n8);
                            n8 += jCAxis.getHeight();
                        }
                    } else if (this.draw3D) {
                        jCAxis.move(jCAxis.getLeft(), n8 - jCAxis.getHeight());
                    } else {
                        jCAxis.move(jCAxis.getLeft(), n8 - n3);
                        n8 += jCAxis.getHeight();
                    }
                } else if (jCAxis.isBottomSide()) {
                    if (this.getPlotArea().getBottomIsDefault()) {
                        if (this.draw3D) {
                            jCAxis.move(jCAxis.getLeft(), n9 - n4);
                        } else {
                            jCAxis.move(jCAxis.getLeft(), n9 - n4);
                            n9 += jCAxis.getHeight();
                        }
                    } else if (this.draw3D) {
                        jCAxis.move(jCAxis.getLeft(), n9);
                    } else {
                        jCAxis.move(jCAxis.getLeft(), n9);
                        n9 += jCAxis.getHeight();
                    }
                }
            }
            ++n10;
        }
        if (this.getPlotArea().getLeftIsDefault()) {
            this.plotRect.x += n;
            this.plotRect.width -= n;
        }
        if (this.getPlotArea().getRightIsDefault()) {
            this.plotRect.width -= n2;
        }
        if (this.getPlotArea().getTopIsDefault()) {
            this.plotRect.y += n3;
            this.plotRect.height -= n3;
        }
        if (this.getPlotArea().getBottomIsDefault()) {
            this.plotRect.height -= n4;
        }
    }

    private void calc3D() {
        ChartDataView[] chartDataViewArray;
        double d = JCChartUtil.degToRad(this.rotation);
        double d2 = JCChartUtil.degToRad(this.elevation);
        double d3 = Math.sin(d);
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = (double)this.depth / 100.0;
        double d7 = JCChartUtil.max(1.0, this.size().width);
        double d8 = (d7 /= 1.0 + JCChartUtil.abs(d3) * d5 * d6) * d6;
        this.deltaX = (int)(d8 * d3 * d5);
        this.deltaY = (int)(-d8 * d4);
        this.checkDeltaValues();
        boolean bl = true;
        JCChart jCChart = this.getParent();
        if (jCChart != null && (chartDataViewArray = jCChart.getDataView()) != null) {
            int n = 0;
            while (n < chartDataViewArray.length) {
                if (chartDataViewArray[n].getChartType() != 0 && chartDataViewArray[n].getChartType() != 1 && chartDataViewArray[n].getChartType() != 12 && chartDataViewArray[n].getChartType() != 8 && chartDataViewArray[n].getChartType() != 5 && chartDataViewArray[n].getChartType() != 6 && chartDataViewArray[n].getChartType() != 7) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        boolean bl2 = this.deltaX != 0 || this.deltaY != 0;
        this.hasBar = bl ^ true;
        this.draw3D = !bl && bl2;
    }

    void calcAnchors(JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            jCAxis.calcAnchors();
            ++n;
        }
    }

    private void calcAnnotationExtents(JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            jCAxis.calcAnnotationExtents();
            ++n;
        }
    }

    private void calcAxisParams(JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            if (jCAxis.formula != null) {
                bl = true;
            }
            jCAxis.calcAxisParams(true);
            ++n;
        }
        if (!bl) {
            return;
        }
        int n2 = 0;
        while (n2 < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n2);
            if (jCAxis.formula != null) {
                jCAxis.formula.calcRelatedParams();
            }
            ++n2;
        }
    }

    private synchronized void calcGraphExtents() {
        Enumeration enumeration = this.drawables.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ChartDraw chartDraw = (ChartDraw)this.drawables.get(k);
            chartDraw.recalc();
        }
    }

    void calcLimits() {
        this.clearLimits();
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return;
        }
        int n = 0;
        while (n < this.getParent().data.size()) {
            ChartDataView chartDataView = (ChartDataView)jCChart.data.elementAt(n);
            if (chartDataView.getIsShowing()) {
                chartDataView.calcLimits();
            }
            ++n;
        }
    }

    private void calcTransformation(JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            jCAxis.calcTransformation();
            ++n;
        }
    }

    void cancel() {
        this.handler = null;
        this.inAction = false;
        this.setChanged(true, 2);
    }

    void checkAnnotations(JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            jCAxis.checkAnnotations();
            ++n;
        }
    }

    private boolean checkDeltaValues() {
        boolean bl = false;
        if (this.plotRect.width <= 0 || this.plotRect.height <= 0) {
            return bl;
        }
        int n = this.plotRect.width;
        if (Math.abs(this.deltaX) > n) {
            this.deltaX = this.deltaX < 0 ? -n : n;
            bl = true;
        }
        n = this.plotRect.height;
        if (Math.abs(this.deltaY) > n) {
            this.deltaY = this.deltaY < 0 ? -n : n;
            bl = true;
        }
        return bl;
    }

    synchronized void clearDrawables() {
        this.drawables = null;
    }

    void clearLimits() {
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return;
        }
        int n = 0;
        while (n < jCChart.data.size()) {
            ChartDataView chartDataView = (ChartDataView)jCChart.data.elementAt(n);
            chartDataView.clearLimits();
            ++n;
        }
    }

    Graphics clipForDrawing(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        int n = 6;
        int n2 = Math.max(0, this.plotRect.x - n / 2);
        int n3 = Math.max(0, this.plotRect.y - n / 2);
        int n4 = Math.min(this.plotRect.width + 1 + n, this.chartAreaRect.width - n2);
        int n5 = Math.min(this.plotRect.height + 1 + n, this.chartAreaRect.height - n3);
        graphics2.clipRect(n2, n3, n4, n5);
        return graphics2;
    }

    private Graphics clipToEntirePlotRect(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Graphics graphics2 = graphics.create();
        if (this.axisBoundingBox) {
            n4 = this.plotRect.x + 1;
            n3 = this.plotRect.y + 1;
            n2 = this.plotRect.width - 1;
            n = this.plotRect.height - 1;
        } else {
            n4 = this.plotRect.x;
            n3 = this.plotRect.y;
            n2 = this.plotRect.width + 1;
            n = this.plotRect.height + 1;
        }
        n4 = Math.max(0, n4);
        n3 = Math.max(0, n3);
        n2 = Math.min(n2, this.chartAreaRect.width - n4);
        n = Math.min(n, this.chartAreaRect.height - n3);
        graphics2.clipRect(n4, n3, n2, n);
        return graphics2;
    }

    public void draw(Graphics graphics) {
        if (this.getParent() == null) {
            return;
        }
        if (graphics == null) {
            return;
        }
        if (!this.isShowing) {
            return;
        }
        Object object = this.getRegionLock();
        synchronized (object) {
            Graphics graphics2 = graphics.create();
            super.draw(graphics2);
            Rectangle rectangle = this.getDrawingArea();
            graphics2.translate(rectangle.x, rectangle.y);
            Graphics graphics3 = graphics2.create();
            graphics3.clipRect(0, 0, this.chartAreaRect.width, this.chartAreaRect.height);
            Graphics graphics4 = null;
            JCChart jCChart = this.getParent();
            try {
                graphics4 = this.clipForDrawing(graphics2);
                this.drawBackplane(graphics4);
                Graphics graphics5 = this.clipToEntirePlotRect(graphics2);
                if (this.draw3D) {
                    Changeable changeable;
                    Changeable changeable2;
                    this.ensureDrawables();
                    JCAxis jCAxis = null;
                    JCAxis jCAxis2 = null;
                    int n = 0;
                    while (n < jCChart.data.size()) {
                        ChartDataView chartDataView = jCChart.getDataView(n);
                        if (this.is3DChartType(chartDataView.chartType)) {
                            jCAxis = chartDataView.getXAxis();
                            jCAxis2 = chartDataView.getYAxis();
                            break;
                        }
                        ++n;
                    }
                    if (this.axisDrawOkay) {
                        this.preDraw3DAxes(graphics5, jCAxis, jCAxis2);
                        graphics4.setColor(this.plotArea.getForeground());
                        graphics4.drawRect(this.backplane.x, this.backplane.y, this.backplane.width, this.backplane.height);
                        if (!this.fastAction || !this.inAction) {
                            this.preDrawGrids(graphics5, this.xaxes);
                            this.preDrawGrids(graphics5, this.yaxes);
                        }
                        if (jCAxis.isShowing) {
                            jCAxis.preDrawOutlineTrough(graphics5);
                        }
                        if (jCAxis2.isShowing) {
                            jCAxis2.preDrawOutlineTrough(graphics5);
                        }
                    }
                    if (this.axisDrawOkay) {
                        this.drawBpAxes(graphics3, this.xaxes);
                        this.drawBpAxes(graphics3, this.yaxes);
                        if (!this.fastAction || !this.inAction) {
                            this.drawBpAxisAnnotationsAndTitle(graphics3, this.xaxes);
                            this.drawBpAxisAnnotationsAndTitle(graphics3, this.yaxes);
                        }
                    }
                    int n2 = 0;
                    while (n2 < jCChart.data.size()) {
                        ChartDataView chartDataView = jCChart.getDataView(n2);
                        changeable2 = this.getDrawable(chartDataView);
                        if (changeable2 != null && !((ChartDraw)changeable2).drawFront && !chartDataView.is3DChartType()) {
                            if (chartDataView.chartType == 0 || chartDataView.chartType == 1) {
                                ((ChartDraw)changeable2).draw(graphics4);
                            } else {
                                ((ChartDraw)changeable2).draw(graphics5);
                            }
                        }
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < jCChart.data.size()) {
                        changeable2 = jCChart.getDataView(n3);
                        changeable = this.getDrawable((ChartDataView)changeable2);
                        if (changeable != null && ((ChartDataView)changeable2).is3DChartType()) {
                            if (((ChartDataView)changeable2).chartType == 0 || ((ChartDataView)changeable2).chartType == 1) {
                                ((ChartDraw)changeable).draw(graphics4);
                            } else {
                                ((ChartDraw)changeable).draw(graphics5);
                            }
                        }
                        ++n3;
                    }
                    if (this.axisDrawOkay) {
                        this.drawFpAxes(graphics3, this.xaxes);
                        this.drawFpAxes(graphics3, this.yaxes);
                        if (!this.fastAction || !this.inAction) {
                            this.drawFpAxisAnnotationsAndTitle(graphics3, this.xaxes);
                            this.drawFpAxisAnnotationsAndTitle(graphics3, this.yaxes);
                        }
                    }
                    int n4 = 0;
                    while (n4 < jCChart.data.size()) {
                        changeable = jCChart.getDataView(n4);
                        ChartDraw chartDraw = this.getDrawable((ChartDataView)changeable);
                        if (chartDraw != null && !((ChartDataView)changeable).is3DChartType() && chartDraw.drawFront) {
                            if (((ChartDataView)changeable).chartType == 0 || ((ChartDataView)changeable).chartType == 1) {
                                chartDraw.draw(graphics4);
                            } else {
                                chartDraw.draw(graphics5);
                            }
                        }
                        ++n4;
                    }
                } else {
                    Changeable changeable;
                    if (!(!this.axisDrawOkay || this.fastAction && this.inAction)) {
                        this.preDrawGrids(graphics5, this.xaxes);
                        this.preDrawGrids(graphics5, this.yaxes);
                    }
                    this.ensureDrawables();
                    int n = 0;
                    while (n < jCChart.data.size()) {
                        ChartDataView chartDataView = jCChart.getDataView(n);
                        changeable = (ChartDraw)this.drawables.get(chartDataView);
                        if (changeable != null && chartDataView.chartType != 0 && chartDataView.chartType != 1) {
                            ((ChartDraw)changeable).draw(graphics5);
                        }
                        ++n;
                    }
                    if (this.axisDrawOkay) {
                        this.drawAxes(graphics3, this.xaxes);
                        this.drawAxes(graphics3, this.yaxes);
                        if (!this.fastAction || !this.inAction) {
                            this.drawAxisAnnotationsAndTitle(graphics3, this.xaxes);
                            this.drawAxisAnnotationsAndTitle(graphics3, this.yaxes);
                        }
                    }
                    int n5 = 0;
                    while (n5 < jCChart.data.size()) {
                        changeable = jCChart.getDataView(n5);
                        ChartDraw chartDraw = (ChartDraw)this.drawables.get(changeable);
                        if (chartDraw != null && (((ChartDataView)changeable).chartType == 0 || ((ChartDataView)changeable).chartType == 1)) {
                            chartDraw.draw(graphics4);
                        }
                        ++n5;
                    }
                }
                if (graphics5 != null) {
                    graphics5.dispose();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            if (graphics4 != null) {
                graphics4.dispose();
            }
            if (graphics2 != null) {
                graphics2.dispose();
            }
            if (graphics3 != null) {
                graphics3.dispose();
            }
            this.rbGC = graphics;
            if (this.handler != null) {
                this.handler.reanimate(this.last.x, this.last.y);
            }
            this.rbGC = null;
        }
        this.setChanged(false, 0);
    }

    private void drawAxes(Graphics graphics, JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            if (jCAxis.isShowing) {
                jCAxis.draw(graphics);
            }
            ++n;
        }
    }

    private void drawAxisAnnotationsAndTitle(Graphics graphics, JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            if (jCAxis.isShowing) {
                jCAxis.drawAnnotationsAndTitle(graphics);
            }
            ++n;
        }
    }

    private void drawBackplane(Graphics graphics) {
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return;
        }
        if (jCChart.data.size() == 1 && ((ChartDataView)jCChart.data.elementAt(0)).getChartType() == 11) {
            return;
        }
        JCFillStyle jCFillStyle = new JCFillStyle(this.plotArea.getBackground(), 1);
        boolean bl = false;
        if (bl) {
            System.out.println(JCChartBundle.string("jclass.chart.Key122"));
        } else {
            int n = this.plotRect.x;
            int n2 = this.plotRect.y;
            int n3 = this.plotRect.width;
            int n4 = this.plotRect.height;
            if (this.draw3D || this.axisBoundingBox) {
                if (this.draw3D && this.deltaX > 0) {
                    n += this.deltaX;
                }
                if (this.draw3D && this.deltaY > 0) {
                    n2 += this.deltaY;
                }
                int n5 = this.draw3D ? JCChartUtil.abs(this.deltaX) : 0;
                int n6 = this.draw3D ? JCChartUtil.abs(this.deltaY) : 0;
                n3 = Math.max(0, n3 - n5);
                n4 = Math.max(0, n4 - n6);
                jCFillStyle.fillRect(graphics, n, n2, n3, n4);
                graphics.setColor(this.plotArea.getForeground());
                graphics.drawRect(n, n2, n3, n4);
                this.backplane = new Rectangle(n, n2, n3, n4);
            } else {
                jCFillStyle.fillRect(graphics, n, n2, n3, n4);
                this.backplane = new Rectangle(n, n2, n3, n4);
            }
        }
    }

    private void drawBpAxes(Graphics graphics, JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            if (jCAxis.isShowing && !jCAxis.isBar()) {
                jCAxis.draw(graphics);
            }
            ++n;
        }
    }

    private void drawBpAxisAnnotationsAndTitle(Graphics graphics, JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            if (jCAxis.isShowing && !jCAxis.isBar()) {
                jCAxis.drawAnnotationsAndTitle(graphics);
            }
            ++n;
        }
    }

    private void drawFpAxes(Graphics graphics, JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            if (jCAxis.isShowing && jCAxis.isBar()) {
                jCAxis.draw(graphics);
            }
            ++n;
        }
    }

    private void drawFpAxisAnnotationsAndTitle(Graphics graphics, JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            if (jCAxis.isShowing && jCAxis.isBar()) {
                jCAxis.drawAnnotationsAndTitle(graphics);
            }
            ++n;
        }
    }

    void drawRubberBand(Point point, Point point2) {
        Graphics graphics;
        if (point == null) {
            return;
        }
        if (point.x == point2.x || point.y == point2.y) {
            return;
        }
        int n = point2.x;
        int n2 = point2.y;
        int n3 = point.x;
        int n4 = point.y;
        Graphics graphics2 = graphics = this.rbGC == null ? this.getGraphics().create() : this.rbGC.create();
        if (this.rbGC == null) {
            JCChart jCChart = this.getParent();
            if (jCChart == null) {
                return;
            }
            Rectangle rectangle = jCChart.getDrawingArea();
            graphics.translate(rectangle.x, rectangle.y);
        }
        if (n3 - n < 0) {
            int n5 = n3;
            n3 = n;
            n = n5;
        }
        if (n4 - n2 < 0) {
            int n6 = n4;
            n4 = n2;
            n2 = n6;
        }
        graphics.setXORMode(Color.white);
        graphics.drawRect(n, n2, n3 - n, n4 - n2);
        graphics.setXORMode(Color.black);
        graphics.drawRect(n + 1, n2 + 1, n3 - n, n4 - n2);
        if (this.rbGC == null) {
            graphics.dispose();
        }
    }

    void drawRubberLine(Point point, Point point2) {
        if (point == null || point2 == null) {
            return;
        }
        Graphics graphics = this.getGraphics().create();
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return;
        }
        Rectangle rectangle = jCChart.getDrawingArea();
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setXORMode(Color.white);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.setXORMode(Color.black);
        graphics.drawLine(point.x + 1, point.y + 1, point2.x + 1, point2.y + 1);
        graphics.dispose();
    }

    void endAction(int n, int n2) {
        if (this.handler == null) {
            return;
        }
        ActionHandler actionHandler = this.handler;
        this.handler = null;
        actionHandler.end(n, n2);
    }

    private synchronized void ensureDrawables() {
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return;
        }
        if (this.drawables == null) {
            this.drawables = new Hashtable();
        }
        this.axisDrawOkay = false;
        int n = 0;
        while (n < jCChart.data.size()) {
            ChartDataView chartDataView = (ChartDataView)jCChart.data.elementAt(n);
            if (!this.hasMatchingDrawable(chartDataView) && chartDataView.getIsShowing()) {
                this.addDrawable(chartDataView);
            } else if (this.hasMatchingDrawable(chartDataView) && !chartDataView.getIsShowing()) {
                this.removeDrawable(chartDataView);
            }
            if (chartDataView.getChartType() != 11) {
                this.axisDrawOkay = true;
            }
            ++n;
        }
    }

    private void findMaxExtents(JCVector jCVector, Extents extents) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            Extents extents2 = jCAxis.getExtents();
            if (extents2 != null) {
                if (extents2.major > extents.major) {
                    extents.major = extents2.major;
                }
                if (extents2.minor > extents.minor) {
                    extents.minor = extents2.minor;
                }
                if (extents2.ortho > extents.ortho) {
                    extents.ortho = extents2.ortho;
                }
            }
            ++n;
        }
    }

    public int getAngleUnit() {
        return this.angleUnit;
    }

    public boolean getAxisBoundingBox() {
        return this.axisBoundingBox;
    }

    public boolean getChanged() {
        return super.getChanged() || this.isDirty();
    }

    public int getDepth() {
        return this.depth;
    }

    synchronized ChartDraw getDrawable(ChartDataView chartDataView) {
        ChartDraw chartDraw = null;
        if (this.drawables.containsKey(chartDataView)) {
            ChartDraw chartDraw2 = (ChartDraw)this.drawables.get(chartDataView);
            if (chartDraw2.chartType == chartDraw2.dataObject.getChartType()) {
                chartDraw = chartDraw2;
            }
        }
        return chartDraw;
    }

    public int getElevation() {
        return this.elevation;
    }

    public boolean getFastAction() {
        return this.fastAction;
    }

    public JCAxis getHorizActionAxis() {
        return this.horizActionAxis;
    }

    private void getHorizVertAxes(JCVector jCVector, JCVector jCVector2) {
        int n = 0;
        while (n < this.xaxes.size()) {
            JCAxis jCAxis = (JCAxis)this.xaxes.elementAt(n);
            if (jCAxis.isVertical) {
                jCVector2.addElement(jCAxis);
            } else {
                jCVector.addElement(jCAxis);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.yaxes.size()) {
            JCAxis jCAxis = (JCAxis)this.yaxes.elementAt(n2);
            if (jCAxis.isVertical) {
                jCVector2.addElement(jCAxis);
            } else {
                jCVector.addElement(jCAxis);
            }
            ++n2;
        }
    }

    public JCMarker getMarker(int n) {
        JCMarker jCMarker = null;
        try {
            jCMarker = (JCMarker)this.markers.elementAt(n);
        }
        catch (Exception exception) {}
        return jCMarker;
    }

    public JCMarker[] getMarkers() {
        if (this.markers == null || this.markers.size() == 0) {
            return null;
        }
        JCMarker[] jCMarkerArray = new JCMarker[this.markers.size()];
        int n = 0;
        while (n < jCMarkerArray.length) {
            jCMarkerArray[n] = (JCMarker)this.markers.elementAt(n);
            ++n;
        }
        return jCMarkerArray;
    }

    public PlotArea getPlotArea() {
        if (this.plotArea == null) {
            this.plotArea = new PlotArea(this);
        }
        return this.plotArea;
    }

    public int getRotation() {
        return this.rotation;
    }

    public JCAxis getVertActionAxis() {
        return this.vertActionAxis;
    }

    public synchronized JCAxis[] getXAxis() {
        if (this.xaxes == null || this.xaxes.size() == 0) {
            return null;
        }
        JCAxis[] jCAxisArray = new JCAxis[this.xaxes.size()];
        int n = 0;
        while (n < jCAxisArray.length) {
            jCAxisArray[n] = (JCAxis)this.xaxes.elementAt(n);
            ++n;
        }
        return jCAxisArray;
    }

    public JCAxis getXAxis(int n) {
        if (this.xaxes == null) {
            return null;
        }
        return (JCAxis)this.xaxes.elementAt(n);
    }

    public synchronized JCAxis[] getYAxis() {
        if (this.yaxes == null || this.yaxes.size() == 0) {
            return null;
        }
        JCAxis[] jCAxisArray = new JCAxis[this.yaxes.size()];
        int n = 0;
        while (n < jCAxisArray.length) {
            jCAxisArray[n] = (JCAxis)this.yaxes.elementAt(n);
            ++n;
        }
        return jCAxisArray;
    }

    public JCAxis getYAxis(int n) {
        if (this.yaxes == null) {
            return null;
        }
        return (JCAxis)this.yaxes.elementAt(n);
    }

    synchronized boolean hasMatchingDrawable(ChartDataView chartDataView) {
        if (this.drawables.containsKey(chartDataView)) {
            ChartDraw chartDraw = (ChartDraw)this.drawables.get(chartDataView);
            if (chartDraw.chartType == chartDraw.dataObject.getChartType()) {
                return true;
            }
        }
        return false;
    }

    private boolean is3DChartType(int n) {
        return n == 9 || n == 10;
    }

    public boolean isDirty() {
        this.ensureDrawables();
        Enumeration enumeration = this.drawables.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ChartDraw chartDraw = (ChartDraw)this.drawables.get(k);
            if (!chartDraw.dataObject.isChanged()) continue;
            return true;
        }
        int n = 0;
        while (n < this.xaxes.size()) {
            if (((JCAxis)this.xaxes.elementAt(n)).isChanged()) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.yaxes.size()) {
            if (((JCAxis)this.yaxes.elementAt(n2)).isChanged()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isXAxis(JCAxis jCAxis) {
        return this.xaxes.contains(jCAxis);
    }

    void layoutAnnotations(JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            jCAxis.layoutAnnotations();
            ++n;
        }
    }

    private void layoutAxes(JCVector jCVector, boolean bl) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            jCAxis.layoutAxis(bl);
            ++n;
        }
    }

    public void layoutChartArea() {
        this.resetPlotArea();
        int n = this.chartAreaRect.width - this.plotArea.left.value - this.plotArea.right.value;
        int n2 = this.chartAreaRect.height - this.plotArea.top.value - this.plotArea.bottom.value;
        this.plotRect = new Rectangle(this.plotArea.left.value, this.plotArea.top.value, n, n2);
        JCVector jCVector = new JCVector();
        JCVector jCVector2 = new JCVector();
        this.getHorizVertAxes(jCVector2, jCVector);
        this.adjustPlotRectForAxes(this.xaxes);
        this.adjustPlotRectForAxes(this.yaxes);
        this.layoutAxes(this.xaxes, false);
        this.layoutAxes(this.yaxes, false);
        this.adjustForExtents(jCVector2, jCVector);
        this.layoutAxes(this.xaxes, true);
        this.layoutAxes(this.yaxes, true);
        this.layoutOrigins(this.xaxes);
        this.layoutOrigins(this.yaxes);
        this.adjustForOrthoExtents(jCVector2, jCVector);
        if (!this.inAction || !this.fastAction) {
            this.layoutAnnotations(this.xaxes);
            this.layoutAnnotations(this.yaxes);
            this.checkAnnotations(this.xaxes);
            this.checkAnnotations(this.yaxes);
        }
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = this.plotRect.y;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = this.plotRect.x;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = this.chartAreaRect.height - this.plotRect.y - this.plotRect.height;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = this.chartAreaRect.width - this.plotRect.x - this.plotRect.width;
        }
    }

    private void layoutOrigins(JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            jCAxis.layoutOrigin();
            ++n;
        }
    }

    public void loadParams(String string, JCChart jCChart) {
        super.loadParams(string, jCChart);
        this.axisHashtable = new Hashtable();
        this.setAxisBoundingBox(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".axisBoundingBox"), this.getAxisBoundingBox()));
        this.setDepth(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".depth"), this.getDepth()));
        this.setElevation(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".elevation"), this.getElevation()));
        this.setRotation(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".rotation"), this.getRotation()));
        if (jCChart.getParam(String.valueOf(string) + ".angleUnit") != null) {
            this.setAngleUnit(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".angleUnit"), String.valueOf(string) + " angle unit", angleUnit_strings, angleUnit_values, this.getAngleUnit()));
        }
        this.setFastAction(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".fastAction"), this.getFastAction()));
        this.getPlotArea().loadParams(String.valueOf(string) + ".plotArea", jCChart);
        this.axisHashtable.put("xaxis", this.getXAxis(0));
        this.axisHashtable.put("yaxis", this.getYAxis(0));
        this.getXAxis(0).loadParams("xaxis", jCChart);
        this.getYAxis(0).loadParams("yaxis", jCChart);
        int n = 1;
        while (n < 100) {
            String string2;
            String string3 = jCChart.getParam(String.valueOf(string) + ".xaxisName" + n);
            if (string3 != null) {
                JCAxis jCAxis = new JCAxis(this, false, 0);
                this.addAxis(this.xaxes.size(), this.xaxes, jCAxis);
                this.axisHashtable.put(string3, jCAxis);
                jCAxis.loadParams(string3, jCChart);
            }
            if ((string2 = jCChart.getParam(String.valueOf(string) + ".yaxisName" + n)) != null) {
                JCAxis jCAxis = new JCAxis(this, true, 0);
                this.addAxis(this.yaxes.size(), this.yaxes, jCAxis);
                this.axisHashtable.put(string2, jCAxis);
                jCAxis.loadParams(string2, jCChart);
            }
            ++n;
        }
        JCChartConverter jCChartConverter = new JCChartConverter();
        String string4 = jCChart.getParam(String.valueOf(string) + ".horizActionAxis");
        if (string4 != null) {
            this.setHorizActionAxis(jCChartConverter.toAxis(jCChart, string4, this.getHorizActionAxis()));
        }
        if ((string4 = jCChart.getParam(String.valueOf(string) + ".vertActionAxis")) != null) {
            this.setVertActionAxis(jCChartConverter.toAxis(jCChart, string4, this.getVertActionAxis()));
        }
    }

    private void makeAnnotations(JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            jCAxis.makeAnnotations();
            ++n;
        }
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    JCDataIndex pick(Point point, ChartDataView chartDataView, int n) {
        Changeable changeable;
        Changeable changeable2;
        JCDataIndex jCDataIndex = null;
        ChartDraw chartDraw = null;
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return null;
        }
        if (chartDataView != null) {
            chartDraw = this.getDrawable(chartDataView);
            if (chartDraw != null) {
                jCDataIndex = chartDraw.pick(point, n == -1 ? chartDataView.pickFocus : n);
            }
            if (jCDataIndex != null) {
                jCDataIndex.obj = this;
                jCDataIndex.dataView = chartDataView;
            }
            return jCDataIndex;
        }
        int n2 = jCChart.data.size() - 1;
        while (n2 >= 0) {
            ChartDataView chartDataView2 = jCChart.getDataView(n2);
            changeable2 = this.getDrawable(chartDataView2);
            if (changeable2 != null && !chartDataView2.is3DChartType() && ((ChartDraw)changeable2).drawFront) {
                jCDataIndex = this.pickOne((ChartDraw)changeable2, point, n, jCDataIndex);
            }
            --n2;
        }
        int n3 = jCChart.data.size() - 1;
        while (n3 >= 0) {
            changeable2 = jCChart.getDataView(n3);
            changeable = this.getDrawable((ChartDataView)changeable2);
            if (changeable != null && ((ChartDataView)changeable2).is3DChartType()) {
                jCDataIndex = this.pickOne((ChartDraw)changeable, point, n, jCDataIndex);
            }
            --n3;
        }
        int n4 = jCChart.data.size() - 1;
        while (n4 >= 0) {
            changeable = jCChart.getDataView(n4);
            ChartDraw chartDraw2 = this.getDrawable((ChartDataView)changeable);
            if (chartDraw2 != null && !chartDraw2.drawFront && !((ChartDataView)changeable).is3DChartType()) {
                jCDataIndex = this.pickOne(chartDraw2, point, n, jCDataIndex);
            }
            --n4;
        }
        return jCDataIndex;
    }

    private JCDataIndex pickOne(ChartDraw chartDraw, Point point, int n, JCDataIndex jCDataIndex) {
        JCDataIndex jCDataIndex2 = chartDraw.pick(point, n == -1 ? chartDraw.dataObject.pickFocus : n);
        if (jCDataIndex2 != null) {
            jCDataIndex2.obj = this;
            jCDataIndex2.dataView = chartDraw.dataObject;
        }
        if (jCDataIndex == null) {
            jCDataIndex = jCDataIndex2;
        } else if (jCDataIndex2 != null && jCDataIndex.distance > jCDataIndex2.distance) {
            jCDataIndex = jCDataIndex2;
        }
        return jCDataIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void preDraw3DAxes(Graphics graphics, JCAxis jCAxis, JCAxis jCAxis2) {
        block55: {
            block57: {
                block56: {
                    boolean bl;
                    block59: {
                        int n;
                        block58: {
                            int n2;
                            boolean bl2;
                            block50: {
                                block52: {
                                    block51: {
                                        boolean bl3;
                                        block54: {
                                            block53: {
                                                block49: {
                                                    block48: {
                                                        block47: {
                                                            block46: {
                                                                if (jCAxis == null) return;
                                                                if (jCAxis2 == null) {
                                                                    return;
                                                                }
                                                                bl2 = jCAxis.isVertical;
                                                                n = jCAxis.getPlacement();
                                                                n2 = jCAxis2.getPlacement();
                                                                if (n != 5) break block46;
                                                                if (jCAxis2.getOrigin() == jCAxis2.getMax()) {
                                                                    n = 2;
                                                                    break block47;
                                                                } else if (jCAxis2.getOrigin() == jCAxis2.getMin()) {
                                                                    n = 1;
                                                                }
                                                                break block47;
                                                            }
                                                            if (n == 4) {
                                                                if (jCAxis.getPlacementLocation() == jCAxis2.getMax()) {
                                                                    n = 2;
                                                                } else if (jCAxis.getPlacementLocation() == jCAxis2.getMin()) {
                                                                    n = 1;
                                                                }
                                                            }
                                                        }
                                                        if (n2 != 5) break block48;
                                                        if (jCAxis.getOrigin() == jCAxis.getMax()) {
                                                            n2 = 2;
                                                            break block49;
                                                        } else if (jCAxis.getOrigin() == jCAxis.getMin()) {
                                                            n2 = 1;
                                                        }
                                                        break block49;
                                                    }
                                                    if (n2 == 4) {
                                                        if (jCAxis2.getPlacementLocation() == jCAxis.getMax()) {
                                                            n2 = 2;
                                                        } else if (jCAxis2.getPlacementLocation() == jCAxis.getMin()) {
                                                            n2 = 1;
                                                        }
                                                    }
                                                }
                                                if (jCAxis.getIsReversed()) {
                                                    if (n2 == 1) {
                                                        n2 = 2;
                                                    } else if (n2 == 2) {
                                                        n2 = 1;
                                                    }
                                                }
                                                if (jCAxis2.getIsReversed()) {
                                                    if (n == 1) {
                                                        n = 2;
                                                    } else if (n == 2) {
                                                        n = 1;
                                                    }
                                                }
                                                if (jCAxis.isShowing) {
                                                    jCAxis.preDrawCalc();
                                                }
                                                if (jCAxis2.isShowing) {
                                                    jCAxis2.preDrawCalc();
                                                }
                                                if (this.deltaX < 0 || this.deltaY >= 0) break block50;
                                                if (n2 != 1 && n2 != 2 && n != 1 && n != 2) {
                                                    if (jCAxis2.isShowing) {
                                                        jCAxis2.preDraw(graphics, false, true);
                                                    }
                                                    if (jCAxis.isShowing) {
                                                        jCAxis.preDraw(graphics, true, false);
                                                    }
                                                    if (!jCAxis2.isShowing) return;
                                                    jCAxis2.preDraw(graphics, false, false);
                                                    return;
                                                }
                                                if (n2 == 2) break block51;
                                                if (n2 == 2 || n2 == 1) break block52;
                                                if (!bl2) break block53;
                                                if (n == 1) break block51;
                                                bl3 = false;
                                                break block54;
                                            }
                                            if (n != 2) break block51;
                                            bl3 = false;
                                        }
                                        if (!bl3) break block52;
                                    }
                                    if (jCAxis.isShowing) {
                                        jCAxis.preDraw(graphics, true, false);
                                    }
                                    if (!jCAxis2.isShowing) return;
                                    jCAxis2.preDraw(graphics, true, false);
                                    return;
                                }
                                if (jCAxis2.isShowing) {
                                    jCAxis2.preDraw(graphics, true, false);
                                }
                                if (!jCAxis.isShowing) return;
                                jCAxis.preDraw(graphics, true, false);
                                return;
                            }
                            if (this.deltaX >= 0 || this.deltaY < 0) break block55;
                            if (n2 != 1 && n2 != 2 && n != 1 && n != 2) {
                                if (jCAxis2.isShowing) {
                                    jCAxis.preDraw(graphics, false, false);
                                }
                                if (jCAxis.isShowing) {
                                    jCAxis2.preDraw(graphics, true, false);
                                }
                                if (!jCAxis2.isShowing) return;
                                jCAxis.preDraw(graphics, false, true);
                                return;
                            }
                            if (n2 == 1) break block56;
                            if (n2 == 2 || n2 == 1) break block57;
                            if (!bl2) break block58;
                            if (n != 1) break block56;
                            bl = false;
                            break block59;
                        }
                        if (n == 2) break block56;
                        bl = false;
                    }
                    if (!bl) break block57;
                }
                if (jCAxis.isShowing) {
                    jCAxis.preDraw(graphics, true, false);
                }
                if (!jCAxis2.isShowing) return;
                jCAxis2.preDraw(graphics, true, false);
                return;
            }
            if (jCAxis2.isShowing) {
                jCAxis2.preDraw(graphics, true, false);
            }
            if (!jCAxis.isShowing) return;
            jCAxis.preDraw(graphics, true, false);
            return;
        }
        if (jCAxis.isShowing) {
            jCAxis.preDraw(graphics, true, false);
        }
        if (!jCAxis2.isShowing) return;
        jCAxis2.preDraw(graphics, true, false);
    }

    private void preDrawGrids(Graphics graphics, JCVector jCVector) {
        if (jCVector == null) {
            return;
        }
        int n = 0;
        while (n < jCVector.size()) {
            JCAxis jCAxis = (JCAxis)jCVector.elementAt(n);
            if (jCAxis.isShowing) {
                jCAxis.drawGrid(graphics);
            }
            ++n;
        }
    }

    public Dimension preferredSize() {
        JCChart jCChart = this.getParent();
        Dimension dimension = new Dimension();
        if (dimension != null || dimension.width <= 0 || dimension.height <= 0) {
            dimension = super.preferredSize();
            dimension.width = 100;
            dimension.height = 100;
        }
        return dimension;
    }

    public void recalc() {
        if (this.getParent() == null || this.getParent().getPeer() == null) {
            return;
        }
        if (!this.isChanged()) {
            return;
        }
        Object object = this.getRegionLock();
        synchronized (object) {
            block15: {
                block14: {
                    this.ensureDrawables();
                    if (this.size().width <= 0) break block14;
                    if (this.size().height > 0) break block15;
                }
                Object var2_2 = null;
                return;
            }
            try {
                this.resetPlotArea();
                this.calc3D();
                this.calcLimits();
                this.calcAxisParams(this.xaxes);
                this.calcAxisParams(this.yaxes);
                if (!this.inAction || !this.fastAction) {
                    this.calcAnchors(this.xaxes);
                    this.calcAnchors(this.yaxes);
                    this.makeAnnotations(this.xaxes);
                    this.makeAnnotations(this.yaxes);
                    this.calcAnnotationExtents(this.xaxes);
                    this.calcAnnotationExtents(this.yaxes);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            this.layoutChartArea();
            if (this.checkDeltaValues()) {
                this.layoutChartArea();
            }
            this.calcGraphExtents();
            if (!this.inAction || !this.fastAction) {
                this.getParent().markAllChartLabelsForRecalc();
            }
            this.needsRepaint = true;
        }
        this.setChanged(false, 0);
    }

    private void removeAxis(int n, JCVector jCVector) {
        if (n < jCVector.size()) {
            jCVector.removeElementAt(n);
        }
    }

    synchronized void removeDrawable(ChartDataView chartDataView) {
        if (this.drawables != null) {
            this.drawables.remove(chartDataView);
        }
    }

    public void repaint() {
        if (this.size().width <= 0 || this.size().height <= 0) {
            return;
        }
        if (this.inSuperReshape) {
            return;
        }
        super.repaint();
    }

    private void replaceAxis(int n, JCVector jCVector, JCAxis jCAxis) {
        jCVector.setElementAt(jCAxis, n);
    }

    void reset() {
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return;
        }
        boolean bl = jCChart.getIsBatched();
        jCChart.setIsBatched(true);
        if (this.horizActionAxis != null) {
            this.horizActionAxis.min.isDefault = true;
            this.horizActionAxis.max.isDefault = true;
            this.horizActionAxis.setChanged(true, 2, false);
            jCChart.sendEvent(this.horizActionAxis);
        }
        if (this.vertActionAxis != null) {
            this.vertActionAxis.min.isDefault = true;
            this.vertActionAxis.max.isDefault = true;
            this.vertActionAxis.setChanged(true, 2, false);
            jCChart.sendEvent(this.vertActionAxis);
        }
        this.cancel();
        jCChart.setIsBatched(bl);
    }

    private void resetPlotArea() {
        this.chartAreaRect = this.getDrawingArea();
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = 0;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = 0;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = 0;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = 0;
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n == this.location().x && n2 == this.location().y && n3 == this.size().width && n4 == this.size().height) {
            return;
        }
        this.inSuperReshape = true;
        super.reshape(n, n2, n3, n4);
        this.inSuperReshape = false;
        this.changed = true;
        this.changedFlag |= 2;
        this.recalc();
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        this.axisHashtable = new Hashtable();
        super.saveParams(string, hTMLSaveDriver);
        JCChartArea jCChartArea = new JCChartArea();
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".axisBoundingBox", jCChartArea.getAxisBoundingBox(), this.getAxisBoundingBox());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".depth", jCChartArea.getDepth(), this.getDepth());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".elevation", jCChartArea.getElevation(), this.getElevation());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".rotation", jCChartArea.getRotation(), this.getRotation());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".angleUnit", JCUtilConverter.fromEnum(jCChartArea.angleUnit, angleUnit_strings, angleUnit_values), JCUtilConverter.fromEnum(this.angleUnit, angleUnit_strings, angleUnit_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".fastAction", jCChartArea.getFastAction(), this.getFastAction());
        this.getPlotArea().saveParams(String.valueOf(string) + ".plotArea", hTMLSaveDriver);
        this.axisHashtable.put(JCChartBundle.string("jclass.chart.Key28"), "xaxis");
        this.axisHashtable.put(JCChartBundle.string("jclass.chart.Key29"), "yaxis");
        this.getXAxis(0).saveParams("xaxis", hTMLSaveDriver);
        this.getYAxis(0).saveParams("yaxis", hTMLSaveDriver);
        int n = 1;
        while (n < this.xaxes.size()) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".xaxisName" + n, "xaxis" + n);
            this.axisHashtable.put(this.getXAxis(n).getName(), "xaxis" + n);
            this.getXAxis(n).saveParams("xaxis" + n, hTMLSaveDriver);
            ++n;
        }
        int n2 = 1;
        while (n2 < this.yaxes.size()) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".yaxisName" + n2, "yaxis" + n2);
            this.axisHashtable.put(this.getYAxis(n2).getName(), "yaxis" + n2);
            this.getYAxis(n2).saveParams("yaxis" + n2, hTMLSaveDriver);
            ++n2;
        }
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".horizActionAxis", jCChartArea.getHorizActionAxis(), this.getHorizActionAxis());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".vertActionAxis", jCChartArea.getVertActionAxis(), this.getVertActionAxis());
    }

    public void setAngleUnit(int n) {
        if (!JCChartUtil.validUnit(n)) {
            throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key71"));
        }
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            this.angleUnit = n;
        }
        this.setChanged(true, 2);
    }

    public void setAxisBoundingBox(boolean bl) {
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            if (bl == this.axisBoundingBox) {
                Object var3_3 = null;
                return;
            }
            this.axisBoundingBox = bl;
        }
        this.setChanged(true, 1);
    }

    public void setChanged(boolean bl, int n) {
        JCAxis[] jCAxisArray;
        JCAxis[] jCAxisArray2;
        JCChart jCChart = this.getParent();
        if (jCChart == null) {
            return;
        }
        JCVector jCVector = new JCVector();
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            this.ensureDrawables();
            Enumeration enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                jCVector.addElement(this.drawables.get(k));
            }
        }
        int n2 = 0;
        while (n2 < jCVector.size()) {
            jCAxisArray2 = (ChartDraw)jCVector.elementAt(n2);
            jCAxisArray2.setChanged(true, n, false);
            if (!bl) {
                jCAxisArray2.dataObject.setChanged(false, 0, false);
            }
            ++n2;
        }
        jCAxisArray2 = this;
        synchronized (jCAxisArray2) {
            this.changed = bl;
            this.changedFlag = this.changed ? (this.changedFlag |= n) : n;
        }
        if (this.changed) {
            if (jCChart.getPeer() != null && !jCChart.getIsBatched()) {
                if (this.sizeChanged()) {
                    this.updateParent(n);
                } else {
                    jCAxisArray2 = this.getRegionLock();
                    synchronized (jCAxisArray2) {
                        if ((n & 2) > 0) {
                            this.recalc();
                            jCChart.repaint();
                        } else if ((n & 1) > 0) {
                            jCChart.repaint();
                        }
                    }
                }
            }
            return;
        }
        jCAxisArray2 = this.getXAxis();
        if (jCAxisArray2 != null) {
            int n3 = 0;
            while (n3 < jCAxisArray2.length) {
                ((ChartRegion)jCAxisArray2[n3]).setChanged(false, 0, false);
                ++n3;
            }
        }
        if ((jCAxisArray = this.getYAxis()) != null) {
            int n4 = 0;
            while (n4 < jCAxisArray.length) {
                jCAxisArray[n4].setChanged(false, 0, false);
                ++n4;
            }
        }
    }

    public void setDepth(int n) {
        int n2 = (int)JCChartUtil.clamp((double)n, 0.0, 500.0);
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            if (this.depth == n2) {
                Object var4_4 = null;
                return;
            }
            this.depth = n2;
        }
        this.setChanged(true, 2);
    }

    public void setElevation(int n) {
        int n2 = (int)JCChartUtil.clamp((double)n, -45.0, 45.0);
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            if (n2 == this.elevation) {
                Object var4_4 = null;
                return;
            }
            this.elevation = n2;
        }
        this.setChanged(true, 2);
    }

    public void setFastAction(boolean bl) {
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            if (bl == this.fastAction) {
                Object var3_3 = null;
                return;
            }
            this.fastAction = bl;
        }
    }

    public void setHorizActionAxis(JCAxis jCAxis) {
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            if (jCAxis != null && (jCAxis.isVertical || !this.xaxes.contains(jCAxis) && !this.yaxes.contains(jCAxis))) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key62"));
            }
            this.horizActionAxis = jCAxis;
        }
    }

    public void setParent(JCChart jCChart) {
        this.parent = jCChart;
        Enumeration enumeration = this.xaxes.elements();
        while (enumeration.hasMoreElements()) {
            ((JCAxis)enumeration.nextElement()).setParent(jCChart);
        }
        Enumeration enumeration2 = this.yaxes.elements();
        while (enumeration2.hasMoreElements()) {
            ((JCAxis)enumeration2.nextElement()).setParent(jCChart);
        }
    }

    public void setRotation(int n) {
        int n2 = (int)JCChartUtil.clamp((double)n, -45.0, 45.0);
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            if (n2 == this.rotation) {
                Object var4_4 = null;
                return;
            }
            this.rotation = n2;
        }
        this.setChanged(true, 2);
    }

    public void setVertActionAxis(JCAxis jCAxis) {
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            if (!(jCAxis == null || jCAxis.isVertical && (this.xaxes.contains(jCAxis) || this.yaxes.contains(jCAxis)))) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key81"));
            }
            this.vertActionAxis = jCAxis;
        }
    }

    public void setXAxis(int n, JCAxis jCAxis) {
        if (jCAxis == null) {
            JCChartArea jCChartArea = this;
            synchronized (jCChartArea) {
                if (n < 0 || n >= this.xaxes.size()) {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key82"));
                }
                this.removeAxis(n, this.xaxes);
            }
        }
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            if (n < 0 || n > this.xaxes.size()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key82"));
            }
            jCAxis.setParent(this.getParent());
            this.addAxis(n, this.xaxes, jCAxis);
        }
        this.setChanged(true, 2);
    }

    public void setXAxis(JCAxis[] jCAxisArray) {
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            this.xaxes = new JCVector();
            if (jCAxisArray == null) {
                Object var3_3 = null;
                return;
            }
            int n = 0;
            while (n < jCAxisArray.length) {
                if (jCAxisArray[n] != null) {
                    jCAxisArray[n].setParent(this.getParent());
                    jCAxisArray[n].isVertical = false;
                }
                this.xaxes.setElementAt(n, jCAxisArray[n]);
                ++n;
            }
        }
        this.setChanged(true, 2);
    }

    public void setYAxis(int n, JCAxis jCAxis) {
        if (jCAxis == null) {
            JCChartArea jCChartArea = this;
            synchronized (jCChartArea) {
                if (n < 0 || n >= this.yaxes.size()) {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key83"));
                }
                this.removeAxis(n, this.yaxes);
            }
        }
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            if (n < 0 || n > this.yaxes.size()) {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key83"));
            }
            jCAxis.setParent(this.getParent());
            this.addAxis(n, this.yaxes, jCAxis);
        }
        this.setChanged(true, 2);
    }

    public void setYAxis(JCAxis[] jCAxisArray) {
        JCChartArea jCChartArea = this;
        synchronized (jCChartArea) {
            this.yaxes = new JCVector();
            if (jCAxisArray == null) {
                Object var3_3 = null;
                return;
            }
            int n = 0;
            while (n < jCAxisArray.length) {
                if (jCAxisArray[n] != null) {
                    jCAxisArray[n].setParent(this.getParent());
                    jCAxisArray[n].isVertical = true;
                }
                this.yaxes.setElementAt(n, jCAxisArray[n]);
                ++n;
            }
        }
        this.setChanged(true, 2);
    }

    void showAction(int n, int n2) {
        if (this.last.x == n && this.last.y == n2) {
            return;
        }
        this.last.x = n;
        this.last.y = n2;
        this.handler.animate(n, n2);
    }

    void startAction(EventTrigger eventTrigger, int n, int n2) {
        this.handler = ActionHandler.makeHandler(eventTrigger.getAction(), this);
        if (this.handler != null) {
            this.handler.start(n, n2);
        }
    }
}

