/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.RGBImageFilter;

public class RGBOverrideFilter
extends RGBImageFilter {
    private int fg_rgbColor_toUse;
    private int bg_rgbColor_toUse;
    private int fg_rgbColor_toRep;
    private int bg_rgbColor_toRep;
    private boolean found_fg_toRep = false;
    private boolean found_bg_toRep = false;
    private int pixelSize;

    public RGBOverrideFilter(Color color, Color color2) {
        this.canFilterIndexColorModel = true;
        this.fg_rgbColor_toUse = color.getRGB();
        this.bg_rgbColor_toUse = color2.getRGB();
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3;
        if (this.pixelSize == 24 && n3 != this.fg_rgbColor_toUse && n3 != this.bg_rgbColor_toUse) {
            if (!this.found_bg_toRep || !this.found_fg_toRep) {
                this.findColorsToReplace(n3);
            }
            boolean bl = false;
            if (this.found_bg_toRep && n3 == this.bg_rgbColor_toRep) {
                n4 = this.bg_rgbColor_toUse;
            }
            if (this.found_fg_toRep && n3 == this.fg_rgbColor_toRep) {
                n4 = this.fg_rgbColor_toUse;
            }
        }
        return n4;
    }

    protected void findColorsToReplace(int n) {
        if (!(this.found_bg_toRep || this.found_fg_toRep && this.fg_rgbColor_toRep == n || (this.bg_rgbColor_toUse & 0xFF) != (n & 0xFF))) {
            this.bg_rgbColor_toRep = n;
            this.found_bg_toRep = true;
            return;
        }
        if (!(this.found_fg_toRep || this.found_bg_toRep && this.bg_rgbColor_toRep == n || (this.fg_rgbColor_toUse & 0xFF) != (n & 0xFF))) {
            this.fg_rgbColor_toRep = n;
            this.found_fg_toRep = true;
            return;
        }
    }

    public void setColorModel(ColorModel colorModel) {
        super.setColorModel(colorModel);
        this.pixelSize = colorModel.getPixelSize();
    }
}

