/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.andiamo.elements.EthernetPort;
import com.cisco.dcbu.dmdb.andiamo.elements.SatChassisIf;
import com.cisco.dcbu.dmdb.andiamo.elements.SatUplinkPort;
import com.cisco.dcbu.dmdb.andiamo.elements.SatUplinkQSFPPort;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.lib.util.vsif.VSifObj;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class FCoEPostPollUpdater {
    private static FCoEPostPollUpdater INSTANCE;
    Map<Integer, IntArray> mEthPortIfIndexToVfcIfIndicesMap;
    Map<Integer, IntArray> mEthPortIfIndexToVEthIfIndicesMap;
    Map<Integer, Integer> mVfcIfIndexToStatusHash;
    Map<Integer, Integer> mVEthIfIndexToStatusHash;
    Map<Integer, Integer> allVSifIfIndexToStatusHash;
    Map<String, Integer> mSatUplinkPortConnectivityMap;
    Map<Integer, String> mReverseSatUplinkPortConnectivityMap;
    TreeMap<Integer, Integer> mVfcIfIndexToModeMap = new TreeMap();
    Map<Integer, EthernetPort> mSatUplinkPortToEthPEMap;
    private static String FEX_STR;
    private static String ETH_STR;
    private static String PORT_STR;

    private FCoEPostPollUpdater() {
    }

    public static synchronized FCoEPostPollUpdater getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FCoEPostPollUpdater();
        }
        return INSTANCE;
    }

    public void update(IfIndexIf pIfIndexIf) {
        this.updateVfc(pIfIndexIf);
        this.updateVEth(pIfIndexIf);
        this.updateSatUplinkPortInfo(pIfIndexIf);
        this.updatePhysicalView(pIfIndexIf);
    }

    public void updateVfc(IfIndexIf pIfIndexIf) {
        block4: {
            try {
                if (this.mEthPortIfIndexToVfcIfIndicesMap == null) {
                    this.mEthPortIfIndexToVfcIfIndicesMap = new TreeMap<Integer, IntArray>();
                    this.mVfcIfIndexToStatusHash = new TreeMap<Integer, Integer>();
                    this.allVSifIfIndexToStatusHash = new TreeMap<Integer, Integer>();
                } else {
                    this.mEthPortIfIndexToVfcIfIndicesMap.clear();
                    this.mVfcIfIndexToStatusHash.clear();
                    this.allVSifIfIndexToStatusHash.clear();
                }
                VSifObj lvsifObj = null;
                lvsifObj = VSifObj.get((SnmpPeer)Discover.getPeer(), (IfIndexIf)pIfIndexIf, (byte[])new byte[]{4, 2, 9});
                this.mEthPortIfIndexToVfcIfIndicesMap = lvsifObj.getEthPortIfIndexToVSifIfIndicesMap();
                this.mVfcIfIndexToStatusHash = lvsifObj.getVSifIndexToStatusMap();
                this.mVfcIfIndexToModeMap = lvsifObj.getVSifIndexToModeMap();
                this.allVSifIfIndexToStatusHash.putAll(this.mVfcIfIndexToStatusHash);
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.debug((Object)ex);
                if (!SnmpSession.isTrace()) break block4;
                DefaultLogger._DefLogger.debug((Object)("Failed to get vfcs: " + ex));
            }
        }
    }

    public void updateVEth(IfIndexIf pIfIndexIf) {
        block4: {
            try {
                if (this.mEthPortIfIndexToVEthIfIndicesMap == null) {
                    this.mEthPortIfIndexToVEthIfIndicesMap = new TreeMap<Integer, IntArray>();
                    this.mVEthIfIndexToStatusHash = new TreeMap<Integer, Integer>();
                } else {
                    this.mEthPortIfIndexToVEthIfIndicesMap.clear();
                    this.mVEthIfIndexToStatusHash.clear();
                }
                VSifObj lvsifObj = null;
                lvsifObj = VSifObj.get((SnmpPeer)Discover.getPeer(), (IfIndexIf)pIfIndexIf, (byte[])new byte[]{11, 10});
                this.mEthPortIfIndexToVEthIfIndicesMap = lvsifObj.getEthPortIfIndexToVEthIfIndicesMap();
                this.mVEthIfIndexToStatusHash = lvsifObj.getVEthIndexToStatusMap();
                this.allVSifIfIndexToStatusHash.putAll(this.mVEthIfIndexToStatusHash);
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.debug((Object)ex);
                if (!SnmpSession.isTrace()) break block4;
                DefaultLogger._DefLogger.debug((Object)("Failed to get veths: " + ex));
            }
        }
    }

    public void updateSatUplinkPortInfo(IfIndexIf pIfIndexIf) {
        block6: {
            try {
                if (this.mSatUplinkPortConnectivityMap == null) {
                    this.mSatUplinkPortConnectivityMap = new HashMap<String, Integer>();
                    this.mReverseSatUplinkPortConnectivityMap = new HashMap<Integer, String>();
                    this.mSatUplinkPortToEthPEMap = new HashMap<Integer, EthernetPort>();
                } else {
                    this.mSatUplinkPortConnectivityMap.clear();
                    this.mReverseSatUplinkPortConnectivityMap.clear();
                    this.mSatUplinkPortToEthPEMap.clear();
                }
                VarBindList vbl = new VarBindList(1);
                vbl.add(MibNode.get((String)"entPhysicalDescr").getOid());
                SnmpPDU rspPdu = SnmpFetch.getBulkWithStartIndexFix((SnmpPeer)Discover.getPeer(), (VarBindList)vbl, (int)0, (int[])new int[]{FRUConstants.getCableOffset((boolean)Discover.isSysVersionGreaterThanEqual((String)"5.0(0)")) - 1}, (int[])new int[]{FRUConstants.getCableStopOffset((boolean)Discover.isSysVersionGreaterThanEqual((String)"5.0(0)"))});
                VarBindList rspVbl = rspPdu.getVariables();
                int size = rspVbl.size();
                for (int i = 0; i < size; ++i) {
                    String value = rspVbl.stringValue(i);
                    String key = value.substring(0, value.indexOf(" to Core Port"));
                    int ethIndex = value.indexOf(ETH_STR);
                    if (ethIndex == -1) {
                        ethIndex = value.indexOf("Eth");
                    }
                    String ethPortStr = value.substring(ethIndex, value.indexOf(" Cable"));
                    int ethPortIfIndex = pIfIndexIf.nameToIfIndex(ethPortStr);
                    this.mSatUplinkPortConnectivityMap.put(key, ethPortIfIndex);
                    this.mReverseSatUplinkPortConnectivityMap.put(ethPortIfIndex, key);
                }
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.debug((Object)ex);
                if (!SnmpSession.isTrace()) break block6;
                DefaultLogger._DefLogger.debug((Object)("Failed to get Uplink Port info: " + ex));
            }
        }
    }

    public Set<Integer> getEthIfIndicesAttachedToFex(IfIndexIf pIfIndexIf) {
        this.updateSatUplinkPortInfo(pIfIndexIf);
        return this.mReverseSatUplinkPortConnectivityMap != null ? this.mReverseSatUplinkPortConnectivityMap.keySet() : Collections.EMPTY_SET;
    }

    public Map<Integer, Integer> getVfcIndexStatusMap() {
        return this.mVfcIfIndexToStatusHash;
    }

    public Map<Integer, Integer> getVEthIndexStatusMap() {
        return this.mVEthIfIndexToStatusHash;
    }

    public Map<Integer, Integer> getVfcIndexToModeMap() {
        return this.mVfcIfIndexToModeMap;
    }

    private String getConnectedSatPort(int pEthPortIfIndex) {
        return this.mReverseSatUplinkPortConnectivityMap != null ? this.mReverseSatUplinkPortConnectivityMap.get(pEthPortIfIndex) : null;
    }

    private int getConnectedEthPort(String pSatPort) {
        return this.mSatUplinkPortConnectivityMap != null && this.mSatUplinkPortConnectivityMap.containsKey(pSatPort) ? this.mSatUplinkPortConnectivityMap.get(pSatPort) : 0;
    }

    public int[] getVfcsForEthPort(int pEthPortIfIndex) {
        int[] vethIndices;
        IntArray vsifsIfIndices = null;
        if (this.mEthPortIfIndexToVfcIfIndicesMap.containsKey(pEthPortIfIndex)) {
            vsifsIfIndices = this.mEthPortIfIndexToVfcIfIndicesMap.get(pEthPortIfIndex);
        }
        if ((vethIndices = this.getVEthsForEthPort(pEthPortIfIndex)) != null) {
            for (int index : vethIndices) {
                if (!this.mEthPortIfIndexToVfcIfIndicesMap.containsKey(index)) continue;
                IntArray vsifs = this.mEthPortIfIndexToVfcIfIndicesMap.get(index);
                if (vsifsIfIndices == null) {
                    vsifsIfIndices = vsifs;
                    continue;
                }
                vsifsIfIndices.add(vsifs.toArray());
            }
        }
        if (vsifsIfIndices == null) {
            return new int[0];
        }
        int[] vfcIds = vsifsIfIndices.toArray();
        Arrays.sort(vfcIds);
        return vfcIds;
    }

    public int[] getVEthsForEthPort(int pEthPortIfIndex) {
        int[] vsifsIfIndices = null;
        if (this.mEthPortIfIndexToVEthIfIndicesMap.containsKey(pEthPortIfIndex)) {
            IntArray vsifs = this.mEthPortIfIndexToVEthIfIndicesMap.get(pEthPortIfIndex);
            vsifsIfIndices = vsifs.toArray();
            Arrays.sort(vsifsIfIndices);
        }
        if (vsifsIfIndices == null) {
            return new int[0];
        }
        return vsifsIfIndices;
    }

    void updatePhysicalView(IfIndexIf pIfIndexIf) {
        PhysicalView view = DeviceManager.getInstance().getView();
        Array elements = view.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            PhysicalElement elem;
            PhysicalElement e = (PhysicalElement)elements.elementAt(i);
            if (e instanceof EthernetPort) {
                int index = e.getIndex()[0];
                StringBuffer satPortInfo = new StringBuffer();
                IntArray vsifIndices = new IntArray(this.getVfcsForEthPort(index));
                if (((EthernetPort)e)._breakoutPorts != null) {
                    int[][] bports = ((EthernetPort)e)._breakoutPorts;
                    for (int count = 0; count < bports.length; ++count) {
                        if (bports[count] == null || bports[count][0] == 0) continue;
                        int bportIfIndex = bports[count][0];
                        vsifIndices.add(this.getVfcsForEthPort(bportIfIndex));
                        vsifIndices.add(this.getVEthsForEthPort(bportIfIndex));
                        String satPortKey = this.getConnectedSatPort(bportIfIndex);
                        if (satPortKey == null) continue;
                        this.mSatUplinkPortToEthPEMap.put(new Integer(bportIfIndex), (EthernetPort)e);
                        if (satPortInfo.length() == 0) {
                            satPortInfo.append("Connected " + satPortKey + " to " + pIfIndexIf.ifIndexToName(bports[count][0]));
                            continue;
                        }
                        satPortInfo.append("<br>Connected " + satPortKey + " to " + pIfIndexIf.ifIndexToName(bports[count][0]));
                    }
                } else {
                    String satPortKey = this.getConnectedSatPort(index);
                    if (satPortKey != null) {
                        this.mSatUplinkPortToEthPEMap.put(new Integer(index), (EthernetPort)e);
                        satPortInfo.append("Connected " + satPortKey);
                    }
                }
                vsifIndices.add(this.getVEthsForEthPort(index));
                ((EthernetPort)e).update(vsifIndices.toArray(), this.allVSifIfIndexToStatusHash, this.mVfcIfIndexToModeMap, satPortInfo.toString());
                continue;
            }
            if (e instanceof SatUplinkQSFPPort) {
                PhysicalElement elem2 = e.getParent().getParent();
                if (!(elem2 instanceof SatChassisIf)) continue;
                int startPortLine = (e.getIndex()[0] - 1) * 4 + 1;
                int endPortLine = e.getIndex()[0] * 4;
                for (int j = startPortLine; j <= endPortLine; ++j) {
                    String key = FEX_STR + ((SatChassisIf)elem2).getSatSwitchId() + PORT_STR + j;
                    int ethPortIfIndex = this.getConnectedEthPort(key);
                    ((SatUplinkQSFPPort)e).update(view, j, ethPortIfIndex, this.mSatUplinkPortToEthPEMap.get(ethPortIfIndex));
                }
                continue;
            }
            if (!(e instanceof SatUplinkPort) || !((elem = e.getParent().getParent()) instanceof SatChassisIf)) continue;
            String key = FEX_STR + ((SatChassisIf)elem).getSatSwitchId() + PORT_STR + e.getIndex()[0];
            int ethPortIfIndex = this.getConnectedEthPort(key);
            ((SatUplinkPort)e).update(view, ethPortIfIndex, this.mSatUplinkPortToEthPEMap.get(ethPortIfIndex));
        }
    }

    static {
        FEX_STR = "Fex-";
        ETH_STR = "eth";
        PORT_STR = " Port ";
    }
}

