/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;

public class EditInetAddrTable
extends EditTable {
    static final int PRIMARY = 2;
    String[] _addrVar;
    String[] _addrTypeVar;
    int[][] _addrTypeOid;
    int[][] _addrOid;
    int[] _addrType;
    int[] _addrPos;

    public EditInetAddrTable(String[] vars, String addrVar, String addrTypeVar) {
        this(vars, new String[]{addrVar}, new String[]{addrTypeVar}, new int[]{-1});
    }

    public EditInetAddrTable(String[] vars, String addrVar, String addrTypeVar, int addrPos) {
        this(vars, new String[]{addrVar}, new String[]{addrTypeVar}, new int[]{addrPos});
    }

    public EditInetAddrTable(String[] vars, String[] addrVar, String[] addrTypeVar) {
        this(vars, addrVar, addrTypeVar, new int[]{-1});
    }

    public EditInetAddrTable(String[] vars, String[] addrVar, String[] addrTypeVar, int[] addrPos) {
        super(vars);
        this._addrVar = addrVar;
        this._addrTypeVar = addrTypeVar;
        this._addrPos = addrPos;
        this._addrType = new int[addrVar.length];
        this._addrOid = new int[addrVar.length][];
        this._addrTypeOid = new int[addrVar.length][];
        for (int i = 0; i < addrVar.length; ++i) {
            this._addrOid[i] = MibNode.get((String)addrVar[i]).getOid();
            this._addrTypeOid[i] = MibNode.get((String)addrTypeVar[i]).getOid();
        }
    }

    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        if (this._addrOid.length > 0) {
            int[] index;
            int[] oid = pdu.getVariables().get(0).getOid().getValue();
            if (oid.length == this._addrOid[0].length) {
                index = new int[]{0};
            } else {
                index = new int[oid.length - this._addrOid[0].length];
                System.arraycopy(oid, this._addrOid[0].length, index, 0, index.length);
            }
            for (int i = 0; i < this._addrTypeOid.length; ++i) {
                pdu.addNull(new SnmpOID(this._addrTypeOid[i], index));
            }
        }
        super.sendGetPdu(pdu);
    }

    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        for (int i = 1; i <= this._addrVar.length; ++i) {
            int pos = pdu.getVariables().size() - 1;
            this._addrType[this._addrType.length - i] = pdu.getVariables().intValue(pos);
            pdu.removeVarAt(pos);
        }
        return super.buildRow(pdu, responseOid, rowNo);
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        VarBindList vbl = pdu.getVariables();
        for (int i = pdu.getVariables().size() - 1; i >= 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            SnmpOID oid = vb.getOid();
            for (int j = 0; j < this._addrOid.length; ++j) {
                if (!oid.startsWith(this._addrOid[j])) continue;
                String addr = ((SnmpString)vb.getVar()).toString();
                int addrType = 1;
                int[] index = new int[oid.getValue().length - this._addrOid[j].length];
                System.arraycopy(oid.getValue(), this._addrOid[j].length, index, 0, index.length);
                try {
                    byte[] addrB = SnmpIpAddress.parse((String)addr);
                    vbl.remove(i);
                    vb = new SnmpVarBind(new SnmpOID(this._addrOid[j], index), (SnmpVar)new SnmpString(SnmpIpAddress.parse((String)addr)));
                    vbl.add(i, vb);
                    if (addrB.length == 16) {
                        addrType = 2;
                    }
                }
                catch (SnmpException ex) {
                    addrType = 16;
                    vbl.remove(i);
                    vb = new SnmpVarBind(new SnmpOID(this._addrOid[j], index), (SnmpVar)new SnmpString(addr));
                    vbl.add(i, vb);
                }
                vb = new SnmpVarBind(new SnmpOID(this._addrTypeOid[j], index), (SnmpVar)new SnmpInt(addrType));
                vbl.add(i, vb);
            }
        }
        super.sendPdu(pdu);
    }

    protected DmTableModel buildTableModel() {
        return new SnmpInetAddrTableModel();
    }

    public class SnmpInetAddrTableModel
    extends DmTableModel {
        public Object toCellEditTable(MibNode mibNode, SnmpPDU pdu, SnmpVarBind vb, String var, SnmpOID index, int row, int col) {
            for (int i = 0; i < EditInetAddrTable.this._addrVar.length; ++i) {
                if (!var.equals(EditInetAddrTable.this._addrVar[i])) continue;
                if (EditInetAddrTable.this._addrType[i] == 1 || EditInetAddrTable.this._addrType[i] == 2) {
                    return new SnmpIpAddress(pdu.getVariables().byteValue(col - 1));
                }
                return vb.getVar();
            }
            return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
        }

        public Object getSetValueAt(Object aValue, int row, int col) {
            Object[] data;
            Object target;
            if (col != -1 && this.isMatchAddrPos(col) && (target = (data = (Object[])this.getData().elementAt(row))[col]) instanceof SnmpInetAddress) {
                try {
                    aValue = new SnmpInetAddress(aValue.toString(), true);
                }
                catch (SnmpException ex) {
                    Util.errorMessage((Component)this.getErrorComponent(), (Exception)((Object)ex));
                }
                return aValue;
            }
            return super.getSetValueAt(aValue, row, col);
        }

        protected SnmpVar getChangedCell(int row, int col) throws Exception {
            if (EditInetAddrTable.this._addrPos[0] != -1 && this.isMatchAddrPos(col)) {
                Object o = this.getValueAt(row, col);
                return new SnmpInetAddress(o.toString(), true);
            }
            return super.getChangedCell(row, col);
        }

        private boolean isMatchAddrPos(int pos) {
            for (int i = 0; i < EditInetAddrTable.this._addrPos.length; ++i) {
                if (pos != EditInetAddrTable.this._addrPos[i]) continue;
                return true;
            }
            return false;
        }
    }
}

