/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.event.ListSelectionEvent;

class EditIpFilterProfileTable
extends EditTable {
    static final int NAME_COL = 0;
    static final int TYPE_COL = 1;
    MibEnum[] _cippfIpProfileTypeEnums = MibNode.get((String)"cippfIpProfileType").getEnums();

    public EditIpFilterProfileTable(String[] vars) {
        super(vars);
    }

    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt((Object)"Rules...", 0);
        return btns;
    }

    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("L");
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('L', this._table.getSelectedRowCount() > 0);
    }

    public void dispose() {
        super.dispose();
        DMDialog d = DialogListener.getInstance().getDialog("IPFilter");
        if (d != null) {
            DialogListener.getInstance().remove("IPFilter");
            d.dispose();
        }
    }

    protected void updateTable() {
        super.updateTable();
        this.enableButton('L', false);
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'L') {
            boolean isBuilt = false;
            int[] name = ((SnmpOID)this._tableModel.getValueAt(this._table.getSelectedRow(), 0)).getValue();
            String typeString = (String)this._tableModel.getValueAt(this._table.getSelectedRow(), 1);
            int type = 1;
            for (int j = 0; j < this._cippfIpProfileTypeEnums.length; ++j) {
                if (!this._cippfIpProfileTypeEnums[j].getLabel().equals(typeString)) continue;
                type = j == 1 ? 2 : 1;
                break;
            }
            int[] index = new int[name.length + 1];
            System.arraycopy(name, 0, index, 0, name.length);
            index[index.length - 1] = type;
            DMDialog IpFilterlg = DialogListener.getInstance().dialogAction("IPFilter", index);
            if (IpFilterlg != null) {
                String filterName = SnmpString.toString((int[])index, (int)1, (int)(index[0] + 1));
                IpFilterlg.setTitle(Discover.getDeviceName() + " - IP ACL Profile " + filterName);
            }
        } else {
            super.doIt(ch, e);
        }
    }

    protected boolean isOkToDelete() {
        return this.isIgnoreWarning("<html>Deleting profiles would cause an implicit deny if there are interfaces using them, <br>possibly locking you out of the switch.<br><br>Unbind any interfaces before deleting profiles.<br><br>Continue?");
    }
}

