/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ISLCellIf;
import com.cisco.dcbu.dmdb.andiamo.dialogs.IslLink;
import com.cisco.dcbu.dmdb.andiamo.dialogs.Switch;
import com.cisco.dcbu.dmdb.andiamo.dialogs.SwitchMapUtil;
import com.cisco.dcbu.dmdb.andiamo.dialogs.VsanDomainId;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ISLCellEditor
extends DefaultCellEditor {
    JMenu _menu;
    int _row;
    int _column;
    private Object _value;
    JTable _table;
    SnmpPeer _peer;
    private JPanel _panel;
    private JTextField _data;
    HashMap _ISLMap;
    HashMap _switchHash;
    ArrayList _npvISLList;
    int VSAN = 1;
    int DEST_DOMAIN = 2;
    int _vsan;
    int _destDomain;
    ISLCellIf _target;

    public ISLCellEditor(SnmpPeer peer, HashMap ISLMap, HashMap switchHash, ArrayList npvISLList, ISLCellIf target) {
        super(new JComboBox());
        this.setClickCountToStart(1);
        this._peer = peer;
        this._ISLMap = ISLMap;
        this._switchHash = switchHash;
        this._npvISLList = npvISLList;
        this._target = target;
        this._panel = new JPanel(new BorderLayout());
        this._data = new JTextField();
        this._data.setBorder(BorderFactory.createLineBorder(Color.black));
        this._data.setFont(ChangedCellRenderer.getChangeFont());
        this._panel.add((Component)this._data, "Center");
        this._menu = new JMenu();
        MyMenuButton btn = new MyMenuButton(this._menu, this._data);
        this._panel.add((Component)((Object)btn), "East");
        this._panel.setBorder(null);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = row;
        this._column = column;
        this._table = table;
        this._value = value;
        this._menu = new JMenu();
        this._data.setText(value != null ? value.toString() : "");
        Array rows = ((SnmpTableModel)this._table.getModel()).getData();
        int[] oid = ((SnmpOID)((Object[])rows.elementAt(row))[0]).getValue();
        this._vsan = oid[this.VSAN];
        this._destDomain = oid[this.DEST_DOMAIN];
        Component[] changeListeners = ((SnmpKTable)this._table).getChangeListener();
        if (changeListeners != null) {
            for (int i = 0; i < changeListeners.length; ++i) {
                changeListeners[i].setEnabled(true);
            }
        }
        return this._panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this._data.getText();
    }

    class MyMenuButton
    extends MenuButton {
        JTextField _parent;

        public MyMenuButton(JMenu menu, JTextField parent) {
            super(menu);
            this._parent = parent;
        }

        public void actionPerformed(ActionEvent e) {
            this._menu = new JMenu();
            try {
                ArrayList islList;
                VsanDomainId vsanDomainId = new VsanDomainId(ISLCellEditor.this._vsan, ISLCellEditor.this._destDomain, new Wwn(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}));
                if (ISLCellEditor.this._ISLMap == null) {
                    ISLCellEditor.this._ISLMap = new HashMap();
                }
                if ((islList = (ArrayList)ISLCellEditor.this._ISLMap.get(vsanDomainId)) == null) {
                    ISLCellEditor.this._switchHash = SwitchMapUtil.getSwitchMapHash(ISLCellEditor.this._peer, ISLCellEditor.this._vsan, new ArrayList());
                    ISLCellEditor.this._npvISLList = new ArrayList();
                    SwitchMapUtil.getEndPortHash(ISLCellEditor.this._switchHash, ISLCellEditor.this._peer, ISLCellEditor.this._vsan, ISLCellEditor.this._peer.getAddress(), new ArrayList(), new ArrayList(), ISLCellEditor.this._npvISLList);
                    Switch nbrSwitch = SwitchMapUtil.SwitchIPByVsanDomainIdCore(ISLCellEditor.this._switchHash, ISLCellEditor.this._vsan, ISLCellEditor.this._destDomain);
                    nbrSwitch = SwitchMapUtil.SwitchIPByVsanDomainIdCore(ISLCellEditor.this._switchHash, ISLCellEditor.this._vsan, ISLCellEditor.this._destDomain);
                    if (nbrSwitch == null) {
                        return;
                    }
                    islList = SwitchMapUtil.getIslArray(ISLCellEditor.this._switchHash, ISLCellEditor.this._npvISLList, ISLCellEditor.this._peer, ISLCellEditor.this._vsan, ISLCellEditor.this._peer.getAddress(), nbrSwitch.getInetAddr(), 0, true);
                    ISLCellEditor.this._ISLMap.put(vsanDomainId, islList);
                }
                ISLCellEditor.this._target.ISLCellEditorCB(ISLCellEditor.this._ISLMap, ISLCellEditor.this._switchHash, ISLCellEditor.this._npvISLList);
                Object[] names = null;
                if (islList != null) {
                    names = new String[islList.size()];
                    for (int i = 0; i < islList.size(); ++i) {
                        StringBuffer sb = new StringBuffer(Discover.getRoot().ifIndexToName(((IslLink)islList.get(i)).getIslIfIndex()));
                        if (((IslLink)islList.get(i)).isPCMember()) {
                            sb.append('(');
                            sb.append(Discover.getRoot().ifIndexToName(((IslLink)islList.get(i)).getPCIfIndex()));
                            sb.append(')');
                        }
                        names[i] = sb.toString();
                    }
                }
                if (names == null || names.length == 0) {
                    this.setEnabled(false);
                    return;
                }
                this.buildMenu(names);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (e.getSource() instanceof JMenuItem) {
                if (this._parent != null) {
                    String ifName = ((JMenuItem)e.getSource()).getText();
                    int offset = ifName.indexOf(40);
                    ifName = offset == -1 ? ifName : ifName.substring(0, offset);
                    this._parent.setText(ifName);
                }
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

