/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;

public class InsertInetAddr
extends InsertForm {
    private int _addrType;
    private int _inetAddrPos;
    private String _inetAddrVar;
    private boolean _isIPV4Only;

    public InsertInetAddr(InsertDialog parent, EditTable table, Object inetAddrPos, Object inetAddrVar) {
        this(parent, table, inetAddrPos, inetAddrVar, false);
    }

    public InsertInetAddr(InsertDialog parent, EditTable table, Object inetAddrPos, Object inetAddrVar, boolean isIPV4Only) {
        super(parent, table);
        this._inetAddrPos = (Integer)inetAddrPos;
        this._inetAddrVar = (String)inetAddrVar;
        this._isIPV4Only = isIPV4Only;
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._inetAddrPos) {
            String addr = this.getComponentText(index);
            if (this._mibNodes[index].getMaxWidth() < addr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " maximum length is " + this._mibNodes[index].getMaxWidth());
            }
            if (this._mibNodes[index].getMinWidth() > addr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " minimum length is " + this._mibNodes[index].getMinWidth());
            }
            this._addrType = 1;
            try {
                byte[] addrB = SnmpIpAddress.parse((String)addr);
                if (addrB.length == 16) {
                    this._addrType = 2;
                }
                return new SnmpString(addrB);
            }
            catch (SnmpException ex) {
                if (this._isIPV4Only) {
                    throw new Exception(ex.getMessage());
                }
                this._addrType = 16;
                return new SnmpString(addr);
            }
        }
        return super.getComponentValue(index);
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(MibNode.get((String)this._inetAddrVar).getOid(), index), (SnmpVar)new SnmpInt(this._addrType));
        pdu.getVariables().add(1, vb);
        return pdu;
    }
}

