/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.lib.jnm.Wwn;
import java.net.InetAddress;

public final class IslLink {
    InetAddress _ipAddr;
    InetAddress _nbrIpAddr;
    int _vsanId;
    int _domainId;
    int _nbrDomainId;
    int _islIfIndex;
    int _nbrIslIfIndex;
    String _nbrIfIndexSymbolicName;
    byte[] _fWwn;
    int _pcIfIndex;

    public IslLink(int vsanId, InetAddress ipAddr, int domainId, int islPort, InetAddress nbrIpAddr, int nbrDomainId, int nbfIslPort, String nbrIslSymbolicName) {
        this(vsanId, ipAddr, domainId, islPort, nbrIpAddr, nbrDomainId, nbfIslPort, -1, nbrIslSymbolicName);
    }

    public IslLink(int vsanId, InetAddress ipAddr, int domainId, int islPort, InetAddress nbrIpAddr, int nbrDomainId, int nbfIslPort, int pcIfIndex, String nbrIslSymbolicName) {
        this._ipAddr = ipAddr;
        this._nbrIpAddr = nbrIpAddr;
        this._vsanId = vsanId;
        this._domainId = domainId;
        this._islIfIndex = islPort;
        this._nbrDomainId = nbrDomainId;
        this._nbrIslIfIndex = nbfIslPort;
        this._pcIfIndex = pcIfIndex;
        this._nbrIfIndexSymbolicName = nbrIslSymbolicName;
    }

    public void setfWwn(byte[] fWwn) {
        this._fWwn = fWwn;
    }

    public void setNbrIfIndexSymbolicName(String name) {
        this._nbrIfIndexSymbolicName = name;
    }

    public InetAddress getIpAddr() {
        return this._ipAddr;
    }

    public InetAddress getNbrIpAddr() {
        return this._nbrIpAddr;
    }

    public byte[] getfWwn() {
        return this._fWwn;
    }

    public int getIslIfIndex() {
        return this._islIfIndex;
    }

    public int getDomainId() {
        return this._domainId;
    }

    public int getNbrDomainId() {
        return this._nbrDomainId;
    }

    public int getPCIfIndex() {
        return this._pcIfIndex;
    }

    public String getNbrIfIndexSymbolicName() {
        return this._nbrIfIndexSymbolicName;
    }

    public boolean isPCMember() {
        return this._pcIfIndex != -1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._ipAddr.getHostAddress());
        buf.append(",");
        buf.append(Discover.getRoot().ifIndexToName(this._islIfIndex));
        if (this._pcIfIndex != -1) {
            buf.append(" (");
            buf.append(Discover.getRoot().ifIndexToName(this._pcIfIndex));
            buf.append(')');
        }
        buf.append(" <-> ");
        if (this._nbrIfIndexSymbolicName != null && this._nbrIfIndexSymbolicName.length() > 0) {
            buf.append(this._nbrIfIndexSymbolicName);
        } else {
            if (this._nbrIpAddr != null) {
                buf.append(this._nbrIpAddr.getHostAddress());
            } else if (this._fWwn != null) {
                buf.append(new Wwn(this._fWwn).toString());
            }
            buf.append(",");
            buf.append(Discover.getRoot().ifIndexToName(this._nbrIslIfIndex));
        }
        return buf.toString();
    }
}

