/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.andiamo.dialogs.Summary;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.util.Date;
import javax.swing.SwingUtilities;

class Requester
extends Thread {
    private static Requester _Instance;
    static final int IDLE = 0;
    static final int INIT = 1;
    static final int WORKING = 2;
    private int _state = 0;
    Summary _summary;
    int _numPolls;

    private Requester(Summary summary) {
        this.setName("Summary Requester");
        this._summary = summary;
    }

    public static Requester getInstance(Summary summary) {
        if (_Instance == null) {
            _Instance = new Requester(summary);
            _Instance.start();
        }
        return _Instance;
    }

    public void setState(int state) {
        this._state = state;
        if (this._state == 0) {
            this._numPolls = 0;
        }
    }

    @Override
    public void run() {
        while (true) {
            int interval = this._summary.getCurrentInterval();
            if (this._state == 1) {
                this.getFirstStats();
                this._state = 2;
            } else if (interval > 0 && this._state == 2) {
                int retries = Discover.getPeer().getRetries();
                Discover.getPeer().setRetries(0);
                try {
                    SnmpPDU resp;
                    if (this._summary._errorsVbl.size() > 0 && this._numPolls % 5 == 0) {
                        SnmpFetch cfr_ignored_0 = this._summary._fetcher;
                        resp = SnmpFetch.get((SnmpPeer)Discover.getPeer(), (VarBindList)this._summary._errorsVbl);
                        if (this._state == 2) {
                            this._summary.updateGlobalsAndErrors(resp.getVariables());
                        }
                    } else if (this._summary._trafficVbl.size() > 0) {
                        SnmpFetch cfr_ignored_1 = this._summary._fetcher;
                        resp = SnmpFetch.get((SnmpPeer)Discover.getPeer(), (VarBindList)this._summary._trafficVbl);
                        if (this._state == 2) {
                            this._summary.updateTraffic(resp.getVariables(), resp.getTimeReceived());
                        }
                    }
                    if (this._state == 2) {
                        this.updateTable();
                    }
                }
                catch (SnmpException ex) {
                    this.logException(ex);
                }
                Discover.getPeer().setRetries(retries);
                ++this._numPolls;
            }
            try {
                Requester.sleep(interval == 0 ? 5000L : (long)interval);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    void getFirstStats() {
        if (this._summary._trafficVbl.size() <= 0) {
            return;
        }
        try {
            SnmpFetch cfr_ignored_0 = this._summary._fetcher;
            SnmpPDU resp = SnmpFetch.get((SnmpPeer)Discover.getPeer(), (VarBindList)this._summary._trafficVbl);
            this._summary.updateTraffic(resp.getVariables(), resp.getTimeReceived());
            try {
                Requester.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SnmpFetch cfr_ignored_1 = this._summary._fetcher;
            resp = SnmpFetch.get((SnmpPeer)Discover.getPeer(), (VarBindList)this._summary._trafficVbl);
            this._summary.updateTraffic(resp.getVariables(), resp.getTimeReceived());
            this.updateTable();
        }
        catch (SnmpException ex) {
            this.logException(ex);
        }
    }

    void logException(SnmpException ex) {
        if (ex.getMessage().indexOf("timeout") != -1) {
            DeviceManager.getInstance().setStatus("timeout at " + SnmpTimeticks.getDateFormat().format(new Date()));
        } else {
            DefaultLogger._DefLogger.debug((Object)(this.getName() + " " + (Object)((Object)ex)));
        }
    }

    void updateTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Requester.this._summary.updateTable();
            }
        });
    }
}

