/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.mds.flash.FlashFileDialog;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.NetUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Timer;

public class EditCopyImageForm
extends EditForm
implements ItemListener {
    static final int PROTOCOL = 0;
    static final int SERVER = 1;
    static final int USER = 2;
    static final int PASS = 3;
    public static final int SRC = 4;
    static final int DEST = 5;
    public static final int RUNNING = 1;
    public static final int SUCCESSFUL = 2;
    public static final int FLASHTOFLASH = 4;
    static final String SRVERLABEL = "Server Source File:";
    static final String SWITCHLABEL = "Switch Source File:";
    protected FlashFileDialog _fileDialog;
    SnmpPDU _ccStatusPDU;
    String _sourceFile = null;
    String _destDevice = null;
    int[] _index;
    protected Timer _statusTimer;
    int _elapsedPollTime;
    JLabel _sourceFileLabel;

    public EditCopyImageForm(String[] vars) {
        super(vars);
    }

    protected void build() {
        super.build();
        RadioButtonPanel rbp = (RadioButtonPanel)this.getComponentAt(0);
        rbp.setSelected(0);
        rbp.addChangeListener((ItemListener)this);
        rbp.setFont(ChangedCellRenderer.getNormalFont());
        try {
            Discover.getInstance();
            String localAddr = NetUtil.detectSourceAddress((InetAddress)Discover.getPeer().getAddress()).getHostAddress();
            this.setComponentText(1, localAddr);
        }
        catch (Exception ex) {
            this.setComponentText(1, "");
        }
        this.getButton('R').setVisible(false);
        this.getButton('A').setEnabled(true);
        this.setEnabled(2, false);
        this.setEnabled(3, false);
    }

    public void setFlashFile(FlashFileDialog dlg) {
        this._fileDialog = dlg;
    }

    public FlashFileDialog getFlashFile() {
        return this._fileDialog;
    }

    void setDefaultDest(String addr) {
        int splash = addr.lastIndexOf(47);
        if (splash == -1) {
            splash = addr.lastIndexOf(92);
        }
        if (splash != -1) {
            String fileName = addr.substring(splash + 1, addr.length());
            this.setComponentText(5, "bootflash:/" + fileName);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        int proto = ((RadioButtonPanel)this.getComponentAt(0)).getSelected();
        boolean b = proto > 0 && proto < 4;
        this.setEnabled(1, true);
        this.setEnabled(2, b);
        this.setEnabled(3, b);
        if (proto == 4) {
            this.setEnabled(1, false);
            if (this._sourceFile != null) {
                this.setComponentText(4, this._sourceFile);
            }
            FieldPanel srcField = (FieldPanel)this.getComponentAt(4);
            srcField.getComponent().setEnabled(false);
            this._sourceFileLabel.setText(SWITCHLABEL);
        } else {
            this.setComponentText(4, "");
            FieldPanel srcField = (FieldPanel)this.getComponentAt(4);
            srcField.getComponent().setEnabled(true);
            this._sourceFileLabel.setText(SRVERLABEL);
        }
    }

    public void setDestinationDevice(String str) {
        this._destDevice = str;
        this.setComponentText(5, this._destDevice);
    }

    protected JLabel createFormLabel(String mibVar, int index) {
        if (mibVar.equals("ciscoFlashCopySourceName")) {
            this._sourceFileLabel = super.createFormLabel(mibVar, index);
            return this._sourceFileLabel;
        }
        return super.createFormLabel(mibVar, index);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 4) {
            JButton browse = new JButton("...");
            browse.addActionListener((ActionListener)((Object)this));
            browse.setMargin(DialogUtil.getInsets());
            FieldPanel fp = new FieldPanel(20, (JComponent)browse);
            fp.getField().addFocusListener(new SourceAdrListener());
            return fp;
        }
        if (index == 5) {
            JLabel eg = new JLabel("[device:][//partition][path]");
            FieldPanel fp = new FieldPanel(20, (JComponent)eg);
            fp.setText(this._destDevice == null || this._destDevice.length() == 0 ? "bootflash:/" : this._destDevice);
            return fp;
        }
        if (index == 3) {
            return new JPasswordField();
        }
        if (index == 0) {
            MibEnum[] enums = mibNode.getEnums();
            Object[] finalArr = new Object[enums.length + 1];
            System.arraycopy(enums, 0, finalArr, 0, enums.length);
            finalArr[finalArr.length - 1] = "flashToFlash";
            int grid = this.getEnumGrid(index);
            if (finalArr.length < grid * 2) {
                grid = finalArr.length;
            }
            return new RadioButtonPanel(finalArr, grid);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected void get() {
    }

    protected void addChangeListener(int index) {
    }

    protected void set() throws Exception {
        this._index = new int[1];
        this._index[0] = (int)(Math.random() * 2.14748364E8) + 1;
        this._ccStatusPDU = null;
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get((String)"ciscoFlashCopyEntryStatus").getOid(), this._index), (SnmpVar)new SnmpInt(5));
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || !this._mibNodes[i].isEditable() || !this.getComponentAt(i).isEnabled()) continue;
            pdu.addVar(new SnmpOID(this._mibNodes[i].getOid(), this._index), this.getComponentValue(i));
        }
        pdu.addVar(new SnmpOID(MibNode.get((String)"ciscoFlashCopyCommand").getOid(), this._index), (SnmpVar)new SnmpInt(1));
        pdu.setIgnoreSetCount(true);
        pdu.setVarBindMask(new int[]{pdu.getVariables().size() - 4});
        this.sendPdu(pdu);
        pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get((String)"ciscoFlashCopyEntryStatus").getOid(), this._index), (SnmpVar)new SnmpInt(1));
        pdu.setIgnoreSetCount(true);
        this.sendPdu(pdu);
        this._parent.setCursor(Cursor.getPredefinedCursor(3));
        this._ccStatusPDU = new SnmpPDU(-96, new VarBindList());
        this._ccStatusPDU.addNull(new SnmpOID(MibNode.get((String)"ciscoFlashCopyStatus").getOid(), this._index));
        this._elapsedPollTime = 0;
        this._statusTimer = new Timer(3000, (ActionListener)((Object)this));
        this._statusTimer.start();
        this.enableButton('A', false);
    }

    void pollSwitch() throws Exception {
        if (this._parent == null) {
            return;
        }
        SnmpPDU resp = this.getPeer().send(this._ccStatusPDU);
        if (resp.getVar(0).getType() == 5) {
            throw new Exception("Copy Config failed: unknown");
        }
        int state = ((SnmpInt)resp.getVar(0)).getValue();
        if (state == 1) {
            this.setStatus(this._elapsedPollTime + " secs");
            return;
        }
        this.stopPolling();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get((String)"ciscoFlashCopyEntryStatus").getOid(), this._index), (SnmpVar)new SnmpInt(6));
        pdu.setIgnoreSetCount(true);
        this.getPeer().set(pdu);
        if (state != 2) {
            this.setStatus(" ");
            throw new Exception("Failed: " + MibEnum.getLabel((MibEnum[])MibNode.get((String)"ciscoFlashCopyStatus").getEnums(), (int)state));
        }
        this.setStatus("File transfer successful [" + this._elapsedPollTime + " secs]");
    }

    void stopPolling() {
        this._statusTimer.stop();
        this._parent.setCursor(Cursor.getDefaultCursor());
        this.enableButton('A', true);
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (e.getSource() == this._statusTimer) {
            try {
                this._elapsedPollTime += 3;
                this.pollSwitch();
            }
            catch (Exception ex) {
                this.stopPolling();
                throw ex;
            }
        } else if (ch == '.') {
            String fName = Util.getFileName((JFrame)DeviceManager.getInstance(), (String)"*.*", (int)0, (boolean)true);
            if (fName != null) {
                this.setComponentText(4, fName);
                this.setDefaultDest(fName);
            }
        } else if (ch == 'A') {
            int proto;
            if (this._fileDialog != null && (proto = ((RadioButtonPanel)this.getComponentAt(0)).getSelected()) == 4) {
                String source = this.getComponentText(4);
                String dest = this.getComponentText(5);
                ArrayList result = this._fileDialog.copy(source, dest);
                String resultString = result.get(1).toString();
                if (!((Boolean)result.get(0)).booleanValue()) {
                    this.setStatus("Success");
                } else {
                    this.setStatus("");
                    Util.errorMessage((Component)this._parent, (String)resultString);
                }
                return;
            }
            super.doIt(ch, e);
        } else {
            super.doIt(ch, e);
        }
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        try {
            if (index == 4 && ((FieldPanel)this._values[index]).getText().equals("")) {
                throw new Exception("Please provide Source Name.");
            }
            return super.getComponentValue(index);
        }
        catch (Exception ex) {
            if (index == 1) {
                String server = ((JTextField)this._values[index]).getText();
                try {
                    InetAddress addr = InetAddress.getByName(server);
                    return new SnmpIpAddress(addr.getHostAddress());
                }
                catch (Exception ex2) {
                    throw ex;
                }
            }
            if (index == 0) {
                int selected = ((RadioButtonPanel)this._values[index]).getSelected();
                if (selected == 4) {
                    return new SnmpInt(1);
                }
                throw ex;
            }
            throw ex;
        }
    }

    public void setSource(String text) {
        this._sourceFile = text;
    }

    class SourceAdrListener
    extends FocusAdapter {
        SourceAdrListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String addr = EditCopyImageForm.this.getComponentText(4);
            EditCopyImageForm.this.setDefaultDest(addr);
        }
    }
}

