/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;

public class EditLCFeatureTable
extends EditTable {
    private static final String FM_SERVER_INDEX = "FM_SERVER_PKG";

    public EditLCFeatureTable(String[] vars) {
        super(vars);
    }

    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt((Object)"Check In FM", 0);
        return btns;
    }

    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("In");
    }

    protected void buildModel() {
        super.buildModel();
        this._tableModel.setHeader(7, "Errors");
    }

    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        boolean isUsed;
        boolean TYPE = true;
        int INSTALLED = 2;
        int EXPIRY = 4;
        int GRACE = 5;
        int ERRORS = 7;
        VarBindList vbl = pdu.getVariables();
        SnmpVar var = vbl.getVb(0).getVar();
        byte[] bits = ((SnmpString)var).getValue();
        int miss = vbl.intValue(5);
        int curr = vbl.intValue(2);
        int gracePeriod = vbl.intValue(4);
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        String pkgName = (String)row[0];
        boolean isFMServer = pkgName.equals(FM_SERVER_INDEX);
        boolean bl = isUsed = curr != 0;
        if (isFMServer) {
            this._buttons[0].setVisible(isUsed);
        }
        if (!SnmpString.getBitBase0((byte[])bits, (int)2)) {
            row[2] = new SnmpString("");
        }
        if (SnmpString.getBitBase0((byte[])bits, (int)1)) {
            row[4] = "never";
            row[5] = "";
        }
        if (SnmpString.getBitBase0((byte[])bits, (int)3)) {
            row[4] = "";
        }
        row[1] = MibVariableFormat.clmLicenseFlag((SnmpVar)var, (int)gracePeriod);
        row[5] = MibVariableFormat.clmLicenseGracePeriodLeft((int)gracePeriod, (SnmpVar)var);
        if (gracePeriod == 0) {
            row[7] = "Grace Expired";
        }
        row[7] = miss > 0 ? (row[7].toString().length() > 0 ? row[7].toString() + ",License File Missing" : "License File Missing") : "";
        return row;
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'I') {
            SnmpPDU spinLockPdu = new SnmpPDU(-96, new VarBindList());
            spinLockPdu.addNull(new SnmpOID(MibNode.get((String)"clmLicenseConfigSpinLock").getOid(), 0));
            SnmpPDU resp = this.getPeer().send(spinLockPdu);
            SnmpInt nSpinLock = (SnmpInt)resp.getVar(0);
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get((String)"clmLicenseConfigSpinLock").getOid(), 0), (SnmpVar)nSpinLock);
            pdu.addVar(new SnmpOID(MibNode.get((String)"clmLicenseRequestFeatureName").getOid(), 0), (SnmpVar)new SnmpString(FM_SERVER_INDEX));
            pdu.addVar(new SnmpOID(MibNode.get((String)"clmLicenseRequestCommand").getOid(), 0), (SnmpVar)new SnmpInt(1));
            this.getPeer().set(pdu);
            this.get();
        } else {
            super.doIt(ch, e);
        }
    }
}

