/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.event.ListSelectionEvent;

public class EditLCFileTable
extends EditTable {
    int[] _lastLCFileName;
    static final int NOOFROW = 1;
    static final int[] _clmLicenseFileRowContentsOid = MibNode.get((String)"clmLicenseFileRowContents").getOid();

    public EditLCFileTable(String[] vars) {
        super(vars);
    }

    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        Object[] newRow = new Object[row.length + 1];
        System.arraycopy(row, 0, newRow, 0, row.length);
        newRow[newRow.length - 1] = newRow[newRow.length - 3];
        return newRow;
    }

    protected void build() {
        super.build();
        this._table.removeColumn(this._table.getColumnModel().getColumn(1));
    }

    protected void get() {
        this._lastLCFileName = null;
        super.get();
    }

    protected boolean isSkip(SnmpPDU pdu) {
        int[] oid = pdu.getVariables().get(0).getOid().getValue();
        int[] newName = new int[oid[_clmLicenseFileRowContentsOid.length]];
        System.arraycopy(oid, _clmLicenseFileRowContentsOid.length + 1, newName, 0, newName.length);
        if (this._lastLCFileName == null) {
            this._lastLCFileName = newName;
            return false;
        }
        boolean isSame = SnmpOID.equals((int[])newName, (int[])this._lastLCFileName);
        this._lastLCFileName = newName;
        return isSame;
    }

    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt((Object)"Details...", 0);
        return btns;
    }

    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("FD");
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('F', this._table.getSelectedRowCount() == 1);
    }

    protected void updateTable() {
        super.updateTable();
        this.enableButton('F', false);
    }

    public void dispose() {
        DMDialog d = DialogListener.getInstance().getDialog("LicenseManagerFile");
        if (d != null) {
            d.dispose();
        }
        super.dispose();
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'F') {
            String name = (String)this._tableModel.getValueAt(this._table.getSelectedRow(), 0);
            SnmpString nameVb = new SnmpString(name);
            byte[] nameB = nameVb.getValue();
            int[] index = new int[nameB.length + 2];
            index[0] = nameB.length;
            index[index.length - 1] = (int)((SnmpGauge)this._tableModel.getValueAt(this._table.getSelectedRow(), 1)).getValue();
            for (int j = 0; j < nameB.length; ++j) {
                index[j + 1] = nameB[j] & 0xFF;
            }
            DMDialog d = DialogListener.getInstance().dialogAction("LicenseManagerFile", index);
            d.setTitle(Discover.getDeviceName() + " - " + name);
        } else {
            super.doIt(ch, e);
        }
    }
}

