/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.Timer;

public class EditLCGenForm
extends EditForm {
    static final int LICENSEURI = 1;
    static final int LICENSENAME = 2;
    static final int STATUS = 3;
    static final int INPROGRESS = 2;
    static final int INSTALL = 1;
    static final int UNINSTALL = 2;
    static final int UPDATE = 4;
    Timer _statusTimer;
    MibNode _statusNode = MibNode.get((String)"clmLicenseConfigCommandStatus");
    VarBindList _statusVarBindList = new VarBindList();
    FieldPanel _uri;
    JComponent _name;

    public EditLCGenForm(String[] vars) {
        super(vars);
    }

    protected void build() {
        super.build();
        this.getButton('A').setVisible(false);
    }

    protected Array getButtons() {
        Array a = super.getButtons();
        a.insertElementAt((Object)"Copy...", 0);
        a.insertElementAt((Object)"Uninstall", 0);
        a.insertElementAt((Object)"Update", 0);
        a.insertElementAt((Object)"Install", 0);
        return a;
    }

    protected void buildButtons() {
        super.buildButtons();
        this._buttons[1].setActionCommand("T");
        this._buttons[3].setActionCommand("X");
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        JComponent c = super.buildComponent(mibVar, mibNode, index);
        if (index == 1) {
            this._uri = new FieldPanel(new KTextField(0), (JComponent)((Object)new FileMenuButton(null, this.getPeer())));
            c = this._uri;
        } else if (index == 2) {
            this._name = c;
        }
        return c;
    }

    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 1) {
            return new JLabel("URI:", 4);
        }
        if (index == 2) {
            return new JLabel("Target Filename:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'I' || ch == 'T') {
            String licenseURI = this.getComponentText(1).trim();
            if (licenseURI.length() == 0) {
                Util.errorMessage((Component)this.getParent(), (String)"Please specify URI, ie bootflash:license_file.lic");
                return;
            }
            if (ch == 'I') {
                this.install(this._mibNodes[1].getOid(), licenseURI, 1);
            } else {
                this.install(this._mibNodes[1].getOid(), licenseURI, 4);
            }
        } else if (ch == 'U') {
            String license = this.getComponentText(2).trim();
            if (license.length() == 0) {
                Util.errorMessage((Component)this.getParent(), (String)"Please specify name");
                return;
            }
            this.install(this._mibNodes[2].getOid(), license, 2);
        } else {
            if (ch == 'X') {
                DialogListener.getInstance().dialogAction("Copy_Files");
                return;
            }
            super.doIt(ch, e);
        }
    }

    protected void install(int[] licenseOid, String name, int option) throws SnmpException {
        SnmpPDU spinLockPdu = new SnmpPDU(-96, new VarBindList());
        spinLockPdu.addNull(new SnmpOID(MibNode.get((String)"clmLicenseConfigSpinLock").getOid(), 0));
        SnmpPDU resp = this.getPeer().send(spinLockPdu);
        if (!(resp.getVariables().get(0).getVar() instanceof SnmpInt)) {
            throw new SnmpException("Failed to retrive SpinLock.");
        }
        SnmpInt nSpinLock = (SnmpInt)resp.getVar(0);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(licenseOid, 0), (SnmpVar)new SnmpString(name));
        pdu.addVar(new SnmpOID(MibNode.get((String)"clmLicenseConfigCommand").getOid(), 0), (SnmpVar)new SnmpInt(option));
        pdu.addVar(new SnmpOID(MibNode.get((String)"clmLicenseConfigSpinLock").getOid(), 0), (SnmpVar)nSpinLock);
        if (option == 1 || option == 4) {
            String licName = this.getComponentText(2);
            String targetName = licName != null ? licName.trim() : "";
            pdu.addVar(new SnmpOID(this._mibNodes[2].getOid(), 0), (SnmpVar)new SnmpString(targetName));
        }
        this.getPeer().set(pdu);
        if (this._statusTimer == null) {
            this._statusTimer = new Timer(3000, (ActionListener)((Object)this));
        }
        if (this._statusTimer.isRunning()) {
            this._statusTimer.restart();
        }
        this._statusTimer.start();
        this.doPoll();
    }

    public void dispose() {
        this.stopPoll();
        super.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._statusTimer) {
                this.doPoll();
            }
        }
        catch (SnmpException se) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (Exception)((Object)se));
        }
        super.actionPerformed(e);
    }

    private void stopPoll() {
        if (this._statusTimer != null && this._statusTimer.isRunning()) {
            this._statusTimer.stop();
        }
    }

    private void doPoll() throws SnmpException {
        if (this._parent == null) {
            this.stopPoll();
        }
        SnmpPDU getPDU = new SnmpPDU(-96, this._statusVarBindList);
        getPDU.addNull(new SnmpOID(this._statusNode.getOid(), 0));
        SnmpPDU respPDU = this.getPeer().send(getPDU);
        VarBindList respList = respPDU.getVariables();
        SnmpInt status = (SnmpInt)respList.getVb(0).getVar();
        super.setComponentValue(3, (SnmpVar)status);
        if (status.getValue() != 2) {
            this.stopPoll();
        }
        this.get();
    }

    class FileMenuButton
    extends MenuButton {
        SnmpPeer _peer;

        public FileMenuButton(JMenu menu, SnmpPeer peer) {
            super(menu);
            this._peer = peer;
        }

        public void actionPerformed(ActionEvent e) {
            this._menu = new JMenu();
            try {
                Object[] names = this.getFiles();
                if (names == null) {
                    this.setEnabled(false);
                    return;
                }
                this.buildMenu(names);
            }
            catch (SnmpException ex) {
                // empty catch block
            }
            if (e.getSource() instanceof JMenuItem) {
                String newVal = ((JMenuItem)e.getSource()).getText();
                EditLCGenForm.this._uri.setText("bootflash:/" + newVal);
                ((KTextField)EditLCGenForm.this._name).setText(newVal);
            } else {
                super.actionPerformed(e);
            }
        }

        String[] getFiles() throws SnmpException {
            int[] index = new int[]{1, 1};
            VarBindList vbl = new VarBindList();
            vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"ciscoFlashFileName").getOid(), index)));
            vbl = SnmpFetch.getBulk((SnmpPeer)this._peer, (VarBindList)vbl).getVariables();
            if (vbl.size() == 0) {
                return null;
            }
            String[] names = new String[vbl.size()];
            int num = 0;
            for (int i = 0; i < names.length; ++i) {
                String f = vbl.get(i).getVar().toString();
                if (!f.endsWith(".lic")) continue;
                if (f.startsWith("/")) {
                    f = f.substring(1);
                }
                names[num++] = f;
            }
            String[] vals = new String[num];
            System.arraycopy(names, 0, vals, 0, num);
            return vals;
        }
    }
}

