/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.event;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditRmonTable
extends EditTable {
    static final int INTERVAL = 1;
    static final int VARIABLE = 2;
    static final int SAMPLETYPE = 3;
    static final int ALARMTYPE = 5;
    static final int RISING_THRESHOLD = 6;
    static final int RISINGEVENT = 7;
    static final int FALLING_THRESHOLD = 8;
    static final int FALLINGEVENT = 9;
    static final int OWNER = 11;
    static final int POSITIVE = 2;
    static final int NAGATIVE = 3;
    static final int UNDER_CREATION = 3;
    static final int NOT_IN_SERVICE = 2;
    boolean _isSupportEntryModify = Discover.isSysVersionGreaterThanEqual((String)"4.1(3)");
    boolean _isHCAlarm = false;

    public EditRmonTable(String[] vars, boolean isHCAlarm) {
        super(vars);
        this._isHCAlarm = isHCAlarm;
    }

    protected void build() {
        super.build();
        boolean bl = this._isSupportEntryModify = this._isSupportEntryModify && this.getButton('A') != null;
        if (this.getButton('A') != null) {
            this.getButton('A').setVisible(this._isSupportEntryModify);
        }
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        if (pdu.getVariables().size() > 0) {
            int preIndex;
            int[] oid = pdu.getVariables().get(0).getOid().getValue();
            int index = preIndex = oid[oid.length - 1];
            VarBindList vbl = new VarBindList();
            for (int i = 0; i < pdu.getVariables().size(); ++i) {
                oid = pdu.getVariables().get(i).getOid().getValue();
                index = oid[oid.length - 1];
                if (index != preIndex) {
                    this.applyChangeRmon(pdu, preIndex, vbl);
                    preIndex = index;
                    vbl = new VarBindList();
                }
                vbl.add(pdu.getVariables().get(i));
            }
            this.applyChangeRmon(pdu, index, vbl);
        } else {
            super.sendPdu(pdu);
        }
    }

    private void applyChangeRmon(SnmpPDU pdu, int index, VarBindList vbl) throws SnmpException {
        SnmpPDU rowStatusPDU = new SnmpPDU(-93, new VarBindList());
        int action = this._isHCAlarm ? 2 : 3;
        rowStatusPDU.addVar(new SnmpVarBind(new SnmpOID(this._rowStatus, index), (SnmpVar)new SnmpInt(action)));
        super.sendPdu(rowStatusPDU);
        super.sendPdu(new SnmpPDU(-93, vbl));
        rowStatusPDU.getVariables().get(0).setVar((SnmpVar)new SnmpInt(1));
        try {
            super.sendPdu(rowStatusPDU);
        }
        catch (SnmpException ex) {
            throw new SnmpException("Failed to activate entry, please manually activate entry later: " + ex.getMessage());
        }
    }

    protected DmTableModel buildTableModel() {
        return new SnmpRmonTableModel();
    }

    class SnmpRmonTableModel
    extends DmTableModel {
        SnmpRmonTableModel() {
        }

        public boolean isCellEditable(int row, int col) {
            if (col == 1 || col == 2 || col == 3 || col == 5 || col == 6 || col == 7 || col == 8 || col == 9 || col == 11) {
                return EditRmonTable.this._isSupportEntryModify;
            }
            return super.isCellEditable(row, col);
        }
    }
}

