/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.event;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.TrapRegister;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.NetUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class InsertEventTarget
extends InsertForm
implements ItemListener {
    public static final int V1_MODEL = 0;
    public static final int V2_MODEL = 1;
    public static final int V3_MODEL = 3;
    static final int NO_AUTH_NO_PRIV = 1;
    static final int AUTH_NO_PRIV = 2;
    int[] _TDDomain = new int[]{1, 3, 6, 1, 6, 3, 12, 1, 2, 1, 2};
    int[] _UDPDomain = new int[]{1, 3, 6, 1, 6, 1, 1};
    int[] _UDPIpV6Domain = new int[]{1, 3, 6, 1, 2, 1, 100, 1, 2};
    protected JComboBox _paramsList;
    protected RadioButtonPanel _tagList;
    int _nameIndex = this.getVarIndex("snmpTargetAddrName");
    int _TAddress = this.getVarIndex("snmpTargetAddrTAddress");
    int _tagListIndex = this.getVarIndex("snmpTargetAddrTagList");
    int _paramsIndex = this.getVarIndex("snmpTargetAddrParams");
    int _retry = this.getVarIndex("snmpTargetAddrTimeout");
    int _timeout = this.getVarIndex("snmpTargetAddrRetryCount");
    static final int INFORM = 0;
    static final int TRAP = 1;
    static final SnmpInt _CREATEANDGO = new SnmpInt(4);
    static final SnmpInt _NOTINSERVICE = new SnmpInt(2);
    static final SnmpInt _ACTIVE = new SnmpInt(1);
    public static final int[] _usmUserCloneFromOid = MibNode.get((String)"usmUserCloneFrom").getOid();
    public static final int[] _usmUserStatusOid = MibNode.get((String)"usmUserStatus").getOid();
    static final int[] _usmUserSecurityNameOid = MibNode.get((String)"usmUserSecurityName").getOid();
    static final int[] _snmpTargetParamsSecurityNameOid = MibNode.get((String)"snmpTargetParamsSecurityName").getOid();
    public static final int[] _snmpTargetParamsRowStatusOid = MibNode.get((String)"snmpTargetParamsRowStatus").getOid();
    boolean isV3Trap = false;
    int[] _tagStatus;
    String _securityParam;
    boolean _isIpV6 = false;

    public InsertEventTarget(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected void build() {
        int i;
        super.build();
        this.getComponentAt(this._nameIndex).setVisible(false);
        this._labels[this._nameIndex].setVisible(false);
        FieldPanel f = (FieldPanel)this.getComponentAt(this._TAddress);
        try {
            Discover.getInstance();
            String localAddr = NetUtil.detectSourceAddress((InetAddress)Discover.getPeer().getAddress()).getHostAddress();
            f.setText(localAddr);
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)("EventTargetInsert " + ex));
        }
        f.getField().addFocusListener(new TAddrNameListener());
        if (this._values[this._paramsIndex] instanceof JComboBox) {
            JComboBox param = (JComboBox)this._values[this._paramsIndex];
            for (i = 0; i < param.getItemCount(); ++i) {
                if (!((String)param.getItemAt(i)).startsWith("v2c")) continue;
                param.setSelectedIndex(i);
                break;
            }
            param.addActionListener((ActionListener)((Object)this));
        }
        if (this._values[this._tagListIndex] instanceof GroupButtonPanel) {
            GroupButtonPanel tag = (GroupButtonPanel)this._values[this._tagListIndex];
            for (i = 0; i < tag.getComponentCount(); ++i) {
                if (tag.getButton(i).getText().startsWith("trap")) {
                    tag.setSelected(i);
                }
                tag.getButton(i).setEnabled(this._tagStatus[i] == 1);
            }
            tag.addChangeListener((ItemListener)this);
        }
        this._values[this._retry].setEnabled(false);
        this._values[this._timeout].setEnabled(false);
        this._labels[this._retry].setEnabled(false);
        this._labels[this._timeout].setEnabled(false);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (mibVar.equals("snmpTargetAddrParams")) {
            String[] v = new String[]{"snmpTargetParamsSecurityModel"};
            String[] params = new String[]{"v1", "v2c", "v3"};
            this._paramsList = new JComboBox<String>(params);
            this._paramsList.setActionCommand("params");
            return this._paramsList;
        }
        if (mibVar.equals("snmpTargetAddrTagList")) {
            String[] v = new String[]{"snmpNotifyTag", "snmpNotifyRowStatus"};
            Object[] tags = this.getParams(v, false);
            if (tags == null) {
                return new JLabel("No tags");
            }
            this._tagList = new RadioButtonPanel(tags, 3);
            return this._tagList;
        }
        if (mibVar.equals("snmpTargetAddrTimeout")) {
            return new FieldPanel(mibNode.getMaxWidth(), (JComponent)new JLabel(" " + SnmpTableModel._Units.get(mibVar)));
        }
        if (index == this._TAddress) {
            String units = (String)SnmpTableModel._Units.get(mibVar);
            JLabel l = new JLabel(" " + units);
            l.setFont(ChangedCellRenderer.getNormalFont());
            return new FieldPanel(20, (JComponent)l);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._paramsIndex) {
            return new SnmpString((String)((JComboBox)this._values[index]).getSelectedItem());
        }
        if (index == this._tagListIndex) {
            if (this._values[index] instanceof JLabel) {
                throw new Exception("No tag");
            }
            int selected = ((RadioButtonPanel)this._values[index]).getSelected();
            if (selected == -1) {
                throw new Exception(this._labels[index].getText() + " please make a selection");
            }
            String tag = ((RadioButtonPanel)this._values[index]).getButton(selected).getText();
            return new SnmpString(tag);
        }
        return super.getComponentValue(index);
    }

    protected SnmpVar getVarFromString(String text, int index) throws Exception {
        if (index == this._TAddress) {
            try {
                byte[] b = TrapRegister.getTargetAddress((String)text);
                this._isIpV6 = b.length != 6;
                return new SnmpString(b);
            }
            catch (Exception ex) {
                throw new SnmpException(ex.getMessage());
            }
        }
        if (index == this._nameIndex) {
            return new SnmpString(text, true);
        }
        return super.getVarFromString(text, index);
    }

    protected String getComponentText(int index) {
        return super.getComponentText(index);
    }

    protected void insert() throws Exception {
        this._isIpV6 = false;
        if (((FieldPanel)this._values[this._TAddress]).getText().equals("")) {
            throw new Exception("Warning! IpAddress cannot be empty");
        }
        super.insert();
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        this._securityParam = null;
        int[] paramIndex = this.securityParamInsert(index, (String)this._paramsList.getSelectedItem());
        if (this._securityParam == null || paramIndex == null) {
            throw new Exception("failed to allocate a security parameters");
        }
        try {
            super.tableInsert(values, index);
        }
        catch (Exception ex) {
            try {
                this.securityParamRollback(paramIndex);
            }
            catch (SnmpException ex1) {
                Util.errorMessage((Component)this._parent, (String)"failed to rollback security parameters");
            }
            throw new Exception(ex.getMessage());
        }
        if (this.isV3Trap) {
            this.usmV3TrapUserInsert(index, paramIndex);
        }
    }

    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        String addrPortString;
        String addrString = addrPortString = this.getComponentText(this._nameIndex);
        int port = 0;
        if (addrPortString.indexOf(47) != -1) {
            String b = addrPortString.substring(addrPortString.indexOf(47) + 1);
            try {
                port = Integer.parseInt(addrPortString.substring(addrPortString.indexOf(47) + 1));
            }
            catch (Exception ex) {
                throw new Exception("Port: please provide integer.");
            }
            addrString = addrPortString.substring(0, addrPortString.indexOf(47));
        }
        InetAddress addr = InetAddress.getByName(addrString);
        return TrapRegister.getTargetIndex((InetAddress)addr, (int)port, (char)'-', (String)addrPortString);
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        int[] paramIndex = new int[index.length - 1];
        System.arraycopy(index, 1, paramIndex, 0, paramIndex.length);
        pdu.getVariables().get(this._paramsIndex).setVar((SnmpVar)new SnmpString(this._securityParam, true));
        pdu.addVar(new SnmpOID(this._TDDomain, index), (SnmpVar)new SnmpOID(this._isIpV6 ? this._UDPIpV6Domain : this._UDPDomain));
        return pdu;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        boolean isTrap = ((JToggleButton)e.getSource()).getText().equals("trap");
        this._values[this._retry].setEnabled(!isTrap);
        this._values[this._timeout].setEnabled(!isTrap);
        this._labels[this._retry].setEnabled(!isTrap);
        this._labels[this._timeout].setEnabled(!isTrap);
    }

    protected int[] securityParamInsert(int[] index, String securitySelection) throws SnmpException {
        if ((index = this.findSecurityParam(index)) == null) {
            return null;
        }
        this._securityParam = SnmpString.toString((int[])index, (int)0, (int)index.length);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(6));
        pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsRowStatus").getOid(), index), (SnmpVar)new SnmpInt(4));
        switch (securitySelection.charAt(1)) {
            case '1': {
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsMPModel").getOid(), index), (SnmpVar)new SnmpInt(0));
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityModel").getOid(), index), (SnmpVar)new SnmpInt(1));
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityName").getOid(), index), (SnmpVar)new SnmpString("public"));
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityLevel").getOid(), index), (SnmpVar)new SnmpInt(1));
                break;
            }
            case '2': {
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsMPModel").getOid(), index), (SnmpVar)new SnmpInt(1));
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityModel").getOid(), index), (SnmpVar)new SnmpInt(2));
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityName").getOid(), index), (SnmpVar)new SnmpString("public"));
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityLevel").getOid(), index), (SnmpVar)new SnmpInt(1));
                break;
            }
            case '3': {
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsMPModel").getOid(), index), (SnmpVar)new SnmpInt(3));
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityModel").getOid(), index), (SnmpVar)new SnmpInt(3));
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityName").getOid(), index), (SnmpVar)new SnmpString("admin"));
                pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityLevel").getOid(), index), (SnmpVar)new SnmpInt(2));
            }
        }
        this.getPeer().set(pdu);
        return index;
    }

    private int[] findSecurityParam(int[] index) {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        int[] paramIndex = new int[index.length + 2];
        System.arraycopy(index, 0, paramIndex, 0, index.length);
        paramIndex[paramIndex.length - 2] = 47;
        for (int i = 0; i < 30; ++i) {
            SnmpPDU resp;
            paramIndex[paramIndex.length - 1] = Integer.toString(i).getBytes()[0] & 0xFF;
            String a = SnmpString.toString((int[])paramIndex, (int)0, (int)paramIndex.length);
            pdu.addNull(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityModel").getOid(), paramIndex));
            try {
                resp = this.getPeer().send(pdu);
            }
            catch (SnmpException ex) {
                continue;
            }
            if (resp.getVariables().get(0).getVar().getType() == 5) {
                return paramIndex;
            }
            pdu.reset();
            pdu.setCommand((byte)-96);
        }
        return null;
    }

    private void securityParamRollback(int[] index) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(6));
        pdu.addVar(new SnmpOID(MibNode.get((String)"snmpTargetParamsRowStatus").getOid(), index), (SnmpVar)new SnmpInt(6));
        this.getPeer().send(pdu);
    }

    void usmV3TrapUserInsert(int[] userIndex, int[] paramIndex) throws Exception {
        try {
            boolean isEventSecurityV3 = false;
            String newUser = "admin";
            String cloneUser = this.getDefaultV3SecurityName(paramIndex);
            if (cloneUser == null) {
                throw new Exception("No v3 Security");
            }
            if (cloneUser.equals(newUser)) {
                isEventSecurityV3 = true;
                cloneUser = this.getPeer().getUserName();
            }
            byte[] engineId = this.getPeer().getEngineId();
            String ip = this.getComponentText(1);
            int slash = ip.indexOf(47);
            this.getPeer().getSession();
            byte[] myEngineId = SnmpSession.formEngineId((byte[])(slash == -1 ? SnmpIpAddress.parse((String)ip) : SnmpIpAddress.parse((String)ip.substring(0, slash))));
            this.getPeer().getSession();
            byte[] baseEngineId = SnmpSession.formEngineId((byte[])SnmpIpAddress.parse((String)"0.0.0.0"));
            String cloneAuthPassword = "andiamo123";
            String newAuthPassword = "123456789";
            if (!isEventSecurityV3) {
                String paramsName = "v3";
                SnmpPDU pdu = new SnmpPDU(-93);
                int[] index = new int[paramsName.length()];
                for (int i = 0; i < index.length; ++i) {
                    index[i] = paramsName.charAt(i);
                }
                pdu.addVar(new SnmpOID(_snmpTargetParamsRowStatusOid, index), (SnmpVar)_NOTINSERVICE);
                this.getPeer().set(pdu);
                pdu.reset();
                pdu.setCommand((byte)-93);
                pdu.addVar(new SnmpOID(_snmpTargetParamsSecurityNameOid, index), (SnmpVar)new SnmpString(newUser));
                this.getPeer().set(pdu);
                pdu.reset();
                pdu.setCommand((byte)-93);
                pdu.addVar(new SnmpOID(_snmpTargetParamsRowStatusOid, index), (SnmpVar)_ACTIVE);
                this.getPeer().set(pdu);
            }
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)("usmV3TrapUserInsert error : " + ex.getMessage()));
            throw new Exception(ex.getMessage());
        }
    }

    String getDefaultV3SecurityName(int[] paramIndex) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get((String)"snmpTargetParamsSecurityName").getOid(), paramIndex));
        SnmpPDU resp = this.getPeer().send(pdu);
        SnmpVar v = resp.getVar(0);
        if (v.getType() == 5) {
            return null;
        }
        return v.toString();
    }

    String[] getParams(String[] mibVars, boolean returnIndex) {
        SnmpPDU resp;
        VarBindList vbl = new VarBindList(1);
        int[] snmpNotifyTag = null;
        for (int i = 0; i < mibVars.length; ++i) {
            snmpNotifyTag = MibNode.get((String)mibVars[i]).getOid();
            vbl.add(new SnmpVarBind(new SnmpOID(snmpNotifyTag)));
        }
        try {
            resp = SnmpFetch.getBulk((SnmpPeer)this.getPeer(), (VarBindList)vbl);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this.getParent(), (String)ex.getMessage());
            return null;
        }
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        String[] tags = new String[vbl.size() / mibVars.length];
        this._tagStatus = new int[vbl.size() / mibVars.length];
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.get(i);
            if (returnIndex) {
                int[] responseOid = vb.getOid().getValue();
                tags[i] = SnmpString.toString((int[])responseOid, (int)snmpNotifyTag.length, (int)responseOid.length);
                continue;
            }
            tags[i / 2] = ((SnmpString)vb.getVar()).toString();
            SnmpVarBind status = vbl.get(++i);
            this._tagStatus[(i - 1) / 2] = ((SnmpInt)status.getVar()).getValue();
        }
        return tags;
    }

    protected void setTargetField(int index, String name) {
        if (index == 0) {
            ((JTextField)this._values[index]).setText(name);
        } else {
            ((FieldPanel)this._values[index]).setText(name);
        }
    }

    protected void setTag(String params) {
        boolean isV1 = params.equals("v1");
        GroupButtonPanel tag = (GroupButtonPanel)this._values[this._tagListIndex];
        JToggleButton informBtn = tag.getButton(0);
        JToggleButton trapBtn = tag.getButton(1);
        informBtn.setEnabled(!isV1);
        if (informBtn.isSelected() && !informBtn.isEnabled()) {
            tag.setSelected(1);
        }
        this.isV3Trap = params.equals("v3") && trapBtn.isSelected();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("params")) {
            this.setTag((String)((JComboBox)e.getSource()).getSelectedItem());
        } else {
            super.actionPerformed(e);
        }
    }

    class TAddrNameListener
    extends FocusAdapter {
        TAddrNameListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String addr = InsertEventTarget.this.getComponentText(1);
            int splash = addr.indexOf(47);
            if (!addr.equals("") && splash == -1) {
                addr = addr + '/' + TrapRegister._Port;
                InsertEventTarget.this.setTargetField(1, addr);
            }
            InsertEventTarget.this.setTargetField(0, addr);
        }
    }
}

