/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.event;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.event.ThresholdManager;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTextField;

public class InsertRmonAlarm
extends InsertForm {
    static String[] variableList32 = null;
    protected int VARIABLE = 2;
    private int STARTUP_TYPE = 4;
    private int RISING_THRESHOLD = 5;
    private int RISING_EVENTID = 6;
    private int FALLING_THRESHOLD = 7;
    private int FALLING_EVENTID = 8;
    private int OWNER = 9;

    public InsertRmonAlarm(InsertDialog parent, EditTable table) {
        super(parent, table);
        table.setInsertValidate(1, true);
        if (variableList32 == null) {
            variableList32 = this.getVariableList(ThresholdManager._SummaryVars);
        }
    }

    protected void build() {
        super.build();
        ((RadioButtonPanel)this.getComponentAt(this.STARTUP_TYPE)).setSelected(0);
        ((FieldPanel)this.getComponentAt(this.VARIABLE)).getField().addFocusListener(new OwnerListener());
        ((JTextField)this.getComponentAt(this.RISING_THRESHOLD)).addFocusListener(new OwnerListener());
        ((JTextField)this.getComponentAt(this.FALLING_THRESHOLD)).addFocusListener(new OwnerListener());
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this.VARIABLE) {
            return new FieldPanel(30, (JComponent)((Object)new oidMenuButton(variableList32)));
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this.VARIABLE) {
            String var = this.getComponentText(index);
            if (var.length() == 0) {
                throw new Exception("Please enter a value");
            }
            if (var.indexOf(46) == var.length() - 1 || var.indexOf(46) == -1) {
                throw new Exception("Please provide interface");
            }
            if (Character.isLetter(var.charAt(0))) {
                if (var.indexOf(46) != -1) {
                    int dot = var.indexOf(46) + 1;
                    String ifName = var.substring(dot);
                    try {
                        int ifIndex = Discover.getRoot().nameToIfIndex(ifName);
                        var = var.substring(0, dot) + Integer.toString(ifIndex);
                    }
                    catch (Exception ex) {
                        var = var.substring(0, dot) + ifName;
                    }
                }
                int[] oid = MibNode.parseName((String)var);
                return new SnmpOID(oid);
            }
            String[] oids = StringUtil.tokenize((String)var, (String)".");
            int[] oid = new int[oids.length];
            for (int i = 0; i < oid.length; ++i) {
                oid[i] = Integer.valueOf(oids[i]);
            }
            return new SnmpOID(oid);
        }
        if (index == this.RISING_THRESHOLD || index == this.FALLING_THRESHOLD) {
            String text = ((KTextField)this._values[index]).getText();
            if (text.startsWith("-")) {
                text = text.substring(1);
            }
            if (!text.matches("\\d+")) {
                throw new Exception("Please enter valid numeric value.");
            }
        }
        return super.getComponentValue(index);
    }

    protected void insert() throws Exception {
        super.insert();
        ThresholdManager._alarmIndex = -1;
    }

    String[] getVariableList(String[][] defaultSummaryVars) {
        String[][] summaryMonitor = Discover.isSysVersionGreaterThanEqual((String)"3.0(0)") ? defaultSummaryVars : ThresholdManager._SummaryVars;
        String[] variableList = new String[summaryMonitor.length + ThresholdManager._PhysicalMonitor.length + ThresholdManager._DetailMonitor.length + ThresholdManager._ServicesMonitor.length];
        if (variableList.length == 0) {
            return null;
        }
        int ct = 0;
        int i = 0;
        while (i < summaryMonitor.length) {
            variableList[ct] = summaryMonitor[i][1];
            ++i;
            ++ct;
        }
        i = 0;
        while (i < ThresholdManager._PhysicalMonitor.length) {
            variableList[ct] = ThresholdManager._PhysicalMonitor[i][1];
            ++i;
            ++ct;
        }
        i = 0;
        while (i < ThresholdManager._DetailMonitor.length) {
            variableList[ct] = ThresholdManager._DetailMonitor[i][1];
            ++i;
            ++ct;
        }
        i = 0;
        while (i < ThresholdManager._ServicesMonitor.length) {
            variableList[ct] = ThresholdManager._ServicesMonitor[i][1];
            ++i;
            ++ct;
        }
        return variableList;
    }

    class OwnerListener
    extends FocusAdapter {
        OwnerListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String text;
            if (e.getSource() == InsertRmonAlarm.this._values[InsertRmonAlarm.this.RISING_THRESHOLD]) {
                if (((JTextField)InsertRmonAlarm.this._values[InsertRmonAlarm.this.FALLING_THRESHOLD]).getText().equals("") && (text = ((JTextField)InsertRmonAlarm.this._values[InsertRmonAlarm.this.RISING_THRESHOLD]).getText()) != null && text.matches("\\d+")) {
                    int rising = Integer.parseInt(text);
                    ((JTextField)InsertRmonAlarm.this._values[InsertRmonAlarm.this.FALLING_THRESHOLD]).setText(Integer.toString(rising - 1));
                }
            } else if (e.getSource() == InsertRmonAlarm.this._values[InsertRmonAlarm.this.FALLING_THRESHOLD] && ((JTextField)InsertRmonAlarm.this._values[InsertRmonAlarm.this.RISING_THRESHOLD]).getText().equals("") && (text = ((JTextField)InsertRmonAlarm.this._values[InsertRmonAlarm.this.FALLING_THRESHOLD]).getText()) != null && text.matches("\\d+")) {
                int rising = Integer.parseInt(text);
                ((JTextField)InsertRmonAlarm.this._values[InsertRmonAlarm.this.RISING_THRESHOLD]).setText(Integer.toString(rising + 1));
            }
            String mibVar = InsertRmonAlarm.this.getComponentText(InsertRmonAlarm.this.VARIABLE);
            try {
                InsertRmonAlarm.this.setComponentText(InsertRmonAlarm.this.OWNER, mibVar + "@" + InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    class oidMenuButton
    extends MenuButton {
        public oidMenuButton(Object[] items) {
            super(null);
            this._menu = this.buildMenu(items);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                if (this.getParent() instanceof FieldPanel) {
                    ((FieldPanel)this.getParent()).setText(this._isSetText ? ((JMenuItem)e.getSource()).getText() + "." : "");
                }
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

