/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.event;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.VsanIdCheckboxMenuButton;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MnemonicTabbedPane;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ThresholdManager
extends JDialog
implements ActionListener,
ItemListener,
ChangeListener {
    static final int ALARM_STATUS = 0;
    static final int ALARM_INTERVAL = 1;
    static final int ALARM_VARIABLE = 2;
    static final int ALARM_SAMPLE_TYPE = 3;
    static final int ALARM_STARTUP = 4;
    static final int ALARM_RISING_THRESHOLD = 5;
    static final int ALARM_RISING_EVENT = 6;
    static final int ALARM_FALLING_THRESHOLD = 7;
    static final int ALARM_FALLING_EVENT = 8;
    static final int ALARM_OWNER = 9;
    static final int RMON_32 = 0;
    static final int RMON_64 = 1;
    static final int PORT_TAB = 0;
    static final int SERVICE_TAB = 1;
    static final int PHYSICAL_TAB = 2;
    static int[] _AlarmIndexOid;
    static int[][] _AlarmOids;
    static final String[] _AlarmVars;
    static final String[] _AlarmVars_HC;
    static final int[] cHcAlarmRisingThreshAbsValueHiOid;
    static final int[] cHcAlarmFallingThreshAbsValueHiOid;
    static final int[] cHcAlarmRisingThresholdValStatusOid;
    static final int[] cHcAlarmFallingThrsholdValStatusOid;
    public static final String[][] _PhysicalMonitor;
    static String[][] _SummaryMonitor;
    public static final String[][] _SummaryVars;
    public static final String[][] _SummaryVars_HC;
    public static final String[][] _DetailMonitor;
    public static final String[][] _ServicesMonitor;
    static final int[] _MonitorValue;
    static final int[] _PhysicalMonitorValue;
    MnemonicTabbedPane _tab;
    static final int STARTUPTYPE = 4;
    static final int VALUE = 5;
    static final int INTERVAL = 6;
    static final int EVENT_ID = 7;
    static final String[] _Labels;
    static final boolean[] _Editable;
    static final String[] _PortTypeLabels;
    static final String[] _RmonTypes;
    final Severity[] _severityLevels = new Severity[]{new Severity(1, "FATAL(1)"), new Severity(2, "CRITICAL(2)"), new Severity(3, "ERROR(3)"), new Severity(4, "WARNING(4)"), new Severity(5, "INFORMATION(5)")};
    final StartupAlarmType[] _startupAlarmTypes = new StartupAlarmType[]{new StartupAlarmType(1, ">="), new StartupAlarmType(2, "<=")};
    static final int HI = 1;
    static final int LOW = 0;
    static final int OPER_UP = 1;
    JComboBox _severity;
    JComboBox _startupAlarmType;
    RadioButtonPanel _portType;
    RadioButtonPanel[] _rmonTypes = new RadioButtonPanel[3];
    MdsPortChooser _portChooser;
    FieldPanel _vsanId;
    SnmpPeer _peer;
    public static int _alarmIndex;
    boolean _isSeverityOk;
    KTableModel _portSummaryTableModel;
    KTableModel _portDetailTableModel;
    KTableModel _physicalTableModel;
    KTableModel _serviceTableModel;
    KTable _portSummaryTable;
    KTable _portDetailTable;
    KTable _physicalTable;
    KTable _serviceTable;
    int MAXALARM = 65535;
    byte[][] _availableAlarms = new byte[2][];
    int[] RmonConfiguredAlarmsOid = MibNode.get((String)"rmonConfiguredAlarms").getOid();
    int[] RmonConfiguredHcAlarmsid = MibNode.get((String)"rmonConfiguredHcAlarms").getOid();

    public ThresholdManager(JFrame parent, SnmpPeer peer) {
        super(parent);
        this.setTitle(Discover.getDeviceName() + " - Threshold Manager");
        _SummaryMonitor = Discover.isSysVersionGreaterThanEqual((String)"3.0(0)") ? _SummaryVars_HC : _SummaryVars;
        try {
            this._severity = new JComboBox<Severity>(this._severityLevels);
            this._severity.setEditable(false);
            this._startupAlarmType = new JComboBox<StartupAlarmType>(this._startupAlarmTypes);
            this._startupAlarmType.setEditable(false);
            this._tab = new MnemonicTabbedPane();
            this._tab.addChangeListener((ChangeListener)this);
            this._peer = peer;
            JPanel portPanel = this.buildPortPanel();
            this._tab.add("FC Interfaces", (Component)portPanel);
            this._tab.setMnemonicAt(0, 'F');
            JPanel servicePanel = this.buildServicePanel();
            this._tab.add("Services", (Component)servicePanel);
            this._tab.setMnemonicAt(1, 'S');
            JPanel physicalPanel = this.buildPhysicalPanel();
            this._tab.add("Physical", (Component)physicalPanel);
            this._tab.setMnemonicAt(2, 'P');
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)ex);
        }
        String[] bLabels = new String[]{"Create", "More...", "Close"};
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)this._tab, (AbstractButton[])DialogUtil.buildButtons((String[])bLabels, (ActionListener)this));
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ThresholdManager.this.dispose();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Dimension d = new Dimension(this._tab.getSelectedComponent().getPreferredSize());
        d.height += this._tab.getBoundsAt((int)0).height + 8;
        d.width += 8;
        this._tab.setPreferredSize(d);
        this.invalidate();
        this.pack();
    }

    JPanel buildPhysicalPanel() {
        JPanel pane = new JPanel(new BorderLayout());
        JPanel typePanel = new JPanel(new FlowLayout(0, 2, 2));
        this._rmonTypes[2] = new RadioButtonPanel((Object[])_RmonTypes, 2, (ItemListener)this);
        this._rmonTypes[2].setBorder(BorderFactory.createEmptyBorder());
        if (!Discover.isSysVersionGreaterThanEqual((String)"3.0(0)")) {
            this._rmonTypes[2].getComponent(1).setEnabled(false);
            this._rmonTypes[2].setSelected(0);
        } else {
            this._rmonTypes[2].setSelected(1);
        }
        typePanel.add((Component)this._rmonTypes[2]);
        this._physicalTableModel = new KTableModel();
        String[] sPrefix = new String[]{"sys"};
        JScrollPane physicalPane = this.buildScrollPane(_PhysicalMonitor, _PhysicalMonitorValue, this._physicalTableModel, sPrefix);
        this._physicalTable = (KTable)physicalPane.getViewport().getView();
        pane.add("North", typePanel);
        pane.add("Center", physicalPane);
        return pane;
    }

    JPanel buildPortPanel() {
        JPanel portPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel typePanel = new JPanel(new FlowLayout(0, 2, 2));
        this._rmonTypes[0] = new RadioButtonPanel((Object[])_RmonTypes, 2, (ItemListener)this);
        this._rmonTypes[0].setBorder(BorderFactory.createEmptyBorder());
        if (!Discover.isSysVersionGreaterThanEqual((String)"3.0(0)")) {
            this._rmonTypes[0].getComponent(1).setEnabled(false);
            this._rmonTypes[0].setSelected(0);
        } else {
            this._rmonTypes[0].setSelected(1);
        }
        typePanel.add((Component)this._rmonTypes[0]);
        JPanel top = new JPanel(new FlowLayout(0, 2, 2));
        this._portType = new RadioButtonPanel((Object[])_PortTypeLabels, 4, (ItemListener)this);
        this._portType.setBorder(BorderFactory.createEmptyBorder());
        top.add((Component)this._portType);
        int type = 3;
        this._portChooser = new MdsPortChooser(Discover.getDeviceName(), type, false, (IfIndexIf)Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{1, 153, 152}), Discover.getPeer(), 15);
        top.add((Component)this._portChooser);
        this._portType.setSelected(3);
        topPanel.add("North", typePanel);
        topPanel.add("South", top);
        portPanel.add("North", topPanel);
        Box tableBox = new Box(1);
        tableBox.add((Component)new DialogSeparator("Summary"));
        this._portSummaryTableModel = new KTableModel();
        String[] sPrefix = new String[]{"if", "fcIf"};
        JScrollPane summaryPane = this.buildScrollPane(_SummaryMonitor, _MonitorValue, this._portSummaryTableModel, sPrefix);
        this._portSummaryTable = (KTable)summaryPane.getViewport().getView();
        tableBox.add(summaryPane);
        tableBox.add((Component)new DialogSeparator("Error Detail"));
        this._portDetailTableModel = new KTableModel();
        String[] dPrefix = new String[]{"fcIf"};
        JScrollPane detailPane = this.buildScrollPane(_DetailMonitor, null, this._portDetailTableModel, dPrefix);
        Dimension d = detailPane.getPreferredSize();
        d.height = 300;
        detailPane.setPreferredSize(d);
        this._portDetailTable = (KTable)detailPane.getViewport().getView();
        tableBox.add(detailPane);
        portPanel.add("Center", tableBox);
        return portPanel;
    }

    JPanel buildServicePanel() {
        JPanel pane = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel typePanel = new JPanel(new FlowLayout(0, 2, 2));
        this._rmonTypes[1] = new RadioButtonPanel((Object[])_RmonTypes, 2, (ItemListener)this);
        this._rmonTypes[1].setBorder(BorderFactory.createEmptyBorder());
        if (!Discover.isSysVersionGreaterThanEqual((String)"3.0(0)")) {
            this._rmonTypes[1].getComponent(1).setEnabled(false);
            this._rmonTypes[1].setSelected(0);
        } else {
            this._rmonTypes[1].setSelected(1);
        }
        typePanel.add((Component)this._rmonTypes[1]);
        JPanel top = new JPanel(new FlowLayout(0, 2, 2));
        JPanel vsan = new JPanel();
        vsan.setBorder(BorderFactory.createEmptyBorder());
        vsan.add(new JLabel("VSAN Id(s):"));
        this._vsanId = new FieldPanel(30, (JComponent)((Object)new VsanIdCheckboxMenuButton(null, this._peer, 1)));
        vsan.add((Component)this._vsanId);
        top.add(vsan);
        topPanel.add("North", typePanel);
        topPanel.add("South", top);
        pane.add("North", topPanel);
        this._serviceTableModel = new KTableModel();
        JScrollPane servicePane = this.buildScrollPane(_ServicesMonitor, null, this._serviceTableModel, null);
        this._serviceTable = (KTable)servicePane.getViewport().getView();
        pane.add("Center", servicePane);
        return pane;
    }

    JScrollPane buildScrollPane(String[][] monitor, int[] values, KTableModel tableModel, String[] prefix) {
        Array data = this.buildModel(monitor, values, prefix);
        tableModel.setData(data);
        tableModel.setEditable(_Editable);
        tableModel.setHeaders(_Labels);
        KTable table = this.createTable(tableModel);
        table.removeColumn(table.getColumnModel().getColumn(2));
        table.getColumnModel().getColumn(6).setCellEditor(new DefaultCellEditor(this._severity));
        table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(this._startupAlarmType));
        table.getTableHeader().setReorderingAllowed(false);
        EditableCellRenderer ccr = new EditableCellRenderer();
        table.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)ccr));
        table.setDefaultRenderer(Integer.class, (TableCellRenderer)((Object)ccr));
        table.setDefaultRenderer(Severity.class, (TableCellRenderer)((Object)ccr));
        table.setDefaultRenderer(StartupAlarmType.class, (TableCellRenderer)((Object)ccr));
        table.setCellSelectionEnabled(true);
        table.addPopupMenu();
        ccr.setHorizontalAlignment(4);
        JScrollPane pane = new JScrollPane((Component)table);
        Dimension d = table.calcPreferredSize();
        pane.setPreferredSize(d);
        if (d.width > 1008) {
            table.setAutoResizeMode(0);
        }
        return pane;
    }

    Array buildModel(String[][] names, int[] values, String[] prefix) {
        Array data = new Array();
        for (int i = 0; i < names.length; ++i) {
            if (DmId.isN5K(Discover.getSysObjectID()) && names[i][1].equals("fcIfC2Discards")) continue;
            Object[] row = new Object[_Labels.length + 1];
            row[0] = Boolean.FALSE;
            row[1] = names[i][0] == null ? SnmpTableModel.trim((String)names[i][1], (String[])prefix) : names[i][0];
            row[2] = names[i][1];
            int type = names[i][2].charAt(0) - 48;
            row[3] = type == 1 ? "absolute" : "delta";
            int startupAlarmEnum = names[i][2].charAt(1) == 'r' ? 0 : 1;
            row[4] = this._startupAlarmTypes[startupAlarmEnum];
            row[5] = values == null ? new Long(1L) : new Long(values[i]);
            row[6] = new Integer(60);
            row[7] = this._severityLevels[3];
            data.addElement((Object)row);
        }
        return data;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this._isSeverityOk = false;
        }
        this._availableAlarms = new byte[2][];
        super.setVisible(visible);
    }

    @Override
    public void dispose() {
        this._portChooser.dismiss();
        _AlarmIndexOid = null;
        _AlarmOids = null;
        this._portSummaryTableModel.resetChanges(true);
        this._portDetailTableModel.resetChanges(true);
        this._serviceTableModel.resetChanges(true);
        this._physicalTableModel.resetChanges(true);
        super.dispose();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.gc();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = ((AbstractButton)e.getSource()).getText();
        switch (((AbstractButton)e.getSource()).getText().charAt(0)) {
            case 'M': {
                DialogListener.getInstance().dialogAction("RMON_Thresholds");
                return;
            }
            case 'C': {
                int i;
                if (!cmd.equals("Create")) break;
                int type = this._tab.getSelectedIndex();
                if (Discover.isSysVersionGreaterThanEqual((String)"3.0(0)") && this._rmonTypes[type].getSelected() == 1) {
                    _AlarmOids = new int[_AlarmVars_HC.length][];
                    for (i = 0; i < _AlarmOids.length; ++i) {
                        ThresholdManager._AlarmOids[i] = MibNode.get((String)_AlarmVars_HC[i]).getOid();
                    }
                } else {
                    _AlarmOids = new int[_AlarmVars.length][];
                    for (i = 0; i < _AlarmOids.length; ++i) {
                        ThresholdManager._AlarmOids[i] = MibNode.get((String)_AlarmVars[i]).getOid();
                    }
                }
                try {
                    _alarmIndex = this.getNextAlarmIndex();
                    switch (type) {
                        case 0: {
                            int[] index = this.getSelectedIfIndex();
                            if (!this.checkRmon(new KTableModel[]{this._portSummaryTableModel, this._portDetailTableModel}, index)) {
                                return;
                            }
                            String[][] stringArray = _SummaryMonitor = this._rmonTypes[0].getSelected() == 1 ? _SummaryVars_HC : _SummaryVars;
                            if (!this.inputChecking(this._portSummaryTableModel) && !this.inputChecking(this._portDetailTableModel)) {
                                Util.errorMessage((Component)this, (String)"Please do selection.");
                                return;
                            }
                            this.setThresholds(this._portSummaryTable, this._portSummaryTableModel, _SummaryMonitor, index, true);
                            this.setThresholds(this._portDetailTable, this._portDetailTableModel, _DetailMonitor, index, false);
                            break;
                        }
                        case 1: {
                            int[] index = this.getSelectedVSANId();
                            if (!this.checkRmon(new KTableModel[]{this._serviceTableModel}, index)) {
                                return;
                            }
                            if (!this.inputChecking(this._serviceTableModel)) {
                                Util.errorMessage((Component)this, (String)"Please do selection.");
                                return;
                            }
                            this.setThresholds(this._serviceTable, this._serviceTableModel, _ServicesMonitor, index, true);
                            break;
                        }
                        case 2: {
                            int[] index = new int[]{0};
                            if (!this.checkRmon(new KTableModel[]{this._physicalTableModel}, index)) {
                                return;
                            }
                            if (!this.inputChecking(this._physicalTableModel)) {
                                Util.errorMessage((Component)this, (String)"Please do selection.");
                                return;
                            }
                            this.setThresholds(this._physicalTable, this._physicalTableModel, _PhysicalMonitor, index, true);
                        }
                    }
                    this.showCreatedAlarms();
                    Util.infoMessage((Component)this, (String)"Created.", (boolean)false);
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, (Exception)ex);
                }
                catch (Error ex) {
                    Util.errorMessage((Component)this, (String)ex.getMessage());
                }
                return;
            }
        }
        super.setVisible(false);
        this._portChooser.dismiss();
        this._portSummaryTableModel.resetChanges(true);
        this._portDetailTableModel.resetChanges(true);
        this._serviceTableModel.resetChanges(true);
        this._physicalTableModel.resetChanges(true);
    }

    boolean inputChecking(KTableModel tableModel) {
        int size = tableModel.getData().size();
        for (int i = 0; i < size; ++i) {
            Object[] row = (Object[])tableModel.getData().elementAt(i);
            if (!((Boolean)row[0]).booleanValue()) continue;
            return true;
        }
        return false;
    }

    void setThresholds(KTable table, KTableModel tableModel, String[][] monitor, int[] ifIndex, boolean isCheckEvents) throws UnknownHostException, SnmpException, Exception {
        TableCellEditor editor;
        if (table.isEditing() && (editor = table.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        if (tableModel == this._portSummaryTableModel) {
            for (int i = 0; i <= 2; ++i) {
                long value;
                Object[] row = (Object[])tableModel.getData().elementAt(i);
                if (!((Boolean)row[0]).booleanValue() || (value = ((Long)row[5]).longValue()) <= 100L) continue;
                throw new Exception("Can not exceed 100%");
            }
        }
        if (!this._isSeverityOk && isCheckEvents) {
            this.checkEvents();
        }
        int[][] oids = new int[monitor.length][];
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        long[] ifSpeeds = null;
        int size = tableModel.getData().size();
        for (int i = 0; i < size; ++i) {
            SnmpGauge[] thresholdVars_falling;
            SnmpGauge[] thresholdVars_rising;
            SnmpInt threshold_falling;
            SnmpInt threshold_rising;
            boolean isRising;
            Object[] row = (Object[])tableModel.getData().elementAt(i);
            if (!((Boolean)row[0]).booleanValue()) continue;
            if (oids[i] == null) {
                oids[i] = MibNode.get((String)monitor[i][1]).getOid();
            }
            int interval = (Integer)row[6];
            long value = (Long)row[5];
            boolean bl = isRising = ((StartupAlarmType)row[4])._type == 1;
            if (isRising) {
                threshold_rising = new SnmpInt((int)value);
                threshold_falling = new SnmpInt((int)value - 1);
            } else {
                threshold_rising = new SnmpInt((int)value + 1);
                threshold_falling = new SnmpInt((int)value);
            }
            try {
                if (isRising) {
                    thresholdVars_rising = this.getThresholdVars(new BigInteger(String.valueOf(value)));
                    thresholdVars_falling = this.getThresholdVars(new BigInteger(String.valueOf(value - 1L)));
                } else {
                    thresholdVars_rising = this.getThresholdVars(new BigInteger(String.valueOf(value + 1L)));
                    thresholdVars_falling = this.getThresholdVars(new BigInteger(String.valueOf(value)));
                }
            }
            catch (Exception ex) {
                throw new SnmpException("Threshold/Interval " + value + "/" + interval + ex.getMessage());
            }
            SnmpInt eventId = new SnmpInt(((Severity)row[7])._level);
            SnmpInt sampleType = new SnmpInt(monitor[i][2].charAt(0) - 48);
            SnmpInt startupAlarm = new SnmpInt(isRising ? 1 : 2);
            for (int j = 0; j < ifIndex.length; ++j) {
                if (i <= 1 && tableModel == this._portSummaryTableModel) {
                    if (ifSpeeds == null) {
                        ifSpeeds = this.getIfSpeeds(ifIndex);
                    }
                    if (ifSpeeds[j] == 0L) continue;
                    try {
                        if (isRising) {
                            thresholdVars_rising = this.getThreshold4PercentageObj(ifSpeeds[j], value, interval);
                            thresholdVars_falling = this.getThreshold4PercentageObj(ifSpeeds[j], value - 1L, interval);
                        } else {
                            thresholdVars_rising = this.getThreshold4PercentageObj(ifSpeeds[j], value + 1L, interval);
                            thresholdVars_falling = this.getThreshold4PercentageObj(ifSpeeds[j], value, interval);
                        }
                    }
                    catch (Exception ex) {
                        throw new SnmpException("Threshold/Interval " + value + "/" + interval + " " + ex.getMessage());
                    }
                    if (isRising) {
                        threshold_rising = this.getThreshold4PercentageObj_pre3Dot0(ifSpeeds[j], value, interval);
                        threshold_falling = this.getThreshold4PercentageObj_pre3Dot0(ifSpeeds[j], value - 1L, interval);
                    } else {
                        threshold_rising = this.getThreshold4PercentageObj_pre3Dot0(ifSpeeds[j], value + 1L, interval);
                        threshold_falling = this.getThreshold4PercentageObj_pre3Dot0(ifSpeeds[j], value, interval);
                    }
                }
                pdu.reset();
                pdu.setCommand((byte)-93);
                StringBuffer sb = new StringBuffer(monitor[i][1]);
                sb.append('.');
                sb.append(Discover.getRoot().ifIndexToName(ifIndex[j]));
                sb.append('@');
                sb.append(InetAddress.getLocalHost().getHostName());
                SnmpString owner = new SnmpString(sb.toString());
                this.getRMONPDU(pdu, _alarmIndex, oids[i], ifIndex[j], (SnmpVar)sampleType, interval, (SnmpVar)startupAlarm, isRising, (SnmpVar)threshold_rising, (SnmpVar)threshold_falling, (SnmpVar[])thresholdVars_rising, (SnmpVar[])thresholdVars_falling, (SnmpVar)eventId, (SnmpVar)owner);
                this._peer.set(pdu);
                int type = this._rmonTypes[this._tab.getSelectedIndex()].getSelected();
                if (this._availableAlarms[type] == null) {
                    this._availableAlarms[type] = new byte[this.MAXALARM / 8];
                }
                SnmpString.setBit((byte[])this._availableAlarms[type], (int)_alarmIndex);
                pdu.reset();
                pdu.setCommand((byte)-93);
                pdu.addVar(new SnmpOID(_AlarmOids[0], _alarmIndex), (SnmpVar)new SnmpInt(1));
                this._peer.set(pdu);
                _alarmIndex = this.getNextAlarmIndex();
            }
        }
        tableModel.resetChanges(true);
    }

    void resetCheckBoxes(KTableModel model) {
        int size = model.getData().size();
        for (int i = 0; i < size; ++i) {
            Object[] row = (Object[])model.getData().elementAt(i);
            if (!((Boolean)row[0]).booleanValue()) continue;
            row[0] = Boolean.FALSE;
        }
        model.fireTableDataChanged();
    }

    void showCreatedAlarms() {
        DMDialog rmon = DialogListener.getInstance().getDialog("RMON_Thresholds");
        if (rmon != null && rmon.getCurrentPanelTitle().indexOf("Alarms") != -1) {
            rmon.get();
        }
    }

    int getNextAlarmIndex() throws SnmpException {
        int i;
        int type = this._rmonTypes[this._tab.getSelectedIndex()].getSelected();
        if (this._availableAlarms[type] == null) {
            this._availableAlarms[type] = new byte[this.MAXALARM / 8];
            VarBindList vbl = new VarBindList();
            _AlarmIndexOid = Discover.isSysVersionGreaterThanEqual((String)"3.0(0)") && type == 1 ? MibNode.get((String)"cHcAlarmInterval").getOid() : MibNode.get((String)"alarmIndex").getOid();
            vbl.add(new SnmpVarBind(new SnmpOID(_AlarmIndexOid)));
            SnmpPDU resp = SnmpFetch.getBulk((SnmpPeer)this._peer, (VarBindList)vbl);
            vbl = resp.getVariables();
            if (vbl.size() == 0) {
                return 1;
            }
            int i2 = 0;
            int k = 0;
            while (i2 < vbl.size()) {
                SnmpVarBind vb = vbl.get(i2++);
                int[] oid = vb.getOid().getValue();
                SnmpString.setBit((byte[])this._availableAlarms[type], (int)oid[oid.length - 1]);
                ++k;
            }
        }
        for (i = 1; i < this.MAXALARM && SnmpString.getBit((byte[])this._availableAlarms[type], (int)i); ++i) {
        }
        if (i >= this.MAXALARM) {
            throw new SnmpException("No more alarms available.");
        }
        return i;
    }

    private int getRmonVars(KTableModel[] tableModels) {
        int numOfObj = 0;
        for (int i = 0; i < tableModels.length; ++i) {
            int size = tableModels[i].getData().size();
            for (int j = 0; j < size; ++j) {
                Object[] row = (Object[])tableModels[i].getData().elementAt(j);
                if (!((Boolean)row[0]).booleanValue()) continue;
                ++numOfObj;
            }
        }
        return numOfObj;
    }

    protected boolean checkRmon(KTableModel[] tableModels, int[] ifIndex) throws SnmpException {
        if (ifIndex == null) {
            return false;
        }
        _SummaryMonitor = this._rmonTypes[0].getSelected() == 1 ? _SummaryVars_HC : _SummaryVars;
        VarBindList vbl = new VarBindList();
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        vbl.add(MibNode.get((String)"rmonAlarmEnable").getOid(), 0);
        vbl.add(MibNode.get((String)"rmonMaxAlarms").getOid(), 0);
        vbl.add(this._rmonTypes[0].getSelected() == 1 ? this.RmonConfiguredHcAlarmsid : this.RmonConfiguredAlarmsOid, 0);
        SnmpPDU resp = this._peer.send(pdu);
        if (resp.getVariables().intValue(0) != 1 && JOptionPane.showConfirmDialog(this.getParent(), "RMON is disabled. Are you sure you want to continue ?", this.getTitle(), 0) != 0) {
            return false;
        }
        int newAlarm = this.getRmonVars(tableModels) * ifIndex.length;
        int totalAlarm = newAlarm + resp.getVariables().intValue(2);
        if (totalAlarm > resp.getVariables().intValue(1)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Creating another ");
            sb.append(newAlarm);
            sb.append(' ');
            sb.append(_RmonTypes[this._rmonTypes[0].getSelected()]);
            sb.append(" alarms will exceed ");
            sb.append(resp.getVariables().intValue(1));
            sb.append(" max alarms");
            Util.errorMessage((Component)this.getParent(), (String)sb.toString());
            return false;
        }
        return true;
    }

    void checkEvents() throws SnmpException, UnknownHostException {
        int[] eventDescription = MibNode.get((String)"eventDescription").getOid();
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        for (int i = 0; i < this._severityLevels.length; ++i) {
            pdu.addNull(new SnmpOID(eventDescription, this._severityLevels[i]._level));
        }
        SnmpPDU resp = this._peer.send(pdu);
        Array missingLevels = new Array();
        for (int i = 0; i < this._severityLevels.length; ++i) {
            SnmpVarBind vb = resp.getVariables().get(i);
            if (vb.getVar().getType() == 4) continue;
            missingLevels.addElement((Object)vb.getOid().getValue());
        }
        if (missingLevels.size() > 0 && JOptionPane.showConfirmDialog(this.getParent(), "The Alarm Severity Events (1..5) are missing or incomplete.\nAlarm notifications cannot be sent without them.\n\nWould you like to create them?", this.getTitle(), 0) == 0) {
            this.createEvents(eventDescription, missingLevels);
        }
    }

    void createEvents(int[] eventDescription, Array missingLevels) throws SnmpException, UnknownHostException {
        int index;
        int[] oid;
        int i;
        int[] eventStatus = MibNode.get((String)"eventStatus").getOid();
        int[] eventType = MibNode.get((String)"eventType").getOid();
        int[] eventOwner = MibNode.get((String)"eventOwner").getOid();
        SnmpString owner = new SnmpString(InetAddress.getLocalHost().getHostName());
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(this._severityLevels.length * 4));
        for (i = 0; i < missingLevels.size(); ++i) {
            oid = (int[])missingLevels.elementAt(i);
            index = oid[oid.length - 1];
            pdu.addVar(new SnmpOID(eventStatus, index), (SnmpVar)new SnmpInt(2));
            pdu.addVar(new SnmpOID(eventDescription, index), (SnmpVar)new SnmpString(this._severityLevels[i]._descr));
            pdu.addVar(new SnmpOID(eventOwner, index), (SnmpVar)owner);
            pdu.addVar(new SnmpOID(eventType, index), (SnmpVar)new SnmpInt(4));
            this._peer.set(pdu);
            pdu.reset();
            pdu.setCommand((byte)-93);
        }
        pdu.reset();
        pdu.setCommand((byte)-93);
        for (i = 0; i < missingLevels.size(); ++i) {
            oid = (int[])missingLevels.elementAt(i);
            index = oid[oid.length - 1];
            pdu.addVar(new SnmpOID(eventStatus, index), (SnmpVar)new SnmpInt(1));
        }
        this._peer.set(pdu);
        this._isSeverityOk = true;
    }

    int[] getSelectedIfIndex() throws Exception {
        switch (this._portType.getSelected()) {
            case 0: 
            case 1: 
            case 2: {
                int i;
                int selType = this._portType.getSelected();
                PhysicalView view = DeviceManager.getInstance().getView();
                Array elements = view.getElements();
                Array portList = new Array();
                for (i = 0; i < elements.size(); ++i) {
                    PhysicalElement e = (PhysicalElement)elements.elementAt(i);
                    if (!(e instanceof Port)) continue;
                    Port p = (Port)e;
                    if (selType == 1 && (p._isEPort || p._isTEPort)) {
                        portList.addElement((Object)e);
                        continue;
                    }
                    if (selType == 2 && p._isFPort) {
                        portList.addElement((Object)e);
                        continue;
                    }
                    if (selType != 0) continue;
                    portList.addElement((Object)e);
                }
                if (portList.size() == 0) {
                    throw new Exception("No interfaces match your request");
                }
                int[] ids = new int[portList.size()];
                for (i = 0; i < ids.length; ++i) {
                    ids[i] = ((PhysicalElement)portList.elementAt(i)).getIndex()[0];
                }
                return ids;
            }
            case 3: {
                String selected = this._portChooser.getText();
                Discover.getInstance();
                int[] ids = SnmpIntList.parse((String)selected, (IfIndexIf)Discover.getRoot());
                if (ids.length == 0) {
                    throw new Exception("Please enter selected interfaces");
                }
                return ids;
            }
        }
        return null;
    }

    int[] getSelectedVSANId() throws Exception {
        String selected = this._vsanId.getText();
        StringTokenizer st = new StringTokenizer(selected, ",");
        int[] ids = new int[st.countTokens()];
        if (ids.length == 0) {
            throw new Exception("Please enter selected VSAN");
        }
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Integer.parseInt(st.nextToken().trim());
        }
        return ids;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (e.getSource() instanceof JToggleButton && this._portChooser != null && ((JToggleButton)e.getSource()).getParent() == this._portType) {
            String type = ((JToggleButton)e.getSource()).getText();
            this._portChooser.setEnabled(type.startsWith("Sel"));
        }
    }

    long[] getIfSpeeds(int[] ifIndex) throws SnmpException {
        StringBuffer sbWarning = new StringBuffer();
        VarBindList vbl = new VarBindList(ifIndex.length);
        int[] ifHighSpeed = MibNode.get((String)"ifHighSpeed").getOid();
        int[] ifOperStatus = MibNode.get((String)"ifOperStatus").getOid();
        long[] speed = new long[ifIndex.length];
        for (int i = 0; i < ifIndex.length; ++i) {
            vbl.add(new SnmpVarBind(new SnmpOID(ifHighSpeed, ifIndex[i])));
        }
        SnmpPDU resp = SnmpFetch.get((SnmpPeer)this._peer, (VarBindList)vbl);
        vbl = resp.getVariables();
        int max = vbl.size();
        for (int i = 0; i < max; ++i) {
            SnmpVar v = vbl.get(i).getVar();
            if (v.getType() == 5) {
                throw new SnmpException(Discover.getRoot().ifIndexToName(ifIndex[i]) + " invalid");
            }
            int highSpeed = (int)((SnmpGauge)v).getValue();
            speed[i] = (long)highSpeed * 100000L;
            if (speed[i] == 0L && IfIndexUtil.getType((int)ifIndex[i]) == 30) {
                VarBindList operVbl = new VarBindList(ifIndex.length);
                operVbl.add(new SnmpVarBind(new SnmpOID(ifOperStatus, ifIndex[i])));
                SnmpPDU operResp = SnmpFetch.get((SnmpPeer)this._peer, (VarBindList)operVbl);
                VarBindList respVbl = operResp.getVariables();
                SnmpVar var = respVbl.get(i).getVar();
                if (var.getType() == 5) {
                    throw new SnmpException(Discover.getRoot().ifIndexToName(ifIndex[i]) + " invalid");
                }
                int operStatus = ((SnmpInt)var).getValue();
                if (operStatus == 1) {
                    speed[i] = 100000L;
                }
            }
            if (speed[i] != 0L) continue;
            if (sbWarning.length() == 0) {
                sbWarning.append("The following interface speeds are unknown: ");
            } else {
                sbWarning.append(", ");
            }
            sbWarning.append(Discover.getRoot().ifIndexToName(ifIndex[i]));
        }
        if (sbWarning.length() > 0) {
            sbWarning.append("\nPlease bring the interfaces up so percentage utilization alarms can be calculated and configured.");
            throw new SnmpException(sbWarning.toString());
        }
        return speed;
    }

    private SnmpInt getThreshold4PercentageObj_pre3Dot0(long speed, long value, int interval) throws Exception {
        long val = speed * value / 100L;
        return new SnmpInt((int)(val *= (long)interval));
    }

    private SnmpGauge[] getThreshold4PercentageObj(long speed, long value, int interval) throws Exception {
        long val = speed * value / 100L;
        BigInteger valB = new BigInteger(String.valueOf(val));
        valB = valB.multiply(new BigInteger(String.valueOf(interval)));
        return this.getThresholdVars(valB);
    }

    private SnmpGauge[] getThresholdVars(BigInteger val) throws Exception {
        SnmpGauge[] thresholdVars = new SnmpGauge[2];
        byte[] valByte = val.toByteArray();
        if (valByte.length > 8) {
            throw new Exception("number too big, not supported");
        }
        long[] long32 = this.byteTo32LongArray(valByte);
        thresholdVars[1] = long32.length > 1 ? new SnmpGauge(long32[1]) : new SnmpGauge(0L);
        thresholdVars[0] = new SnmpGauge(long32[0]);
        return thresholdVars;
    }

    private long[] byteTo32LongArray(byte[] b) {
        long[] long32 = new long[b.length / 4 + 1];
        int i = b.length - 1;
        int j = 0;
        while (i >= 0) {
            int n = j / 4;
            long32[n] = long32[n] | ((long)b[i] & 0xFFL) << 8 * (j % 4);
            --i;
            ++j;
        }
        return long32;
    }

    private void getRMONPDU(SnmpPDU pdu, int alarmIndex, int[] oid, int ifIndex, SnmpVar sampleType, int interval, SnmpVar startupAlarm, boolean isRising, SnmpVar threshold_rising, SnmpVar threshold_falling, SnmpVar[] thresholdVars_rising, SnmpVar[] thresholdVars_falling, SnmpVar eventId, SnmpVar owner) {
        pdu.addVar(new SnmpOID(_AlarmOids[0], _alarmIndex), (SnmpVar)new SnmpInt(2));
        pdu.addVar(new SnmpOID(_AlarmOids[2], alarmIndex), (SnmpVar)new SnmpOID(oid, ifIndex));
        pdu.addVar(new SnmpOID(_AlarmOids[3], alarmIndex), sampleType);
        pdu.addVar(new SnmpOID(_AlarmOids[1], alarmIndex), (SnmpVar)new SnmpInt(interval));
        pdu.addVar(new SnmpOID(_AlarmOids[4], alarmIndex), startupAlarm);
        if (Discover.isSysVersionGreaterThanEqual((String)"3.0(0)") && this._rmonTypes[this._tab.getSelectedIndex()].getSelected() == 1) {
            if (((SnmpGauge)thresholdVars_rising[1]).getValue() != 0L) {
                pdu.addVar(new SnmpOID(cHcAlarmRisingThreshAbsValueHiOid, alarmIndex), thresholdVars_rising[1]);
            }
            pdu.addVar(new SnmpOID(_AlarmOids[5], alarmIndex), thresholdVars_rising[0]);
            pdu.addVar(new SnmpOID(cHcAlarmRisingThresholdValStatusOid, alarmIndex), (SnmpVar)new SnmpInt(2));
            if (((SnmpGauge)thresholdVars_falling[1]).getValue() != 0L) {
                pdu.addVar(new SnmpOID(cHcAlarmFallingThreshAbsValueHiOid, alarmIndex), thresholdVars_falling[1]);
            }
            pdu.addVar(new SnmpOID(_AlarmOids[7], alarmIndex), thresholdVars_falling[0]);
            pdu.addVar(new SnmpOID(cHcAlarmFallingThrsholdValStatusOid, alarmIndex), (SnmpVar)new SnmpInt(2));
        } else {
            pdu.addVar(new SnmpOID(_AlarmOids[5], alarmIndex), threshold_rising);
            pdu.addVar(new SnmpOID(_AlarmOids[7], alarmIndex), threshold_falling);
        }
        pdu.addVar(new SnmpOID(_AlarmOids[6], alarmIndex), eventId);
        pdu.addVar(new SnmpOID(_AlarmOids[8], alarmIndex), eventId);
        pdu.addVar(new SnmpOID(_AlarmOids[9], alarmIndex), owner);
    }

    KTable createTable(KTableModel model) {
        return new ThresholdMgrTable(model);
    }

    static {
        _AlarmVars = new String[]{"alarmStatus", "alarmInterval", "alarmVariable", "alarmSampleType", "alarmStartupAlarm", "alarmRisingThreshold", "alarmRisingEventIndex", "alarmFallingThreshold", "alarmFallingEventIndex", "alarmOwner"};
        _AlarmVars_HC = new String[]{"cHcAlarmStatus", "cHcAlarmInterval", "cHcAlarmVariable", "cHcAlarmSampleType", "cHcAlarmStartupAlarm", "cHcAlarmRisingThreshAbsValueLo", "cHcAlarmRisingEventIndex", "cHcAlarmFallingThreshAbsValueLo", "cHcAlarmFallingEventIndex", "cHcAlarmOwner"};
        cHcAlarmRisingThreshAbsValueHiOid = MibNode.get((String)"cHcAlarmRisingThreshAbsValueHi").getOid();
        cHcAlarmFallingThreshAbsValueHiOid = MibNode.get((String)"cHcAlarmFallingThreshAbsValueHi").getOid();
        cHcAlarmRisingThresholdValStatusOid = MibNode.get((String)"cHcAlarmRisingThresholdValStatus").getOid();
        cHcAlarmFallingThrsholdValStatusOid = MibNode.get((String)"cHcAlarmFallingThrsholdValStatus").getOid();
        _PhysicalMonitor = new String[][]{{null, "cseSysCPUUtilization", "1r"}, {null, "cseSysMemoryUtilization", "1r"}};
        _SummaryVars = new String[][]{{"Rx Utilization%", "ifInOctets", "2r"}, {"Tx Utilization%", "ifOutOctets", "2r"}, {null, "ifInErrors", "2r"}, {null, "ifOutErrors", "2r"}, {"Class2 Discards", "fcIfC2Discards", "2r"}, {"Class3 Discards", "fcIfC3Discards", "2r"}, {"ClassF Discards", "fcIfCfDiscards", "2r"}};
        _SummaryVars_HC = new String[][]{{"Rx Utilization%", "ifHCInOctets", "2r"}, {"Tx Utilization%", "ifHCOutOctets", "2r"}, {null, "ifInErrors", "2r"}, {null, "ifOutErrors", "2r"}, {"Class2 Discards", "fcIfC2Discards", "2r"}, {"Class3 Discards", "fcIfC3Discards", "2r"}, {"ClassF Discards", "fcIfCfDiscards", "2r"}};
        _DetailMonitor = new String[][]{{null, "fcIfLinkFailures", "2r"}, {null, "fcIfSyncLosses", "2r"}, {null, "fcIfSigLosses", "2r"}, {null, "fcIfInvalidTxWords", "2r"}, {null, "fcIfInvalidCrcs", "2r"}, {null, "fcIfDelimiterErrors", "2r"}, {null, "fcIfAddressIdErrors", "2r"}, {null, "fcIfLinkResetIns", "2r"}, {null, "fcIfLinkResetOuts", "2r"}, {null, "fcIfOlsIns", "2r"}, {null, "fcIfOlsOuts", "2r"}, {null, "fcIfRuntFramesIn", "2r"}, {null, "fcIfJabberFramesIn", "2r"}, {null, "fcIfTxWaitCount", "2r"}, {null, "fcIfFramesTooLong", "2r"}, {null, "fcIfFramesTooShort", "2r"}, {null, "fcIfLRRIn", "2r"}, {null, "fcIfLRROut", "2r"}, {null, "fcIfNOSIn", "2r"}, {null, "fcIfNOSOut", "2r"}, {null, "fcIfFragFrames", "2r"}, {null, "fcIfEOFaFrames", "2r"}, {null, "fcIfUnknownClassFrames", "2r"}, {null, "fcIfFramesDiscard", "2r"}, {null, "fcIfELPFailures", "2r"}, {null, "fcIfTimeOutDiscards", "2r"}, {null, "fcIfOutDiscards", "2r"}, {null, "fcIfCreditLoss", "2r"}, {null, "fcIfTxWtAvgBBCreditTransitionToZero", "2r"}};
        _ServicesMonitor = new String[][]{{"NameServer Rejects", "fcNameServerRejects", "1r"}, {"RSCN Rejects", "rscnRscnReqRej", "1r"}, {"FSPF Errors", "fspfChecksumErrors", "1r"}, {"DM Fabric Builds", "dmBuildFabrics", "1r"}, {"DM Fabric Reconfigures", "dmFabricReconfigures", "1r"}, {"DM Free FcIds", "dmFreeFcIds", "1f"}};
        _MonitorValue = new int[]{90, 90, 1, 1, 1, 1, 1};
        _PhysicalMonitorValue = new int[]{90, 90};
        _Labels = new String[]{"Select", "Variable", null, "Type", "Compare", "Value", "Sample (sec)", "Severity"};
        _Editable = new boolean[]{true, false, false, false, true, true, true, true};
        _PortTypeLabels = new String[]{"All", "xE", "Fx", "Selected:"};
        _RmonTypes = new String[]{"32bit", "64bit"};
    }

    class ThresholdMgrTable
    extends KTable
    implements ActionListener {
        KTableModel _model;
        String[][] _menuItems;

        public ThresholdMgrTable(KTableModel model) {
            super((TableModel)model);
            this._menuItems = new String[][]{{"Select All", "A"}, {"Select None", "N"}};
            this._model = model;
        }

        protected void buildPopupMenu() {
            this._popup = new JPopupMenu();
            for (int i = 0; i < this._menuItems.length; ++i) {
                this._popup.add(Util.createMenuItem((String)this._menuItems[i][0], (String)this._menuItems[i][1], (ActionListener)this));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().charAt(0) == 'A' || e.getActionCommand().charAt(0) == 'N') {
                boolean none = e.getActionCommand().charAt(0) == 'N';
                this.setSelectionAll(none ? Boolean.FALSE : Boolean.TRUE);
            } else {
                super.actionPerformed(e);
            }
        }

        void setSelectionAll(Object value) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(value, i, 0);
            }
        }
    }

    class StartupAlarmType {
        int _type;
        String _descr;

        public StartupAlarmType(int type, String descr) {
            this._type = type;
            this._descr = descr;
        }

        public String toString() {
            return this._descr;
        }
    }

    class Severity {
        int _level;
        String _descr;

        public Severity(int level, String descr) {
            this._level = level;
            this._descr = descr;
        }

        public String toString() {
            return this._descr;
        }
    }

    class EditableCellRenderer
    extends ChangedCellRenderer {
        EditableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setFont(table.getFont());
            return c;
        }
    }
}

