/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.Panel;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.mds.renderers.PortIndexRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EditIfPortForm
extends EditForm
implements ActionListener {
    static final int VSANID = 1;
    static final int PORTVSAN = 2;
    static final int AMDINDOWN = 2;
    int OPERATIONALVSAN = 3;
    int ADMIN = 4;
    int OPER = 5;
    private static final int TE_MODE = 12;
    private static final int TF_MODE = 17;
    private static final int TNP_MODE = 18;
    private static final int LINKFAILURE = 7;
    static int[] _active2kOid = MibNode.get((String)"fcIfActiveVsanList2k").getOid();
    static int[] _up2kOid = MibNode.get((String)"fcIfActiveVsanUpList2k").getOid();
    static int[] _active4kOid = MibNode.get((String)"fcIfActiveVsanList4k").getOid();
    static int[] _up4kOid = MibNode.get((String)"fcIfActiveVsanUpList4k").getOid();
    public static final int[] _allowed2kOid = MibNode.get((String)"fcIfAllowedVsanList2k").getOid();
    static final int[] _allowed4kOid = MibNode.get((String)"fcIfAllowedVsanList4k").getOid();
    static final int[] _fcIfPortRateModeOid = MibNode.get((String)"fcIfPortRateMode").getOid();
    static final int[] _fcIfAdminModeOid = MibNode.get((String)"fcIfAdminMode").getOid();
    static final int[] _fcIfAdminSpeedOid = MibNode.get((String)"fcIfAdminSpeed").getOid();
    static final int[] _cieIfSpeedGroupConfigOid = MibNode.get((String)"cieIfSpeedGroupConfig").getOid();
    static final MibEnum[] ifAdminStatusEnums = MibNode.get((String)"ifAdminStatus").getEnums();
    static final int DEDICATED = 1;
    static final int SHARED = 2;
    static final int SPEED_AUTOMAX2G = 5;
    static final int SPEED_8G = 6;
    static final int SPEED_AUTOMAX4G = 7;
    static final int SPEED_10G = 8;
    int _fcIfAdminTrunkMode;
    int _adminSpeed;
    int _operSpeed;
    int _failureCause;
    int _initLinkState;
    int _serviceState;
    int _adminStatus;
    int _operStatus;
    int _cieIfSpeedGroupConfig;
    JLabel _vsanTEPortLabel;
    FieldPanel _vsanIdPanel;
    protected static boolean _isNDVersion = Discover.getSysVersionInterim().equals("1.0");
    protected boolean is1_3_3_above = Discover.getSysVersionWithMinor().compareTo("1.3(4)") >= 0;
    boolean _isLinkFailure;

    public EditIfPortForm(String[] vars) {
        super(vars);
        this._fcIfAdminTrunkMode = this.getVarIndex("fcIfAdminTrunkMode");
        this._adminSpeed = this.getVarIndex("fcIfAdminSpeed");
        this._operSpeed = this.getVarIndex("ifHighSpeed");
        this._failureCause = this.getVarIndex("fcIfOperStatusCause");
        this._initLinkState = this.getVarIndex("fcIfPortInitStatus");
        this._serviceState = this.getVarIndex("fcIfServiceState");
        this._adminStatus = this.getVarIndex("ifAdminStatus");
        this._operStatus = this.getVarIndex("ifOperStatus");
        this._cieIfSpeedGroupConfig = this.getVarIndex("cieIfSpeedGroupConfig");
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            VsanIdMenuButton vsanId = new VsanIdMenuButton(null, this.getPeer(), (IfIndexIf)Discover.getRoot());
            vsanId.setParent((Panel)this);
            this._vsanTEPortLabel = new JLabel(" (See Up VSANs in Trunk Config)");
            this._vsanTEPortLabel.setFont(ChangedCellRenderer.getNormalFont());
            this._vsanIdPanel = new FieldPanel(5, (JComponent)vsanId);
            this._vsanIdPanel.getField().addKeyListener((KeyListener)new DMPanel.ChangedFieldListener((DMPanel)this));
            this._vsanIdPanel.setRange(1, 4094);
            JPanel vsanPanel = new JPanel(new BorderLayout());
            vsanPanel.add((Component)this._vsanTEPortLabel, "East");
            vsanPanel.add((Component)this._vsanIdPanel, "West");
            return vsanPanel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected void build() {
        super.build();
        if (!this.isMultiple() && Discover.isSysVersionGreaterThanEqual((String)"3.0(0)")) {
            for (int i = 0; i < ((RadioButtonPanel)this._values[this._adminStatus]).getComponentCount(); ++i) {
                ToggleListenerAdminMode adminListener = new ToggleListenerAdminMode();
                JRadioButton btn = (JRadioButton)((RadioButtonPanel)this._values[this._adminStatus]).getButton(i);
                btn.addActionListener(adminListener);
            }
        }
    }

    protected int getEnumGrid(int index) {
        if (index == this._adminSpeed) {
            return 5;
        }
        return super.getEnumGrid(index);
    }

    protected MibEnum[] getApplicableEnums(MibNode mibNode) {
        MibEnum[] enums = mibNode.getEnums();
        if (DmId.isN5K(Discover.getSysObjectID()) && MibNode.equals((int[])_fcIfAdminModeOid, (int[])mibNode.getOid()) == 0) {
            ArrayList<MibEnum> al = new ArrayList<MibEnum>();
            for (int i = 0; i < enums.length; ++i) {
                String label = enums[i].getLabel();
                if (DmSystem.getIsNPVMode() ? !label.equals("NP") && !label.equals("F") && !label.equals("SD") : label.equals("FX") || label.equals("FV") || label.equals("ST") || label.equals("FL") || label.equals("TL") || label.equals("NP")) continue;
                al.add(enums[i]);
            }
            enums = al.toArray(new MibEnum[0]);
        }
        return enums;
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1) {
            this._vsanIdPanel.getField().setText(this._vsanIdPanel.getText().trim());
            return new SnmpInt(this._vsanIdPanel.getInt());
        }
        return super.getComponentValue(index);
    }

    protected void showError(int index, boolean isError) {
        if (index == this.OPERATIONALVSAN - 1) {
            JLabel l = (JLabel)this._values[index];
            l.setText("");
            return;
        }
        super.showError(index, isError);
    }

    protected void setComponentValue(int i, SnmpVar v) {
        if (i == 1) {
            this._vsanIdPanel.setText(v.toString());
        } else {
            if (i == this.OPER) {
                this._vsanTEPortLabel.setVisible(((SnmpInt)v).getValue() == 12 || ((SnmpInt)v).getValue() == 17 || ((SnmpInt)v).getValue() == 18);
            }
            super.setComponentValue(i, v);
            if (this.is1_3_3_above) {
                if (i == this._failureCause) {
                    this._isLinkFailure = ((SnmpInt)v).getValue() == 7;
                } else if (i == this._initLinkState) {
                    this._labels[this._initLinkState].setEnabled(this._isLinkFailure);
                    this._values[this._initLinkState].setEnabled(this._isLinkFailure);
                }
            }
            if (Discover.isSysVersionGreaterThanEqual((String)"3.0(0)") && i == this._adminStatus) {
                int val = ((SnmpInt)v).getValue();
                RadioButtonPanel rbp = (RadioButtonPanel)this._values[this._adminStatus];
                for (int j = 0; j < this._mibNodes[this._adminStatus].getEnums().length; ++j) {
                    if (val != this._mibNodes[this._adminStatus].getEnums()[j].getValue()) continue;
                    if (j >= rbp.getComponentCount()) break;
                    JToggleButton rb = rbp.getButton(j);
                    rb.doClick();
                    break;
                }
            }
        }
    }

    protected boolean isChanged(int index) {
        if (index == 1) {
            return this._vsanIdPanel.getField().getFont() == ChangedCellRenderer.getChangeFont();
        }
        return super.isChanged(index);
    }

    protected void resetChanges() {
        super.resetChanges();
        if (this._vsanIdPanel != null) {
            this._vsanIdPanel.setFont(null);
        }
    }

    protected void buildTable() {
        super.buildTable();
        this._table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new PortIndexRenderer(this.getPeer()));
        if (this._mibNodes != null) {
            for (int i = 0; i < this._mibNodes.length; ++i) {
                TableColumn col;
                TableCellEditor cellEditor;
                if (this._mibNodes[i] == null || !Arrays.equals(this._mibNodes[i].getOid(), _fcIfAdminSpeedOid) || !((cellEditor = (col = this._table.getColumnModel().getColumn(i)).getCellEditor()) instanceof SnmpKTable.BoldEditor)) continue;
                ((SnmpKTable.BoldEditor)cellEditor).putClientProperty((Object)SnmpKTable.REFRESH, (Object)new AdminComboRefresher());
            }
        }
    }

    public static SnmpPDU addVsan4kVar(SnmpPDU pdu, int[] index, int active2kPos) {
        pdu.removeVarAt(active2kPos);
        pdu.getVariables().add(active2kPos, new SnmpVarBind(new SnmpOID(_isNDVersion ? _active2kOid : _up2kOid, index)));
        pdu.addNull(new SnmpOID(_allowed4kOid, index));
        pdu.addNull(new SnmpOID(_isNDVersion ? _active4kOid : _up4kOid, index));
        return pdu;
    }

    public static SnmpPDU appendVsan4kTo2kVar(SnmpPDU pdu, int type, int allow2k, int allow4k, int active2k, int active4k, boolean removeFromPDU) {
        VarBindList vbl = pdu.getVariables();
        SnmpVar v2k = vbl.get(allow2k).getVar();
        if (v2k.getType() != 5) {
            try {
                SnmpString allowed = (SnmpString)v2k;
                SnmpString allowed4kV = (SnmpString)vbl.get(allow4k).getVar();
                allowed = PortInterfaceUtil.getInstance((int)type).getVsan(allowed, allowed4kV, type == 1);
                if (active2k != -1) {
                    SnmpString active = (SnmpString)vbl.get(active2k).getVar();
                    SnmpString active4kV = (SnmpString)vbl.get(active4k).getVar();
                    active = PortInterfaceUtil.getInstance((int)type).getVsan(active, active4kV, false);
                }
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
        }
        if (removeFromPDU && active4k != -1) {
            vbl.removeRange(active4k, active4k + 1);
        }
        if (removeFromPDU && allow4k != -1) {
            vbl.removeRange(allow4k, allow4k + 1);
        }
        return pdu;
    }

    public static SnmpPDU splitVar2k4k(SnmpPDU pdu, int type) {
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            PortInterfaceUtil.getInstance((int)type).addVsan4k2Pdu(pdu, vb.getOid(), vb.getVar(), oid[oid.length - 1]);
        }
        return pdu;
    }

    protected void updateForm(SnmpPDU pdu) {
        super.updateForm(pdu);
        try {
            this.setEnabled(this._serviceState, ((SnmpInt)this.getComponentValue(this._adminStatus)).getValue() == 2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!this.isMultiple() && this._cieIfSpeedGroupConfig != -1 && this._cieIfSpeedGroupConfig < this._values.length && this._cieIfSpeedGroupConfig < this._labels.length) {
            int slot = IfIndexUtil.getIfIndexCard((int)this.getIndex()[0]);
            int type = DmSystem.getCardTypes()[slot - 1];
            boolean isVisible = FRUConstants.isSupportSpeedGroup((int)type);
            this._values[this._cieIfSpeedGroupConfig].setVisible(isVisible);
            this._labels[this._cieIfSpeedGroupConfig].setVisible(isVisible);
        }
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        Object rateModeIndex = null;
        Array pduList = new Array();
        int count = 0;
        int varBindPos = 0;
        int rateModePos = -1;
        int i = 0;
        while (i < pdu.getVariables().size()) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            SnmpOID oid = vb.getOid();
            int rangeLow = 3;
            int rangeHigh = 4;
            if (oid.startsWith(_fcIfPortRateModeOid)) {
                if (count >= rangeLow && count <= rangeHigh) {
                    int len = count - 2;
                    if (rateModePos >= len) {
                        len = rateModePos + 1;
                    }
                    VarBindList vbl = new VarBindList(len);
                    for (int j = varBindPos; j < varBindPos + len; ++j) {
                        vbl.add(pdu.getVariables().get(j));
                    }
                    pduList.addElement((Object)new SnmpPDU(-93, vbl));
                    rateModePos = 0;
                    count = 0;
                    i = varBindPos += vbl.size();
                    continue;
                }
                rateModePos = count;
            }
            ++count;
            ++i;
        }
        if (pduList.size() > 0) {
            if (pdu.getVariables().size() >= varBindPos) {
                int len = pdu.getVariables().size() - varBindPos;
                VarBindList vbl = new VarBindList(len);
                for (int j = varBindPos; j < varBindPos + len; ++j) {
                    vbl.add(pdu.getVariables().get(j));
                }
                pduList.addElement((Object)new SnmpPDU(-93, vbl));
            }
            for (i = 0; i < pduList.size(); ++i) {
                super.sendPdu((SnmpPDU)pduList.elementAt(i));
            }
        } else {
            super.sendPdu(pdu);
        }
    }

    protected boolean isWarnVar(String mibVar, Object value, String[] warningVars, Object position) {
        boolean isWarnVar = super.isWarnVar(mibVar, value, warningVars, position);
        if (isWarnVar && mibVar.equals("fcIfServiceState")) {
            return !(value instanceof SnmpInt) || ((SnmpInt)value).getValue() != 1;
        }
        if (isWarnVar && mibVar.equals("fcIfPortRateMode")) {
            return value instanceof MibEnum && ((MibEnum)value).getValue() == 1;
        }
        return isWarnVar;
    }

    protected DmTableModel buildTableModel() {
        return new SnmpIfPortTableModel();
    }

    class AdminComboRefresher
    implements SnmpKTable.Refresher {
        private DefaultComboBoxModel defaultModel;
        private DefaultComboBoxModel non8GModel;
        private DefaultComboBoxModel nonAutoMaxAndNon8GModel;
        private DefaultComboBoxModel nonAutoMaxWith8GModel;

        AdminComboRefresher() {
        }

        public void refresh(Object o, JTable table, int row, int column) {
            if (o instanceof JComboBox) {
                JComboBox adminModeCombo = (JComboBox)o;
                if (this.defaultModel == null) {
                    this.populateComboBoxModels(adminModeCombo);
                }
                DefaultComboBoxModel model = this.getComboBoxModel(table, row, column);
                adminModeCombo.setModel(model);
            }
        }

        private void populateComboBoxModels(JComboBox comboBox) {
            this.defaultModel = (DefaultComboBoxModel)comboBox.getModel();
            int count = this.defaultModel.getSize();
            ArrayList<MibEnum> speedEnumsForNon8G = new ArrayList<MibEnum>();
            ArrayList<MibEnum> speedEnumsForNonAutoMaxAndNon8G = new ArrayList<MibEnum>();
            ArrayList<MibEnum> speedEnumsForNonAutoMaxWith8G = new ArrayList<MibEnum>();
            for (int i = 0; i < count; ++i) {
                MibEnum mibEnum = (MibEnum)this.defaultModel.getElementAt(i);
                int speed = mibEnum.getValue();
                if (speed != 6 && speed != 7) {
                    speedEnumsForNon8G.add(mibEnum);
                    if (speed == 5) continue;
                    speedEnumsForNonAutoMaxAndNon8G.add(mibEnum);
                    speedEnumsForNonAutoMaxWith8G.add(mibEnum);
                    continue;
                }
                if (speed != 6) continue;
                speedEnumsForNonAutoMaxWith8G.add(mibEnum);
            }
            this.non8GModel = new DefaultComboBoxModel<MibEnum>(speedEnumsForNon8G.toArray(new MibEnum[0]));
            this.nonAutoMaxAndNon8GModel = new DefaultComboBoxModel<MibEnum>(speedEnumsForNonAutoMaxAndNon8G.toArray(new MibEnum[0]));
            this.nonAutoMaxWith8GModel = new DefaultComboBoxModel<MibEnum>(speedEnumsForNonAutoMaxWith8G.toArray(new MibEnum[0]));
        }

        private DefaultComboBoxModel getComboBoxModel(JTable table, int row, int col) {
            Object o = table.getModel().getValueAt(row, 0);
            if (o instanceof SnmpOID) {
                int ifIndex = ((SnmpOID)o).getValue()[0];
                int slot = IfIndexUtil.getIfIndexCard((int)ifIndex);
                int type = DmSystem.getCardTypes()[slot - 1];
                if (type == 42 || type == 43 || type == 46 || type == 51 || type == 49 || type == 53 || type == 54 || type == 61 || type == 68) {
                    return this.defaultModel;
                }
                if (type == 10000001 || type == 10000002 || type == 30000002 || type == 30000003) {
                    return this.nonAutoMaxAndNon8GModel;
                }
                if (type == 0x989689 || type == 10000018 || type == 10000013 || type == 10000012 || type == 10000017 || type == 10000019 || type == 30000006 || type == 51 || type == 49) {
                    return this.nonAutoMaxWith8GModel;
                }
            }
            return this.non8GModel;
        }
    }

    class SnmpIfPortTableModel
    extends DmTableModel {
        SnmpIfPortTableModel() {
        }

        public boolean isCellActive(int row, int col) {
            Object o;
            if (col == 2) {
                Object o2 = this.getValueAt(row, EditIfPortForm.this.OPER);
                return o2 == null || !o2.toString().equals("TE") && !o2.toString().equals("TF") && !o2.toString().equals("TNP");
            }
            if (EditIfPortForm.this.is1_3_3_above && col == EditIfPortForm.this._initLinkState - 2) {
                Object o3 = this.getValueAt(row, EditIfPortForm.this._failureCause - 2);
                return o3 != null && o3.toString().equals("linkFailure");
            }
            if (Discover.isSysVersionGreaterThanEqual((String)"3.0(0)") && col == EditIfPortForm.this._serviceState - 2) {
                Object adminStatus = this.getValueAt(row, EditIfPortForm.this._adminStatus - 2);
                return adminStatus != null && ((JnmMibEnum)adminStatus).getLabel().startsWith("down");
            }
            if (EditIfPortForm.this._cieIfSpeedGroupConfig != -1 && col == EditIfPortForm.this._cieIfSpeedGroupConfig - 1 && (o = this.getValueAt(row, 0)) instanceof SnmpOID) {
                int ifIndex = ((SnmpOID)o).getValue()[0];
                int slot = IfIndexUtil.getIfIndexCard((int)ifIndex);
                int type = DmSystem.getCardTypes()[slot - 1];
                return FRUConstants.isSupportSpeedGroup((int)type);
            }
            return super.isCellActive(row, col);
        }

        protected SnmpVar checkCell(SnmpVar v, MibNode mibNode, String name, int row, int col) throws Exception {
            if (col == 2) {
                int value = ((SnmpInt)v).getValue();
                if (value < 1 || value > 4094) {
                    throw new Exception(name + " should be in range " + 1 + ".." + 4094);
                }
                return v;
            }
            return super.checkCell(v, mibNode, name, row, col);
        }

        public Object toCellEditTable(MibNode mibNode, SnmpPDU pdu, SnmpVarBind vb, String var, SnmpOID index, int row, int col) {
            Object o = super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
            if (EditIfPortForm.this.OPERATIONALVSAN != -1) {
                this.setNoSuchInstance(row, EditIfPortForm.this.OPERATIONALVSAN, false);
            }
            return o;
        }
    }

    class ToggleListenerAdminMode
    implements ActionListener {
        ToggleListenerAdminMode() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCmd = e.getActionCommand();
            if (EditIfPortForm.this._serviceState != -1) {
                EditIfPortForm.this.setEnabled(EditIfPortForm.this._serviceState, e.getActionCommand().startsWith("down") && !EditIfPortForm.this.isChanged(EditIfPortForm.this._adminStatus));
            }
        }
    }
}

