/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ip.InsertVirtualIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;

public class EditVsanIFTable
extends EditTable {
    static final int ADDR = 6;
    static final int[] _Index = new int[]{0x7FFFFFF};
    private int NO_CHANGE = 0;
    public static final int IPADDRESS_CHANGE = 1;
    public static final int MASK_CHANGE_ONLY = 2;
    public static final int IPADDRESS_REMOVE = 3;
    public static final int IPADDRESS_ADD = 4;
    int[] _ciiIPIfAddressPrefixLengthOid = MibNode.get((String)"ciiIPIfAddressPrefixLength").getOid();
    static final int IPADDRESS_BUTTON = 0;

    public EditVsanIFTable(String[] vars) {
        super(vars);
    }

    protected int[] getIndex() {
        return _Index;
    }

    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt((Object)"Edit IPAddress...", 0);
        return btns;
    }

    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("x");
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('x', this._table.getSelectedRowCount() > 0);
    }

    protected void updateTable() {
        super.updateTable();
        this.enableButton('x', false);
    }

    protected void buildTable() {
        super.buildTable();
        boolean[] isEditable = this._tableModel.getEditable();
        isEditable[6] = true;
        this._tableModel.setEditable(isEditable);
    }

    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        if (this._state == -96) {
            int ifIndex = responseOid[responseOid.length - 1];
            SnmpPDU getNextPdu = new SnmpPDU(-95, new VarBindList(1));
            SnmpVarBind vb = pdu.getVariables().get(pdu.getVariables().size() - 1);
            getNextPdu.addNull(vb.getOid());
            try {
                SnmpPDU response = this.getPeer().send(getNextPdu);
                int[] addrId = response.getOid(0).getValue();
                row[6] = response.getVariables().get(0).getVar();
                row[6] = this.formatIpAddressMask(ifIndex, addrId, row[6], row[6]);
                this._tableModel.setNoSuchInstance(rowNo, 6, false);
            }
            catch (SnmpException ex) {
                return row;
            }
        }
        this._tableModel.setNoSuchInstance(rowNo, 6, false);
        return row;
    }

    protected void postProcessing() throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-95, new VarBindList());
        for (int i = 0; i < this._data.size(); ++i) {
            int[] index = this._tableModel.getIndex(i);
            pdu.addVar(new SnmpOID(this._ciiIPIfAddressPrefixLengthOid, index));
        }
        SnmpPDU resp = this.getPeer().set(pdu);
        for (int i = 0; i < resp.getVariables().size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            int[] addrId = resp.getVariables().get(i).getOid().getValue();
            row[6] = this.formatIpAddressMask(this._tableModel.getIndex(i)[0], addrId, row[6], resp.getVariables().get(i).getVar());
        }
    }

    String formatIpAddressMask(int ifIndex, int[] addrId, Object var, Object mask) {
        if (SnmpOID.startsWith((int[])this._mibNodes[6].getOid(), (int[])addrId)) {
            int addrIfIndex = addrId[this._ciiIPIfAddressPrefixLengthOid.length];
            if (ifIndex == addrIfIndex) {
                if (var instanceof String) {
                    return (String)var;
                }
                String ipAddrString = addrId[this._ciiIPIfAddressPrefixLengthOid.length + 1] == 2 ? SnmpIpAddress.toHexString((int[])addrId, (int)(this._ciiIPIfAddressPrefixLengthOid.length + 3), (int)addrId.length) + "/" + mask : new SnmpOID(addrId, addrId.length - 4, 4).toString() + "/" + mask;
                return ipAddrString;
            }
            addrId[addrId.length - 7] = ifIndex;
            return "n/a";
        }
        return "n/a";
    }

    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        if (pdu.getVariables().size() > 1) {
            SnmpVarBind vb = pdu.getVariables().get(pdu.getVariables().size() - 2);
            int[] oid = vb.getOid().getValue();
            int index = oid[oid.length - 1];
            pdu.getVariables().remove(pdu.getVariables().size() - 1);
            pdu.addVar(new SnmpOID(this._ciiIPIfAddressPrefixLengthOid, index));
        }
        this.getPeer().send(pdu, (SnmpCallbackIf)this);
    }

    protected void postProcessFetchAllSetRowsPDU(Array changedRows, SnmpPDU pdu) {
        SnmpPDU response;
        int[] addrId;
        VarBindList vbl = new VarBindList();
        SnmpPDU getNextPdu = new SnmpPDU(-95, vbl);
        Array ifIndexList = new Array();
        for (int i = 0; i < changedRows.size(); ++i) {
            addrId = pdu.getOid(i).getValue();
            int[] index = this._tableModel.getIndex(((Integer)changedRows.elementAt(i)).intValue());
            vbl.add(new SnmpVarBind(new SnmpOID(this._mibNodes[6].getOid(), index)));
            ifIndexList.addElement((Object)new Integer(index[index.length - 1]));
        }
        try {
            response = this.getPeer().send(getNextPdu);
        }
        catch (SnmpException ex) {
            return;
        }
        if (response == null) {
            return;
        }
        for (int i = 0; i < response.getVariables().size() && i < changedRows.size(); ++i) {
            int rowNo = (Integer)changedRows.elementAt(i);
            Object[] row = (Object[])this._tableModel.getData().elementAt(rowNo);
            addrId = response.getOid(i).getValue();
            int ifIndex = (Integer)ifIndexList.elementAt(i);
            row[6] = this.formatIpAddressMask(ifIndex, addrId, response.getVariables().get(i).getVar(), response.getVariables().get(i).getVar());
            this._tableModel.setNoSuchInstance(rowNo, 6, false);
        }
    }

    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        int[] firstOid = new int[req.length - 1];
        System.arraycopy(req, 0, firstOid, 0, firstOid.length);
        return !SnmpOID.startsWith((int[])firstOid, (int[])vb.getOid().getValue()) || IfIndexUtil.getType((int)oid[oid.length - 1]) != 8;
    }

    protected SnmpPDU getDeletePDU(int[] selected) {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(selected.length));
        for (int i = 0; i < selected.length; ++i) {
            int ifIndex = this._tableModel.getIndex(selected[i])[0];
            int[] index = new int[3];
            if (IfIndexUtil.getType((int)ifIndex) == 8 && (ifIndex >> 19 & 0x1F) + 1 == 32) {
                int vsanId = this._tableModel.getIndex(selected[i])[0] - 0x8F80000;
                index = new int[]{DmSystem.getProcessorId(), 1, vsanId};
            } else {
                int module = (ifIndex >> 19 & 0x1F) + 1;
                int vsanId = ifIndex & 0xFFF;
                index = new int[]{DmSystem.getProcessorId(module + 21), 1, vsanId};
            }
            pdu.addVar(new SnmpOID(this._rowStatus, index), (SnmpVar)new SnmpInt(this._deleteValue));
        }
        return pdu;
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        Array changedCells = this._tableModel.getChanged();
        SnmpPDU ipPDU = new SnmpPDU(-93, new VarBindList());
        for (int i = pdu.getVariables().size() - 1; i >= 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            Cell cell = (Cell)changedCells.elementAt(i);
            Object[] values = (Object[])this._data.elementAt(cell._row);
            Object[] changed = (Object[])values[this._tableModel.getHeaders().length];
            if (cell._col != 6) continue;
            String oldAddr = (String)changed[6];
            String newAddr = ((SnmpString)vb.getVar()).toString();
            int ifIndex = this._tableModel.getIndex(cell._row)[0];
            int vsanId = IfIndexUtil.getType((int)ifIndex) == 0x8F80000 ? ifIndex - 0x8F80000 : ifIndex & 0xFFF;
            Array ipAddressArray = new Array(2);
            int changeStatus = this.isIpAddressChanged(newAddr, oldAddr, ipAddressArray);
            byte[] ipAddr = (byte[])ipAddressArray.elementAt(0);
            byte[] oldIpAddr = (byte[])ipAddressArray.elementAt(1);
            int slash = newAddr.indexOf(47);
            int mask = slash == -1 ? -1 : Integer.parseInt(newAddr.substring(slash + 1));
            switch (changeStatus) {
                case 4: {
                    InsertVirtualIf.AssignIpAddress(this.getPeer(), ipPDU, ifIndex, ipAddr, mask, vsanId, DmSystem.getProcessorId(), false);
                    break;
                }
                case 3: {
                    InsertVirtualIf.removeIpAddress(this.getPeer(), ipPDU, ifIndex, oldIpAddr);
                    break;
                }
                case 1: {
                    InsertVirtualIf.removeIpAddress(this.getPeer(), ipPDU, ifIndex, oldIpAddr);
                    InsertVirtualIf.AssignIpAddress(this.getPeer(), ipPDU, ifIndex, ipAddr, mask, vsanId, DmSystem.getProcessorId(), false);
                    break;
                }
                case 2: {
                    int[] ipIndex = new int[]{ifIndex, 1, 4, ipAddr[0], ipAddr[1], ipAddr[2], ipAddr[3]};
                    ipPDU.addVar(new SnmpOID(this._ciiIPIfAddressPrefixLengthOid, ipIndex), (SnmpVar)new SnmpUnsignedInt((long)mask));
                }
            }
            pdu.getVariables().remove(i);
        }
        if (pdu.getVariables().size() > 0) {
            this.getPeer().set(pdu);
        }
        if (ipPDU.getVariables().size() > 0) {
            this.getPeer().set(ipPDU);
        }
    }

    int isIpAddressChanged(String newAddr, String oldAddr, Array ipAddrArray) throws SnmpException {
        String oldMask;
        int slash;
        byte[] ipAddr = new byte[]{};
        byte[] oldIpAddr = new byte[]{};
        if (newAddr.equals("n/a")) {
            newAddr = "";
        }
        if (oldAddr.equals("n/a")) {
            oldAddr = "";
        }
        String newIpAddress = (slash = newAddr.indexOf(47)) == -1 ? newAddr : newAddr.substring(0, slash);
        String newMask = slash == -1 ? "" : newAddr.substring(slash + 1);
        slash = oldAddr.indexOf(47);
        String oldIpAddress = slash == -1 ? oldAddr : oldAddr.substring(0, slash);
        String string = oldMask = slash == -1 ? "" : oldAddr.substring(slash + 1);
        if (!oldIpAddress.equals("")) {
            oldIpAddr = SnmpIpAddress.parse((String)oldIpAddress);
        }
        if (!newIpAddress.equals("")) {
            ipAddr = SnmpIpAddress.parse((String)newIpAddress);
        }
        ipAddrArray.addElement((Object)ipAddr);
        ipAddrArray.addElement((Object)oldIpAddr);
        if (newIpAddress.equals("") && !oldIpAddress.equals("")) {
            return 3;
        }
        if (!newIpAddress.equals("") && oldIpAddress.equals("")) {
            return 4;
        }
        if (!newIpAddress.equals(oldIpAddress)) {
            return 1;
        }
        if (!newMask.equals("") && !oldMask.equals(newMask)) {
            return 2;
        }
        return this.NO_CHANGE;
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'x') {
            Object gigEIndex;
            DMDialog dlg = null;
            String interfaceInfo = "";
            int[] selectedRows = this._table.getSelectedRows();
            if (selectedRows.length > 1) {
                gigEIndex = new int[selectedRows.length][0];
                for (int i = 0; i < selectedRows.length; ++i) {
                    gigEIndex[i] = ((SnmpOID)this._tableModel.getValueAt(selectedRows[i], 0)).getValue();
                }
                dlg = DialogListener.getInstance().dialogAction("IP_Address", gigEIndex);
            } else {
                gigEIndex = ((SnmpOID)this._tableModel.getValueAt(selectedRows[0], 0)).getValue();
                dlg = DialogListener.getInstance().dialogAction("IP_Address", (int[])gigEIndex);
                interfaceInfo = Discover.getRoot().ifIndexToName((int)gigEIndex[0]);
            }
            if (dlg != null) {
                InsertDialog insertD;
                DMPanel p = dlg.getPanel(0);
                if (p != null && (insertD = ((EditTable)p).getInsertDialog()) != null) {
                    insertD.dispose();
                }
                dlg.setParentTable((EditTable)this);
                dlg.setTitle(Discover.getDeviceName() + " - IPAddress  " + interfaceInfo);
                dlg.setLocation(DialogUtil.getPointOnScreen((Point)new Point(0, 0), (Component)((JComponent)e.getSource()), (Dimension)dlg.getSize()));
            }
        } else {
            super.doIt(ch, e);
        }
    }

    protected DmTableModel buildTableModel() {
        return new SnmpIPFCTableModel();
    }

    static class SnmpIPFCTableModel
    extends DmTableModel {
        SnmpIPFCTableModel() {
        }

        protected SnmpVar getChangedCell(int row, int col) throws Exception {
            if (col == 6) {
                SnmpString d;
                Object o = this.getValueAt(row, col);
                if (o == null || o.equals("") || o.equals("n/a")) {
                    return new SnmpString(new byte[0]);
                }
                try {
                    d = new SnmpString((String)o);
                }
                catch (NumberFormatException ex) {
                    throw new Exception(this.getHeaders()[col] + ex.getMessage());
                }
                return d;
            }
            return super.getChangedCell(row, col);
        }
    }
}

