/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.InterfaceIndexWithFicon;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.util.HashMap;

public class EditFcipTunnelTable
extends EditTable {
    static final int INTERFACE = 1;
    static final int ETHPORT = 2;
    boolean _isTunnelBase;

    public EditFcipTunnelTable(String[] vars, boolean isTunnelBase) {
        super(vars);
        this._isTunnelBase = isTunnelBase;
    }

    protected boolean isAtEnd(int[] firstOid, SnmpVarBind vb, boolean isMultiple, SnmpPDU pdu) {
        if (this._isTunnelBase) {
            if (vb.getError() == 21) {
                return true;
            }
            return !SnmpOID.startsWith((int[])firstOid, (int[])vb.getOid().getValue());
        }
        return super.isAtEnd(firstOid, vb, isMultiple, pdu);
    }

    protected boolean isSkip(SnmpPDU pdu, boolean isMultiple, int multipleIndexNo) {
        if (this._isTunnelBase) {
            SnmpVarBind vb = pdu.getVariables().get(0);
            int[] oid = vb.getOid().getValue();
            if (isMultiple) {
                return oid[oid.length - 1] != this.getMultipleIndex(multipleIndexNo)[0];
            }
            if (this.getIndex() != null) {
                return oid[oid.length - 1] != this.getIndex()[0];
            }
        }
        return super.isSkip(pdu, isMultiple, multipleIndexNo);
    }

    protected void postProcessing() throws SnmpException {
        if (Discover.getSysVersionInterim().compareTo("1.3") >= 0) {
            return;
        }
        HashMap EthIpAddrHash = this.getEthIpAddressHash(this.getPeer());
        VarBindList vbl = new VarBindList();
        for (int i = 0; i < this._data.size(); ++i) {
            int[] entity = new int[]{this._tableModel.getIndex(i)[0]};
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cfmFcipEntityAddress").getOid(), entity), null));
            this._tableModel.setNoSuchInstance(i, 2, false);
        }
        SnmpPDU resp = SnmpFetch.get((SnmpPeer)this.getPeer(), (VarBindList)vbl);
        for (int i = 0; i < resp.getVariables().size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            SnmpVarBind vb = resp.getVariables().get(i);
            row[2] = vb.getVar() instanceof SnmpNull ? "" : (EthIpAddrHash.get(SnmpIpAddress.toString((byte[])((SnmpString)vb.getVar()).getValue())) == null ? "" : Discover.getRoot().ifIndexToName(((Integer)EthIpAddrHash.get(SnmpIpAddress.toString((byte[])((SnmpString)vb.getVar()).getValue()))).intValue()));
        }
    }

    HashMap getEthIpAddressHash(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        int[] ciiIPIfAddressPrefixLength = MibNode.get((String)"ciiIPIfAddressPrefixLength").getOid();
        int oidLen = ciiIPIfAddressPrefixLength.length;
        vbl.add(new SnmpVarBind(new SnmpOID(ciiIPIfAddressPrefixLength)));
        vbl = SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)vbl, (int)0).getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        HashMap<String, Integer> ethIpAddrHash = new HashMap<String, Integer>();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.get(i).getOid().getValue();
            if (IfIndexUtil.getType((int)oid[oidLen]) != 2 && IfIndexUtil.getType((int)oid[oidLen]) != 4) continue;
            ethIpAddrHash.put(SnmpOID.toString((int[])oid, (int)(oidLen + 3), (int)oid.length), new Integer(oid[oidLen]));
        }
        return ethIpAddrHash;
    }

    void addVb(SnmpPDU pdu, int curr, int row, int col, int[] oid) {
        int[] index = this._tableModel.getIndex(row);
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(oid, index), (SnmpVar)((SnmpGauge)this._tableModel.getValueAt(row, col)));
        pdu.getVariables().add(curr, vb);
    }

    protected void delete() throws SnmpException {
        int i;
        int[] selected = this._table.getSelectedRows();
        Array deleteList = new Array();
        for (i = selected.length - 1; i >= 0; --i) {
            Object[] row = (Object[])this._data.elementAt(selected[i]);
            int fcip = ((SnmpInt)row[1]).getValue();
            if (FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getFiconPort(fcip) == -1) continue;
            deleteList.addElement((Object)new Integer(fcip));
        }
        super.delete();
        for (i = 0; i < deleteList.size(); ++i) {
            FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).setFiconPort(((Integer)deleteList.elementAt(i)).intValue(), -1);
        }
    }

    protected DmTableModel buildTableModel() {
        return new SnmpFcipTableModel();
    }

    class SnmpFcipTableModel
    extends DmTableModel {
        SnmpFcipTableModel() {
        }

        public Object toCell(MibNode mibNode, SnmpVar v, String var, int row) {
            if (var.equals("cfmFcipLinkIfIndex")) {
                try {
                    return new InterfaceIndexWithFicon((SnmpInt)v, this.getIfIndexIf(0), EditFcipTunnelTable.this.getPeer());
                }
                catch (SnmpException ex) {
                    return null;
                }
            }
            return super.toCell(mibNode, v, var, row);
        }
    }
}

