/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcs;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditFcsIeTable
extends EditTable {
    static final int MGMT = 8;
    static final int OID_OFFSET = 14;
    static final int COL_WWN = 1;

    public EditFcsIeTable(String[] vars) {
        super(vars);
    }

    protected void postProcessing() throws SnmpException {
        boolean fetch = false;
        int max = this._data.size();
        for (int i = 0; i < max && !fetch; ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            SnmpInt mgmt = (SnmpInt)row[8];
            if (mgmt.getValue() != 0) {
                fetch = true;
                continue;
            }
            row[8] = null;
        }
        if (fetch) {
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"fcsMgmtAddr").getOid())));
            SnmpPDU resp = SnmpFetch.getBulk((SnmpPeer)this.getPeer(), (VarBindList)vbl);
            this.updateColumn(8, 14, resp.getVariables(), false);
        }
    }

    protected void updateColumn(int col, int idOffset, VarBindList vbl, boolean useIndex) {
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            if (!(row[col] instanceof SnmpInt)) continue;
            int id = ((SnmpInt)row[col]).getValue();
            StringBuffer sb = null;
            if (id != 0) {
                for (int j = 0; j < vbl.size(); ++j) {
                    SnmpVarBind vb = vbl.get(j);
                    int[] oid = vb.getOid().getValue();
                    if (id != oid[idOffset]) continue;
                    if (sb == null) {
                        sb = new StringBuffer();
                    } else {
                        sb.append(", ");
                    }
                    if (useIndex) {
                        byte[] b = new byte[8];
                        for (int k = 0; k < b.length; ++k) {
                            b[k] = (byte)oid[idOffset + 1 + k];
                        }
                        sb.append(WwnDictionary.get((byte[])b));
                        continue;
                    }
                    sb.append(this.translateVar(col, vb.getVar()));
                }
            }
            row[col] = sb == null ? null : sb.toString();
        }
    }

    protected String translateVar(int col, SnmpVar var) {
        return var.toString();
    }

    protected void separateIndexCol(Object[] newRow, int[] index) {
        newRow[1] = new SnmpOID(index, 1, 8);
    }
}

