/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ISLCellEditor;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ISLCellIf;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ficon.InsertFICONPrefPath;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;

public class EditFICONPrefPathTable
extends EditTable
implements ISLCellIf {
    static final int VSAN = 0;
    static final int INTERFACE = 1;
    static final int DESTDOMAIN = 2;
    static final int FCID = 3;
    static final int CUP_NAME = 4;
    static final int PRIMARY_ISL = 5;
    static final int SECONDARY_ISL = 6;
    HashMap _ISLMap;
    HashMap _switchHash;
    ArrayList _npvISLList;
    static final int[] FcIfNxPortAddressOid = MibNode.get((String)"fcIfNxPortAddress").getOid();

    public EditFICONPrefPathTable(String[] vars) {
        super(vars);
    }

    protected Array getButtons() {
        this._tableModel.setIsEditable(true);
        return super.getButtons();
    }

    protected void separateIndexCol(Object[] newRow, int[] index) {
        newRow[1] = new SnmpOID(index, 0, 1);
        newRow[2] = new SnmpOID(index, 2, 1);
    }

    protected void updateTable4Refresh() {
        super.updateTable();
        this._tableModel.sort(0, true);
    }

    protected void buildTable() {
        super.buildTable();
        this._table.getColumnModel().getColumn(5).setCellEditor(new ISLCellEditor(Discover.getPeer(), this._ISLMap, this._switchHash, this._npvISLList, this));
        this._table.getColumnModel().getColumn(6).setCellEditor(new ISLCellEditor(Discover.getPeer(), this._ISLMap, this._switchHash, this._npvISLList, this));
    }

    @Override
    public void ISLCellEditorCB(HashMap ISLMap, HashMap switchHash, ArrayList npvISLList) {
        this._ISLMap = ISLMap;
        this._switchHash = switchHash;
        this._npvISLList = npvISLList;
    }

    protected void get() {
        this._ISLMap = null;
        this._switchHash = null;
        this._npvISLList = null;
        super.get();
        this._firstOid = this._mibNodes[3].getOid();
    }

    protected boolean isAtEnd(int[] firstOid, SnmpVarBind vb, boolean isMultiple, SnmpPDU pdu) {
        if (isMultiple) {
            return super.isAtEnd(firstOid, vb, isMultiple, pdu);
        }
        SnmpVarBind ficonVb = pdu.getVariables().get(2);
        return this.isEnd(this._firstOid, ficonVb);
    }

    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        responseOid = pdu.getVariables().get(2).getOid().getValue();
        return super.buildRow(pdu, responseOid, rowNo);
    }

    protected void postProcessing() throws SnmpException {
        int[] index;
        VarBindList vbl = new VarBindList();
        VarBindList ficonVbl = new VarBindList();
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            row[3] = new SnmpFcAddressId(new byte[0]);
            row[4] = "";
            this._tableModel.setNoSuchInstance(i, 4, false);
            this._tableModel.setNoSuchInstance(i, 3, false);
            int[] fcidIndex = new int[2];
            int[] ficonIndex = new int[2];
            index = this._tableModel.getIndex(i);
            fcidIndex[0] = index[0];
            fcidIndex[1] = ((SnmpOID)row[0]).getValue()[0];
            ficonIndex[0] = ((SnmpOID)row[0]).getValue()[0];
            ficonIndex[1] = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getFiconPort(index[0]);
            vbl.add(new SnmpVarBind(new SnmpOID(FcIfNxPortAddressOid, fcidIndex), null));
            ficonVbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cficonPortRunCfgName").getOid(), ficonIndex), null));
        }
        if (vbl.size() > 0) {
            SnmpPDU resp = SnmpFetch.get((SnmpPeer)this.getPeer(), (VarBindList)ficonVbl);
            if (resp != null && resp.getVariables().size() > 0) {
                ficonVbl = resp.getVariables();
                for (int i = 0; i < ficonVbl.size(); ++i) {
                    Object[] row = (Object[])this._data.elementAt(i);
                    row[4] = ficonVbl.stringValue(i);
                }
            }
            if ((resp = SnmpFetch.next((SnmpPeer)this.getPeer(), (VarBindList)vbl)) != null && resp.getVariables().size() > 0) {
                vbl = resp.getVariables();
                for (int i = 0; i < vbl.size(); ++i) {
                    int[] oid = vbl.get(i).getOid().getValue();
                    if (!SnmpOID.startsWith((int[])this._mibNodes[3].getOid(), (int[])oid)) continue;
                    Object[] row = (Object[])this._data.elementAt(i);
                    index = this._tableModel.getIndex(i);
                    int[] returnIndex = new int[3];
                    System.arraycopy(oid, this._mibNodes[3].getOid().length, returnIndex, 0, 3);
                    if (returnIndex[0] != index[0] || returnIndex[1] != (Integer)row[0]) continue;
                    row[3] = new SnmpFcAddressId(vbl.byteValue(i));
                }
            }
        }
    }

    protected void fetchAllSetRows(Array cells, DmTableModel model) throws SnmpException {
        Array changedCells = new Array();
        Array changedRows = new Array();
        VarBindList vbl = new VarBindList();
        int preRow = -1;
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._row == preRow) continue;
            for (int j = 1; j < this._mibNodes.length; ++j) {
                int[] index = model.getIndex(cell._row, j);
                this.addVarfetchAllSetRows(vbl, index, cell._row, j);
                changedCells.addElement((Object)new Cell(cell._row, j));
            }
            preRow = cell._row;
            changedRows.addElement((Object)new Integer(cell._row));
        }
        SnmpPDU respPDU = null;
        if (vbl.size() > 0) {
            respPDU = this.sendFetchAllSetRowsPDU(vbl);
        }
        if (respPDU == null) {
            return;
        }
        for (int i = 0; i < changedCells.size() && i < respPDU.getVariables().size(); ++i) {
            SnmpVarBind vb = respPDU.getVariables().get(i);
            Cell fetchCell = (Cell)changedCells.elementAt(i);
            Object fetchObject = model.toCellEditTable(this._mibNodes[fetchCell._col], respPDU, vb, this._vars[fetchCell._col - 1], null, fetchCell._row, fetchCell._col);
            Object[] row = (Object[])model.getData().elementAt(fetchCell._row);
            row[fetchCell._col + 2] = fetchObject;
        }
        this.postProcessFetchAllSetRowsPDU(changedRows, respPDU);
    }

    protected void postProcessFetchAllSetRowsPDU(Array changedRows, SnmpPDU pdu) {
        int[] index;
        VarBindList vbl = new VarBindList();
        VarBindList ficonVbl = new VarBindList();
        for (int i = 0; i < changedRows.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(((Integer)changedRows.elementAt(i)).intValue());
            row[3] = new SnmpFcAddressId(new byte[0]);
            int[] fcidIndex = new int[2];
            int[] ficonIndex = new int[2];
            index = this._tableModel.getIndex(((Integer)changedRows.elementAt(i)).intValue());
            fcidIndex[0] = index[0];
            fcidIndex[1] = ((SnmpOID)row[0]).getValue()[0];
            ficonIndex[0] = ((SnmpOID)row[0]).getValue()[0];
            ficonIndex[1] = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getFiconPort(index[0]);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"fcIfNxPortAddress").getOid(), fcidIndex), null));
            ficonVbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cficonPortRunCfgName").getOid(), ficonIndex), null));
        }
        if (vbl.size() > 0) {
            try {
                SnmpPDU resp = SnmpFetch.get((SnmpPeer)this.getPeer(), (VarBindList)ficonVbl);
                if (resp != null && resp.getVariables().size() > 0) {
                    ficonVbl = resp.getVariables();
                    for (int i = 0; i < ficonVbl.size(); ++i) {
                        Object[] row = (Object[])this._data.elementAt(((Integer)changedRows.elementAt(i)).intValue());
                        row[4] = ficonVbl.stringValue(i);
                    }
                }
                if ((resp = SnmpFetch.next((SnmpPeer)this.getPeer(), (VarBindList)vbl)) != null && resp.getVariables().size() > 0) {
                    vbl = resp.getVariables();
                    for (int i = 0; i < vbl.size(); ++i) {
                        int[] oid = vbl.get(i).getOid().getValue();
                        if (!SnmpOID.startsWith((int[])this._mibNodes[3].getOid(), (int[])oid)) continue;
                        Object[] row = (Object[])this._data.elementAt(((Integer)changedRows.elementAt(i)).intValue());
                        index = this._tableModel.getIndex(((Integer)changedRows.elementAt(i)).intValue());
                        int[] returnIndex = new int[3];
                        System.arraycopy(oid, this._mibNodes[3].getOid().length, returnIndex, 0, 3);
                        if (returnIndex[0] != index[0] || returnIndex[1] != (Integer)row[0]) continue;
                        row[3] = new SnmpFcAddressId(vbl.byteValue(i));
                        this._tableModel.setNoSuchInstance(i, 3, false);
                    }
                }
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
    }

    protected boolean validateChanges(Array cells, SnmpTableModel model, String[] mibVars, String message, int offset) {
        if (cells == null) {
            return true;
        }
        ArrayList<Integer> upPorts = new ArrayList<Integer>();
        int preIndex = -1;
        int preRow = -1;
        Object primaryISL = null;
        Object secondaryISL = null;
        boolean isPrimarySecondarySame = false;
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            int[] index = this._tableModel.getIndex(cell._row, cell._col);
            if (index[0] != preIndex) {
                upPorts.add(new Integer(index[0]));
                if (!isPrimarySecondarySame) {
                    isPrimarySecondarySame = this.isPrimarySecondarySame(primaryISL, secondaryISL, preRow);
                }
                secondaryISL = null;
                primaryISL = null;
                preIndex = index[0];
                preRow = cell._row;
            }
            if (cell._col == 5) {
                primaryISL = this.getValueAt(cell._row, cell._col);
                continue;
            }
            if (cell._col != 6) continue;
            secondaryISL = this.getValueAt(cell._row, cell._col);
        }
        if (!isPrimarySecondarySame) {
            isPrimarySecondarySame = this.isPrimarySecondarySame(primaryISL, secondaryISL, preRow);
        }
        if (isPrimarySecondarySame && !this.isIgnoreWarning("Primary/Secondary ISL cannot be the same.\nDo you want to continue ?")) {
            return false;
        }
        if (upPorts.size() > 0) {
            int[] portSelections = new int[upPorts.size()];
            for (int i = 0; i < upPorts.size(); ++i) {
                portSelections[i] = (Integer)upPorts.get(i);
            }
            try {
                PhysicalElement[] sel = new PhysicalElement[portSelections.length];
                for (int i = 0; i < sel.length; ++i) {
                    sel[i] = DeviceManager.getInstance().getView().find(Port.class, portSelections[i]);
                    if (sel[i] != null) continue;
                    PhysicalElement e = (PhysicalElement)Port.class.getConstructor(null).newInstance(null);
                    e.setIndex(new int[]{portSelections[i]});
                    sel[i] = e;
                }
                InsertFICONPrefPath.validateFiconPPSelection((Component)this._parent, this.getPeer(), sel, false);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private boolean isPrimarySecondarySame(Object primaryISL, Object secondaryISL, int preRow) {
        if (primaryISL != null || secondaryISL != null) {
            if (primaryISL == null) {
                primaryISL = this.getValueAt(preRow, 5);
            }
            if (secondaryISL == null) {
                secondaryISL = this.getValueAt(preRow, 6);
            }
            return primaryISL != null && primaryISL.equals(secondaryISL);
        }
        return false;
    }

    protected void delete() throws SnmpException {
        int[] selected = this._table.getSelectedRows();
        if (selected.length == 0) {
            return;
        }
        int[] portSelections = new int[selected.length];
        for (int i = 0; i < portSelections.length; ++i) {
            portSelections[i] = this._tableModel.getIndex(selected[i])[1];
        }
        try {
            PhysicalElement[] sel = new PhysicalElement[portSelections.length];
            for (int i = 0; i < sel.length; ++i) {
                sel[i] = DeviceManager.getInstance().getView().find(Port.class, portSelections[i]);
            }
            InsertFICONPrefPath.validateFiconPPSelection((Component)this._parent, this.getPeer(), sel, false);
        }
        catch (Exception ex) {
            return;
        }
        super.delete();
    }
}

