/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import javax.swing.JFrame;

public class EditFiconPortNumberTable
extends EditTable {
    static final int PORTNUMS = 2;
    static final int TYPE = 3;
    static final int[] entPhysicalNameOid = MibNode.get((String)"entPhysicalName").getOid();
    int[] _cardTypes = DmSystem.getCardTypes();

    public EditFiconPortNumberTable(String[] vars) {
        super(vars);
    }

    protected void postProcessing() throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            int module = ((SnmpOID)row[0]).getValue()[0] + 21;
            pdu.addVar(new SnmpVarBind(new SnmpOID(entPhysicalNameOid, module), null));
            int cardType = this._cardTypes[((SnmpOID)row[0]).getValue()[0] - 1];
            row[2] = cardType == 0 ? "" : Integer.toString(FRUConstants.getNumPorts((int)cardType));
            row[3] = "";
        }
        SnmpPDU resp = this.getPeer().send(pdu);
        for (int i = 0; i < resp.getVariables().size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            SnmpVar v = resp.getVariables().get(i).getVar();
            row[3] = v instanceof SnmpNull ? "" : v.toString();
        }
    }

    protected void postProcessFetchAllSetRowsPDU(Array changedRows, SnmpPDU pdu) {
        super.postProcessFetchAllSetRowsPDU(changedRows, pdu);
        SnmpPDU fetchPdu = new SnmpPDU(-96, new VarBindList(1));
        for (int i = 0; i < changedRows.size(); ++i) {
            int updateRow = (Integer)changedRows.elementAt(i);
            Object[] row = (Object[])this._data.elementAt(updateRow);
            int module = ((SnmpOID)row[0]).getValue()[0] + 21;
            fetchPdu.addVar(new SnmpVarBind(new SnmpOID(entPhysicalNameOid, module), null));
            row[3] = "";
            int cardType = this._cardTypes[((SnmpOID)row[0]).getValue()[0] - 1];
            row[2] = cardType == 0 ? "" : Integer.toString(FRUConstants.getNumPorts((int)cardType));
            this._tableModel.setNoSuchInstance(updateRow, 2, false);
        }
        try {
            SnmpPDU resp = this.getPeer().send(fetchPdu);
            for (int i = 0; i < resp.getVariables().size() && i < changedRows.size(); ++i) {
                int updateRow = (Integer)changedRows.elementAt(i);
                Object[] row = (Object[])this._data.elementAt(updateRow);
                this._tableModel.setNoSuchInstance(updateRow, 3, false);
                SnmpVar v = resp.getVariables().get(i).getVar();
                row[3] = v instanceof SnmpNull ? "Slot Empty" : v.toString();
            }
        }
        catch (SnmpException ex) {
            // empty catch block
        }
        FiconPortByIfIndexCache.getInstance((SnmpPeer)Discover.getPeer()).init(Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"));
        if (PhysicalView._LabelPort == 0) {
            DmSystem.showPortLabelsAsFICON((JFrame)DeviceManager.getInstance(), this.getPeer());
        }
    }
}

