/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fspf;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.Switch;
import com.cisco.dcbu.dmdb.andiamo.dialogs.SwitchMapUtil;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.util.ArrayList;
import java.util.HashMap;

public class EditFSPFInterfaceTable
extends EditTable {
    static final int[] _HelloOid = MibNode.get((String)"fspfIfHelloInterval").getOid();
    static final int[] _DeadOid = MibNode.get((String)"fspfIfDeadInterval").getOid();
    static final int INTERFACE = 0;
    static final int SET_TO_DEFAULT = 1;
    static final int HELLO = 4;
    static final int DEAD = 5;
    static final int RTX_INTERVAL = 6;
    static final int NBR_DOMAINID = 7;
    static final int NBR_PORTINDEX = 8;
    HashMap _switchHash;

    public EditFSPFInterfaceTable(String[] vars) {
        super(vars);
    }

    protected void build() {
        int i;
        super.build();
        String[] insertVars = new String[this._insertVars.length - 1];
        for (i = 0; i < 2; ++i) {
            insertVars[i] = this._insertVars[i];
        }
        for (i = 3; i < this._insertVars.length; ++i) {
            insertVars[i - 1] = this._insertVars[i];
        }
        this._insertVars = insertVars;
        this.getButton('D').setVisible(false);
    }

    protected void preGet() {
        this._switchHash = SwitchMapUtil.getSwitchMapHash(this.getPeer(), 0, new ArrayList());
    }

    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        SnmpVar[] values = new SnmpVar[2];
        values[0] = pdu.getVariables().get(8).getVar();
        int domainId = pdu.getVariables().intValue(7);
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        int vsan = ((SnmpOID)row[0]).getValue()[0];
        Switch sw = SwitchMapUtil.SwitchIPByVsanDomainIdCore(this._switchHash, vsan, domainId);
        values[1] = new SnmpInt(sw != null && sw.isMDS() ? 1 : 2);
        row[9] = this.toCellEMTable(this._mibNodes[9], values, this._vars[8]);
        return row;
    }

    Object toCellEMTable(MibNode mibNode, SnmpVar[] values, String var) {
        if (var.equals("fspfIfNbrPortIndex")) {
            Object o = DmTableModel.getMibVariableFormat((String)"fspfIfNbrPortIndexWithIfIndex", (SnmpVar[])values, (HashMap)DmTableModel._MibVariableFormatMethods, (Class)DmTableModel._MibVariableFormatClass);
            if (o != null) {
                return o;
            }
        }
        return this._tableModel.toCell(mibNode, values[0], var, 0);
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        int i;
        Array changedCells = this._tableModel.getChanged();
        Array swapVarBind = new Array();
        for (i = pdu.getVariables().size() - 1; i >= 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            SnmpOID oid = vb.getOid();
            if (!oid.startsWith(_DeadOid) || i <= 0) continue;
            int[] index = new int[oid.getValue().length - _DeadOid.length];
            System.arraycopy(oid.getValue(), _DeadOid.length, index, 0, index.length);
            SnmpVarBind nextVb = pdu.getVariables().get(i - 1);
            SnmpOID nextOid = nextVb.getOid();
            int[] nextIndex = new int[nextOid.getValue().length - _HelloOid.length];
            System.arraycopy(nextOid.getValue(), _HelloOid.length, nextIndex, 0, nextIndex.length);
            if (!nextOid.startsWith(_HelloOid) || !SnmpOID.equals((int[])index, (int[])nextIndex)) continue;
            Cell cell = (Cell)changedCells.elementAt(i);
            Object[] values = (Object[])this._data.elementAt(cell._row);
            Object[] changed = (Object[])values[this._tableModel.getHeaders().length];
            long oldDead = ((SnmpGauge)changed[5]).getValue();
            long newHello = ((SnmpGauge)nextVb.getVar()).getValue();
            if (newHello <= oldDead) continue;
            swapVarBind.addElement((Object)vb);
            swapVarBind.addElement((Object)nextVb);
            pdu.removeVarAt(i--);
            pdu.removeVarAt(i);
        }
        if (swapVarBind.size() > 0) {
            for (i = 0; i < swapVarBind.size(); ++i) {
                pdu.addVar((SnmpVarBind)swapVarBind.elementAt(i));
            }
        }
        super.sendPdu(pdu);
    }

    protected DmTableModel buildTableModel() {
        return new SnmpFSPFInterfaceTableModel();
    }

    class SnmpFSPFInterfaceTableModel
    extends DmTableModel {
        SnmpFSPFInterfaceTableModel() {
        }

        public boolean isCellActive(int row, int col) {
            if (col >= 1 && col <= 6 && row < EditFSPFInterfaceTable.this._data.size()) {
                Object o = this.getValueAt(row, 0);
                return o != null && IfIndexUtil.getType((int)((SnmpOID)o).getValue()[1]) != 16;
            }
            return super.isCellActive(row, col);
        }
    }
}

