/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditFc2IscsiTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.InsertIscsi2FcNode;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.mds.PortChooser;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckBoxListPanel;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class InsertFc2Iscsi
extends InsertForm {
    static final int INST_INDEX = 0;
    static final int NODE_INDEX = 1;
    static final int NODE_NAME = 2;
    static final int PORT_WWN = 3;
    static final int NODE_ACCESS = 5;
    protected int _AdvtisedIf_Col = this.getVarIndex("fc2IscsiNodeAdvIntfListIndex");
    int _addrListIdx;
    String[] _nodeWWN;
    int _nodeListIdx;
    Object[] _interfaceList;
    Object[] _allInterfaces;
    int _intfListIdx;
    CheckBoxListPanel _listPanel;
    JTextArea _nodeWWNArea;
    String[] _portWWN;
    RadioButtonPanel _nodeAccessPanel;
    SnmpInt _nodeWWNALL;

    public InsertFc2Iscsi(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected int[] getLastIndex() {
        return ((EditFc2IscsiTable)this._table).getTableLastIndex();
    }

    protected void build() {
        super.build();
        int nextValue = 1;
        int[] index = this.getLastIndex();
        if (index != null) {
            nextValue += index[1];
        }
        this.setComponentText(0, "1");
        this.setComponentText(1, Integer.toString(nextValue));
        this.setComponentVisibleAt(0, false);
        this.setComponentVisibleAt(1, false);
        this.setComponentText(2, "iqn.");
        this._nodeAccessPanel.getButton(1).setSelected(true);
        if (this._AdvtisedIf_Col != -1) {
            if (this._allInterfaces == null) {
                this.setComponentVisibleAt(this._AdvtisedIf_Col, false);
            } else {
                this._listPanel.setEnabled(false);
            }
        }
    }

    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 5) {
            return new JLabel("<html><div align=right>Name or IpAddress<br>(One Per Line)</html>", 4);
        }
        if (index == this._AdvtisedIf_Col) {
            return null;
        }
        return super.createFormLabel(mibVar, index);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 3) {
            return new FieldPanel(15, (JComponent)((Object)new PortWWNMenuButton(null, this.getPeer())));
        }
        if (index == 5) {
            JPanel box = new JPanel(null);
            box.setLayout(new BoxLayout(box, 1));
            box.setBorder(BorderFactory.createTitledBorder(""));
            Object[] choices = new String[]{"All", "List"};
            this._nodeAccessPanel = new RadioButtonPanel(choices);
            this._nodeAccessPanel.getButton(0).setActionCommand("V");
            for (int i = 0; i < choices.length; ++i) {
                this._nodeAccessPanel.getButton(i).addActionListener((ActionListener)((Object)this));
            }
            box.add((Component)this._nodeAccessPanel);
            this._nodeWWNArea = new JTextArea();
            this._nodeWWNArea.setWrapStyleWord(true);
            this._nodeWWNArea.setLineWrap(true);
            this._nodeWWNArea.setFont(ChangedCellRenderer.getNormalFont());
            JScrollPane sp = new JScrollPane(this._nodeWWNArea);
            sp.setPreferredSize(new Dimension(150, 100));
            box.add(sp);
            return box;
        }
        if (index == this._AdvtisedIf_Col) {
            JPanel box = new JPanel(null);
            box.setLayout(new BoxLayout(box, 1));
            box.setBorder(BorderFactory.createTitledBorder(""));
            Object[] choices = new String[]{"All", "Select from List:"};
            RadioButtonPanel buttonPanel = new RadioButtonPanel(choices);
            for (int i = 0; i < choices.length; ++i) {
                buttonPanel.getButton(i).addActionListener((ActionListener)((Object)this));
            }
            box.add((Component)buttonPanel);
            this._allInterfaces = InsertFc2Iscsi.getIscsiTargetInterfaces(this.getPeer());
            if (this._allInterfaces == null) {
                this._interfaceList = null;
                return box;
            }
            this._listPanel = new CheckBoxListPanel(this._allInterfaces);
            this._listPanel.clearSelection();
            JScrollPane sp = new JScrollPane((Component)this._listPanel);
            this._listPanel.setUnitIncrement(sp);
            sp.setPreferredSize(new Dimension(170, 150));
            box.add(sp);
            return box;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 3) {
            this._portWWN = new String[1];
            this._portWWN[0] = ((FieldPanel)this._values[index]).getText();
            if (this._portWWN[0].equals("")) {
                throw new NumberFormatException("cannot be blank.");
            }
            return new SnmpInt(0);
        }
        if (index == 5) {
            this._nodeWWNALL = new SnmpInt(this._nodeAccessPanel.getSelected() == 0 ? 1 : 2);
            Array nodeWWNList = new Array();
            String nodeWWNString = this._nodeWWNArea.getText();
            StringTokenizer st = new StringTokenizer(nodeWWNString, ",\n");
            while (st.hasMoreTokens()) {
                String permit = st.nextToken();
                if (!SharedUtil.isIpAddress((String)permit, (boolean)true)) {
                    MibNode iscsiName = MibNode.get((String)"iscsiNodeName");
                    if (iscsiName.getMaxWidth() < permit.length()) {
                        throw new NumberFormatException("Initiator Access  maximum length is " + iscsiName.getMaxWidth());
                    }
                    if (iscsiName.getMinWidth() > permit.length()) {
                        throw new NumberFormatException("Initiator Access  minimum length is " + iscsiName.getMinWidth());
                    }
                }
                nodeWWNList.addElement((Object)permit);
            }
            this._nodeWWN = new String[nodeWWNList.size()];
            for (int i = 0; i < nodeWWNList.size(); ++i) {
                this._nodeWWN[i] = SharedUtil.ipAddressPadding((String)SharedUtil.maskPadding((String)((String)nodeWWNList.elementAt(i))), (boolean)true);
            }
            return new SnmpInt(0);
        }
        if (index == this._AdvtisedIf_Col) {
            if (this._listPanel != null && this._listPanel.isEnabled()) {
                this._interfaceList = this._listPanel.getSelectedValues();
                if (this._interfaceList.length == 0) {
                    throw new NumberFormatException("Advertised Interfaces cannot be blank.");
                }
            } else {
                this._interfaceList = null;
            }
            return new SnmpInt(0);
        }
        if (index == 0 || index == 1) {
            int offset = index == 0 ? 0 : 1;
            return new SnmpInt(this.getLastIndex()[index] + offset);
        }
        return super.getComponentValue(index);
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        this._intfListIdx = -1;
        this._nodeListIdx = -1;
        this._addrListIdx = -1;
        if (this._portWWN != null && this._portWWN.length > 0 && !this._portWWN[0].equals("")) {
            this._addrListIdx = InsertIscsi2FcNode.insertAddressList(this.getPeer(), null, this._portWWN, null, null, null, -1);
        }
        if (this._nodeWWN != null && this._nodeWWN.length > 0) {
            this._nodeListIdx = this.insertNodeList(this.getPeer(), this._nodeWWN);
        }
        if (this._interfaceList != null && this._interfaceList.length > 0) {
            this._intfListIdx = InsertFc2Iscsi.insertAdvIntfList(this.getPeer(), this._interfaceList, 1);
        }
        try {
            super.tableInsert(values, index);
        }
        catch (Exception ex) {
            if (this._addrListIdx != -1) {
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
                EditFc2IscsiTable.deleteAddressList(this.getPeer(), pdu, this._addrListIdx, 1);
                this.getPeer().set(pdu);
            }
            throw new Exception(ex.getMessage());
        }
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        byte[] b = new byte[1];
        SnmpString.setBit((byte[])b, (int)1);
        SnmpVarBind nodeRole = new SnmpVarBind(new SnmpOID(MibNode.get((String)"fc2IscsiNodeRole").getOid(), index), (SnmpVar)new SnmpString(b));
        pdu.getVariables().add(2, nodeRole);
        int[] FCAddrListIndexOid = MibNode.get((String)"fc2IscsiPortFCAddrListIndex").getOid();
        int[] NodePermitListIndex = MibNode.get((String)"fc2IscsiNodePermitListIndex").getOid();
        int[] NodeAdvIntfListIndex = MibNode.get((String)"fc2IscsiNodeAdvIntfListIndex").getOid();
        for (int i = pdu.getVariables().size() - 1; i > 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            if (SnmpOID.startsWith((int[])oid, (int[])FCAddrListIndexOid) && this._addrListIdx != -1) {
                vb.setVar((SnmpVar)new SnmpInt(this._addrListIdx));
                pdu.removeVarAt(i);
                pdu.addVar(vb);
                continue;
            }
            if (SnmpOID.startsWith((int[])oid, (int[])NodePermitListIndex)) {
                pdu.addVar(new SnmpOID(MibNode.get((String)"fc2IscsiNodeAllIntrAccessAllowed").getOid(), index), (SnmpVar)this._nodeWWNALL);
                if (this._nodeListIdx == -1) continue;
                vb.setVar((SnmpVar)new SnmpInt(this._nodeListIdx));
                pdu.removeVarAt(i);
                pdu.addVar(vb);
                continue;
            }
            if (!SnmpOID.startsWith((int[])oid, (int[])NodeAdvIntfListIndex) || this._intfListIdx == -1) continue;
            vb.setVar((SnmpVar)new SnmpInt(this._intfListIdx));
            pdu.removeVarAt(i);
            pdu.addVar(vb);
        }
        return pdu;
    }

    int insertNodeList(SnmpPeer peer, String[] nodeWWN) throws Exception {
        int[] iscsiNodeName = MibNode.get((String)"iscsiNodeName").getOid();
        int[] iscsiNodeNameRowStatus = MibNode.get((String)"iscsiNodeNameRowStatus").getOid();
        int[] index = new int[]{InsertIscsi2FcNode.getLastIndex(this.getPeer(), 2, "iscsiNodeName"), 1};
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(2));
        for (int i = 0; i < nodeWWN.length; ++i) {
            pdu.addVar(new SnmpOID(iscsiNodeNameRowStatus, index), (SnmpVar)new SnmpInt(4));
            pdu.addVar(new SnmpOID(iscsiNodeName, index), (SnmpVar)new SnmpString(nodeWWN[i]));
            peer.set(pdu);
            pdu.reset();
            pdu.setCommand((byte)-93);
            index[1] = index[1] + 1;
        }
        return index[0];
    }

    public static int insertAdvIntfList(SnmpPeer peer, Object[] advIntfList, int listIndex) throws Exception {
        int[] nodeAdvIntfIfIndex = MibNode.get((String)"nodeAdvIntfIfIndex").getOid();
        int[] nodeAdvIntfIfRowStatus = MibNode.get((String)"nodeAdvIntfIfRowStatus").getOid();
        int[] index = new int[]{InsertIscsi2FcNode.getLastIndex(peer, 2, "nodeAdvIntfIfIndex"), listIndex};
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(2));
        for (int i = 0; i < advIntfList.length; ++i) {
            pdu.addVar(new SnmpOID(nodeAdvIntfIfRowStatus, index), (SnmpVar)new SnmpInt(4));
            pdu.addVar(new SnmpOID(nodeAdvIntfIfIndex, index), (SnmpVar)new SnmpInt(Discover.getRoot().nameToIfIndex((String)advIntfList[i])));
            peer.set(pdu);
            pdu.reset();
            pdu.setCommand((byte)-93);
            index[1] = index[1] + 1;
        }
        return index[0];
    }

    public void actionPerformed(ActionEvent e) {
        char cmd = ((AbstractButton)e.getSource()).getActionCommand().charAt(0);
        if (cmd == 'A' || cmd == 'S') {
            if (this._listPanel != null) {
                this._listPanel.setEnabled(cmd == 'S');
            }
        } else if (cmd != 'V' && cmd != 'L') {
            super.actionPerformed(e);
        }
    }

    public static String[] getIscsiTargetInterfaces(SnmpPeer peer) {
        int[] interfaceList = new int[]{};
        try {
            interfaceList = PortChooser.fetchInterfaces((SnmpPeer)peer, (int)3, (IfIndexIf)Discover.getRoot());
        }
        catch (SnmpException ex) {
            return new String[0];
        }
        if (interfaceList.length == 0) {
            return null;
        }
        String[] names = new String[interfaceList.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = Discover.getRoot().ifIndexToName(interfaceList[i]);
        }
        return names;
    }

    static class NodeWWNMenuButton
    extends MenuButton {
        SnmpPeer _peer;

        public NodeWWNMenuButton(JMenu menu, SnmpPeer peer) {
            super(menu);
            this._peer = peer;
        }

        public void actionPerformed(ActionEvent e) {
            if (this._menu == null) {
                this._menu = new JMenu();
                try {
                    Object[] names = InsertIscsi2FcNode.getIscsiNodeWWN(this._peer, "init", 1);
                    if (names == null) {
                        this.setEnabled(false);
                        return;
                    }
                    this.buildMenu(names);
                }
                catch (SnmpException ex) {
                    // empty catch block
                }
                super.actionPerformed(e);
            } else if (e.getSource() instanceof JMenuItem) {
                String selected = ((JMenuItem)e.getSource()).getText();
                int vendorPos = selected.indexOf(" ");
                ((FieldPanel)this.getParent()).setText(selected.substring(vendorPos == -1 ? 0 : vendorPos + 1, selected.length()));
            } else {
                super.actionPerformed(e);
            }
        }
    }

    static class PortWWNMenuButton
    extends MenuButton {
        SnmpPeer _peer;

        public PortWWNMenuButton(JMenu menu, SnmpPeer peer) {
            super(menu);
            this._peer = peer;
        }

        public void actionPerformed(ActionEvent e) {
            if (this._menu == null) {
                this._menu = new JMenu();
                try {
                    Object[] names = InsertIscsi2FcNode.getIscsiNodeWWN(this._peer, "target", 3);
                    if (names == null) {
                        this.setEnabled(false);
                        return;
                    }
                    this.buildMenu(names);
                }
                catch (SnmpException ex) {
                    // empty catch block
                }
                super.actionPerformed(e);
            } else if (e.getSource() instanceof JMenuItem) {
                String selected = ((JMenuItem)e.getSource()).getText();
                int vendorPos = selected.indexOf(" ");
                ((FieldPanel)this.getParent()).setText(selected.substring(vendorPos == -1 ? 0 : vendorPos + 1, selected.length()));
            } else {
                super.actionPerformed(e);
            }
        }
    }
}

