/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditFc2IscsiTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditIscsi2FcTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditIscsiNodeTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.InsertIscsi2FcNode;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class InsertIscsiNode
extends InsertForm {
    protected SnmpTableModel _tableModel;
    protected int[] _insertIndex;
    static final int PORT_WWN = 2;

    public InsertIscsiNode(InsertDialog parent, EditTable table) {
        super(parent, table);
        this._tableModel = this._table.getTableModel();
    }

    protected void build() {
        super.build();
        int[] index = this.getLastIndex();
        ((JTextField)this._values[0]).setText(Integer.toString(index[0]));
        ((JTextField)this._values[1]).setText(Integer.toString(index[1] + 1));
        this.setComponentVisibleAt(0, false);
        this.setComponentVisibleAt(1, false);
        if (this.getInitiatorName() != -1) {
            ((JTextField)this._values[this.getInitiatorName()]).addFocusListener(new InitiatorNameListener());
        }
    }

    protected int[] getLastIndex() {
        int[] index = new int[]{0, 0};
        if (this._tableModel.getRowCount() > 0) {
            return ((SnmpOID)this._tableModel.getValueAt(this._tableModel.getRowCount() - 1, 0)).getValue();
        }
        index[0] = this.getNewListIndex();
        return index;
    }

    int getNewListIndex() {
        return InsertIscsi2FcNode.getLastIndex(this.getPeer(), 2, "iscsiNodeName");
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 2) {
            String wwn = ((JTextField)this._values[index]).getText();
            if (this.getInitiatorName() != -1) {
                if (!SharedUtil.isIpAddress((String)wwn, (boolean)true)) {
                    return super.getComponentValue(index);
                }
                return new SnmpString(SharedUtil.ipAddressPadding((String)SharedUtil.maskPadding((String)wwn), (boolean)true));
            }
        }
        return super.getComponentValue(index);
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        boolean isFirstEntry = this._tableModel.getRowCount() == 0;
        this._insertIndex = index;
        super.tableInsert(values, index);
        if (isFirstEntry) {
            try {
                this.setPersistent(this.getPersistentOid(), 1);
            }
            catch (SnmpException ex) {
                this.entryRollback(this._insertIndex);
                throw new SnmpException(ex.getMessage());
            }
            try {
                this.setListIndex(this.getListIndexOid(), Integer.parseInt(this.getComponentText(0)));
                this.updateCFSStatus();
            }
            catch (SnmpException ex) {
                this.entryRollback(this._insertIndex);
                this.setPersistent(this.getPersistentOid(), 2);
                throw new SnmpException(ex.getMessage());
            }
        }
        int ind = Integer.parseInt(this.getComponentText(1)) + 1;
        this.setComponentText(1, Integer.toString(ind));
    }

    void entryRollback(int[] insertIndex) {
        if (insertIndex == null) {
            return;
        }
        try {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(this._mibNodes.length + 1));
            pdu.addVar(new SnmpOID(this.getRowStatus(), insertIndex), (SnmpVar)new SnmpInt(6));
            this.sendPdu(pdu);
        }
        catch (SnmpException ex) {
            DefaultLogger._DefLogger.debug((Object)("iscsi entry rollback failed : " + ex.getMessage()));
        }
    }

    int[] getListIndexOid() {
        return MibNode.get((String)"fc2IscsiNodePermitListIndex").getOid();
    }

    void setListIndex(int[] listIndexOid, int newListIndex) throws SnmpException {
        int[] iscsiIndex = ((EditIscsiNodeTable)this._table)._iscsiIndex;
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
        pdu.addVar(new SnmpOID(listIndexOid, iscsiIndex), (SnmpVar)new SnmpInt(newListIndex));
        this.sendPdu(pdu);
    }

    int[] getPersistentOid() {
        return null;
    }

    void setPersistent(int[] persistentOid, int value) throws SnmpException {
        if (persistentOid == null) {
            return;
        }
        int[] iscsiIndex = ((EditIscsiNodeTable)this._table)._iscsiIndex;
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
        pdu.addVar(new SnmpOID(persistentOid, iscsiIndex), (SnmpVar)new SnmpInt(value));
        this.sendPdu(pdu);
    }

    MibNode getObjectMibNode() {
        return MibNode.get((String)"iscsiNodeName");
    }

    String getObjectString() {
        return "Initiator Access";
    }

    int getInitiatorName() {
        return 2;
    }

    protected void updateCFSStatus() throws SnmpException {
        if (this._table.getParentTable() != null && (this._table.getParentTable() instanceof EditFc2IscsiTable && ((EditFc2IscsiTable)this._table.getParentTable()).isISLB() || this._table.getParentTable() instanceof EditIscsi2FcTable && ((EditIscsi2FcTable)this._table.getParentTable()).isISLB())) {
            DmSystem.isCFSEnabled((JFrame)DeviceManager.getInstance(), this.getPeer(), new int[][]{DmSystem.CFS_ISLB_INDEX}, null, false);
        }
    }

    class InitiatorNameListener
    extends FocusAdapter {
        @Override
        public void focusLost(FocusEvent e) {
            String nodeWWN = ((JTextField)InsertIscsiNode.this._values[2]).getText();
            boolean isIP = SharedUtil.isIpAddress((String)nodeWWN, (boolean)true);
            if (!isIP) {
                return;
            }
            try {
                ((JTextField)InsertIscsiNode.this._values[2]).setText(SharedUtil.maskPadding((String)nodeWWN));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }
}

