/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.physical;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.mds.renderers.SensorValueRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import javax.swing.table.TableCellRenderer;

public class EditSfpDiagPowerOnlyTable
extends EditTable {
    int[] _Index = new int[]{FRUConstants.getSensorOffset((boolean)Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"))};
    static final int LOW_ALARM_COL = 2;
    static final int LOW_WARNING_COL = 3;
    static final int SENSOR_VAL_COL = 1;
    static final int HIGH_WARNING_COL = 4;
    static final int HIGH_ALARM_COL = 5;
    static final int RELATION_COL = 6;
    static final int TYPE_COL = 7;
    static final int SCALE_COL = 8;
    static final int ENT_INDEX_COL = 10;
    static final int MAJOR = 1;
    static final int MINOR = 2;
    static final int LESS_THAN = 1;
    static final int GREATER_THAN = 3;
    protected boolean is6_1_0_above = Discover.getSysVersionWithMinor().compareTo("6.1(0)") >= 0;
    MibEnum[] _EntSensorScaleEnums = MibNode.get((String)"entSensorScale").getEnums();
    static final int[] Scale = new int[]{0, -24, -21, -18, -15, -12, -9, -6, -3, 0, 3, 6, 9, 12, 15, 18, 21, 24};
    static final MibEnum[] SensorType = new MibEnum[]{new MibEnum("Voltage", 3), new MibEnum("Current", 5), new MibEnum("Temperature", 8), new MibEnum("Rx Power", 14), new MibEnum("Tx Power", 15)};

    public EditSfpDiagPowerOnlyTable(String[] vars) {
        super(vars);
    }

    private int getSensorIndex(int ifIndex) {
        int newIndex = SharedUtil.getSensorIndex((boolean)this.is6_1_0_above, (int)ifIndex, (int)Discover.getRoot().getCardType4IfIndex(ifIndex));
        return newIndex += MibEnum.getValue((MibEnum[])SensorType, (String)"Rx Power") - 1;
    }

    protected int[] getIndex() {
        return new int[]{this.getSensorIndex(super.getIndex()[0])};
    }

    protected int[] getMultipleIndex(int row) {
        return new int[]{this.getSensorIndex(super.getMultipleIndex(row)[0])};
    }

    protected void updateTable() {
        super.updateTable();
    }

    protected void buildTable() {
        super.buildTable();
        this._table.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new SensorValueRenderer(3, 4, 1));
    }

    protected void build() {
        super.build();
        this._table.removeColumn(this._table.getColumnModel().getColumn(8));
        this._table.removeColumn(this._table.getColumnModel().getColumn(7));
        this._table.removeColumn(this._table.getColumnModel().getColumn(6));
    }

    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        String type = (String)row[7];
        int exp = Scale[MibEnum.getValue((MibEnum[])this._EntSensorScaleEnums, (String)((String)row[8]))];
        int current = ((SnmpInt)row[1]).getValue();
        int slot = SharedUtil.getSensorSlot((boolean)this.is6_1_0_above, (int)((SnmpOID)row[0]).getValue()[0]);
        int port = SharedUtil.getSensorPort((boolean)this.is6_1_0_above, (int)((SnmpOID)row[0]).getValue()[0], (int)slot);
        int interfaceIndex = 0;
        interfaceIndex = this.isMultiple() ? super.getMultipleIndex(this._multipleIndexNo)[0] : super.getIndex()[0];
        int ifPort = IfIndexUtil.getPortEntity2If((int)port, (int)Discover.getRoot().getCardType4IfIndex(interfaceIndex));
        int lane = SharedUtil.getSensorLane((boolean)this.is6_1_0_above, (int)((SnmpOID)row[0]).getValue()[0], (int)slot, (int)port);
        int sens_type = SharedUtil.getSensorType((boolean)this.is6_1_0_above, (int)((SnmpOID)row[0]).getValue()[0], (int)slot, (int)port, (int)lane);
        String sens_string = MibEnum.getLabel((MibEnum[])SensorType, (int)sens_type);
        row[1] = current == 0 && (sens_string.startsWith("Rx") || sens_string.startsWith("Tx")) ? "n/a" : (exp >= 0 ? Double.valueOf((double)current * Math.pow(10.0, exp)) : (double)current / Math.pow(10.0, -exp) + " " + type);
        Object[] newRow = new Object[row.length + 1];
        System.arraycopy(row, 0, newRow, 0, row.length);
        newRow[newRow.length - 1] = row[0];
        StringBuffer sb = new StringBuffer();
        int ifType = IfIndexUtil.getType((int)interfaceIndex);
        int ifIndex = IfIndexUtil.nameToIfIndex((int)(slot + 1), (int)(ifPort + 1), (int)ifType);
        String ifName = Discover.getRoot().ifIndexToName(ifIndex);
        sb.append(ifName);
        if (lane != 0) {
            sb.append(" lane ");
            sb.append(lane + 1);
        }
        sb.append(", ");
        sb.append(sens_string);
        newRow[0] = sb.toString();
        return newRow;
    }

    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        return this.isEnd(req, vb, this.getIndex());
    }

    protected boolean isEnd(int[] req, SnmpVarBind vb, int[] index) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        for (int i = 0; i < req.length - 1 && i < oid.length; ++i) {
            if (req[i] == oid[i]) continue;
            return true;
        }
        int sensorStopOffset = index[0] + 1;
        return req.length != oid.length || oid[oid.length - 1] > sensorStopOffset;
    }

    protected void postProcessing() throws SnmpException {
        VarBindList vbl = new VarBindList();
        int[] _thresholdValueOid = MibNode.get((String)"entSensorThresholdValue").getOid();
        int[] _entSensorThresholdRelationOid = MibNode.get((String)"entSensorThresholdRelation").getOid();
        int[] thresholdIndexOrder = new int[]{3, 4, 2, 1};
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            row[3] = "";
            row[2] = "";
            row[4] = "";
            row[5] = "";
            for (int k = 0; k < thresholdIndexOrder.length; ++k) {
                int[] index = new int[]{((SnmpOID)row[10]).getValue()[0], thresholdIndexOrder[k]};
                vbl.add(new SnmpVarBind(new SnmpOID(_thresholdValueOid, index)));
                vbl.add(new SnmpVarBind(new SnmpOID(_entSensorThresholdRelationOid, index)));
            }
        }
        SnmpPDU resp = SnmpFetch.get((SnmpPeer)this.getPeer(), (VarBindList)vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        int i = 0;
        for (int rowNo = 0; rowNo < this._data.size() && i < vbl.size(); ++rowNo) {
            SnmpOID oid = vbl.get(i).getOid();
            if (!oid.startsWith(_thresholdValueOid)) {
                return;
            }
            Object[] row = (Object[])this._data.elementAt(rowNo);
            int id = ((SnmpOID)row[10]).getValue()[0];
            if (oid.getValue()[oid.getValue().length - 2] != id) continue;
            String type = (String)row[7];
            int scale = MibEnum.getValue((MibEnum[])this._EntSensorScaleEnums, (String)((String)row[8]));
            for (int j = 2; j <= 5; ++j) {
                SnmpVar value;
                int[] index = vbl.get(i).getOid().getValue();
                int thresholdType = index[index.length - 1] == 1 || index[index.length - 1] == 2 ? 1 : 2;
                if ((value = vbl.get(i++).getVar()).getType() == 5) continue;
                int relation = ((SnmpInt)vbl.get(i++).getVar()).getValue();
                int exp = Scale[scale];
                int sensorValue = ((SnmpInt)value).getValue();
                row[j] = SharedUtil.getSensorString((int)exp, (int)sensorValue, null);
            }
        }
        this.setStatus(this._data.size() + " row(s)");
    }
}

