/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.portchannel;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ficon.FiconLogicalCellEditor;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.InterfaceIndexWithFicon;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.mds.InterfacePortsCellEditor;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.mds.ficon.FiconPortList;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;

public class EditChannelTable
extends EditTable {
    int MEMBERLIST = 4;
    int FICONLIST = 5;
    int FICONPORT = 12;
    int _autoReply_col;
    boolean _isFiconEnabled;
    SnmpVar _memberList;

    public EditChannelTable(String[] vars) {
        super(vars);
    }

    protected void buildTable() {
        this._isFiconEnabled = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getIsFiconEnabled();
        super.buildTable();
        ListSelectionModel tableListener = this._table.getSelectionModel();
        tableListener.setSelectionMode(1);
        int type = 3;
        if (DmId.isN5K(Discover.getSysObjectID())) {
            type = 1;
        }
        SwitchAttrIf ifIndexIf = Discover.getRoot();
        MyInterfacePortsCellEditor edtrRndr = new MyInterfacePortsCellEditor(Discover.getDeviceName(), type, false, (IfIndexIf)Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{22, 27, 39, 41, 10000005, 0x989686, 10000010, 10000019, 10000017, 0x989696, 10000023, 0x989698, 0x989699, 10000026, 10000027, 10000028, 70000004, 70000002, 70000018, 70000001, 70000003, 70000005, 70000011, 20000001, 20000002, 20000009, 20000015, 20000014, 20000005, 20000006, 20000011, 20000012, 20000013, 20000003, 20000004, 20000008, 10000002, 10000004, 10000011, 10000012, 10000013, 30000001, 30000005, 30000003, 30000004, 40000007, 40000018, 40000046, 60000004, 69, 52, 58, 57, 68}, null, 1, new int[]{ifIndexIf.getActualType(2), ifIndexIf.getActualType(26), ifIndexIf.getActualType(31)}), this.getPeer(), 1, false);
        this._table.getColumnModel().getColumn(this.MEMBERLIST).setCellEditor((TableCellEditor)((Object)edtrRndr));
        if (this._isFiconEnabled) {
            MyInterfacePortsCellEditor edtrFICONRndr = new MyInterfacePortsCellEditor(Discover.getDeviceName(), type, false, (IfIndexIf)Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{22, 27, 39, 41, 68}, null, 1, new int[]{2}), this.getPeer(), 1, true);
            this._table.getColumnModel().getColumn(this.FICONLIST).setCellEditor((TableCellEditor)((Object)edtrFICONRndr));
            if (Discover.isSysVersionlessThan((String)"3.0(0)")) {
                String portAndRange = "(" + DmSystem.getFiconPortLogicRange() + ")";
                this._tableModel.setHeader(this.FICONPORT - 1, "<html>FICON Address<br>" + portAndRange);
                this._tableModel.fireTableStructureChanged();
            } else {
                this._table.getColumnModel().getColumn(this.FICONPORT - 1).setCellEditor(new FiconLogicalCellEditor(this.getPeer()));
            }
        } else {
            this.setRemoveMibVarIndices(new int[]{this.FICONPORT - 1, this.FICONLIST});
        }
    }

    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        if (this._isFiconEnabled) {
            Object[] row = super.buildRow(pdu, responseOid, rowNo);
            Object[] newRow = new Object[row.length + 1];
            System.arraycopy(row, 0, newRow, 0, row.length);
            this._autoReply_col = row.length;
            return newRow;
        }
        this._autoReply_col = -1;
        return super.buildRow(pdu, responseOid, rowNo);
    }

    protected void postFetchRow(SnmpPDU pdu) {
        super.postFetchRow(pdu);
        this._tableModel.setNoSuchInstance(this._data.size() - 1, this.FICONPORT - 1, false);
    }

    protected void postProcessing() throws SnmpException {
        if (Discover.getSysVersionInterim().compareTo("1.3") < 0) {
            return;
        }
        VarBindList vbl = new VarBindList();
        int[] portChannelExtAutoCreated = MibNode.get((String)"portChannelExtAutoCreated").getOid();
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            int ifIndex = 0x4000000 + (this._tableModel.getIndex(i)[0] - 1);
            int ficonPort = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getFiconPort(ifIndex);
            row[this.FICONPORT] = new SnmpFiconPort(ficonPort);
            this._tableModel.setNoSuchInstance(i, this.FICONPORT, false);
            if (!this._isFiconEnabled) continue;
            vbl.add(portChannelExtAutoCreated, this._tableModel.getIndex(i)[0]);
        }
        if (this._isFiconEnabled && vbl.size() > 0 && this._autoReply_col != -1) {
            SnmpPDU resp = SnmpFetch.get((SnmpPeer)this.getPeer(), (VarBindList)vbl);
            vbl = resp.getVariables();
            for (int i = 0; i < vbl.size(); ++i) {
                Object[] row = (Object[])this._data.elementAt(i);
                row[this._autoReply_col] = vbl.intValue(i) == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (!DeviceManager.getInstance().showingPhysicalView()) {
            return;
        }
        int[] rows = this._table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        PhysicalView view = DeviceManager.getInstance().getView();
        view.clearSelection();
        Object o = this._tableModel.getValueAt(rows[0], 3);
        if (o instanceof SnmpIntList) {
            SnmpIntList members = (SnmpIntList)o;
            int[] ifIndex = SnmpIntList.valueOf((byte[])members.getValue());
            Array elements = view.getElements();
            block0: for (int i = elements.size() - 1; i >= 0; --i) {
                PhysicalElement el = (PhysicalElement)elements.elementAt(i);
                el.setSelected(false);
                for (int j = 0; j < ifIndex.length; ++j) {
                    if (el.getIndex()[0] != ifIndex[j]) continue;
                    el.setSelected(true);
                    continue block0;
                }
            }
        }
        view.repaint();
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        int i;
        Array ficonPortList = new Array();
        VarBindList vbl = pdu.getVariables();
        Array changedCells = this._tableModel.getChanged();
        for (i = 0; i < pdu.getVariables().size(); ++i) {
            SnmpVarBind vb = vbl.get(i);
            SnmpOID oid = vb.getOid();
            if (!oid.startsWith(FiconPortByIfIndexCache._cficonPortIfIndexOid)) continue;
            int ficonPort = ((SnmpInt)vb.getVar()).getValue();
            int ifIndex = 0x4000000 + oid.getValue()[oid.getValue().length - 1] - 1;
            vbl.remove(i);
            if (ficonPort == -1) {
                Cell cell = (Cell)changedCells.elementAt(i);
                Object[] values = (Object[])this._data.elementAt(cell._row);
                Object[] changed = (Object[])values[this._tableModel.getHeaders().length];
                SnmpFiconPort oldFiconPort = (SnmpFiconPort)changed[this.FICONPORT];
                vbl.add(i, new SnmpVarBind(new SnmpOID(FiconPortByIfIndexCache._cficonPortIfIndexOid, oldFiconPort.getValue()), (SnmpVar)new SnmpInt(0)));
            } else {
                vbl.add(i, new SnmpVarBind(new SnmpOID(FiconPortByIfIndexCache._cficonPortIfIndexOid, ficonPort), (SnmpVar)new SnmpInt(ifIndex)));
            }
            ficonPortList.addElement((Object)new ficonPortIfIndex(ficonPort, ifIndex));
        }
        this.getPeer().set(pdu);
        if (ficonPortList.size() > 0) {
            for (i = 0; i < ficonPortList.size(); ++i) {
                FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).setFiconPort(((ficonPortIfIndex)ficonPortList.elementAt(i)).getIfIndex(), ((ficonPortIfIndex)ficonPortList.elementAt(i)).getFiconPort());
            }
        }
    }

    protected void fetchAllSetRows(Array cells, DmTableModel model) throws SnmpException {
        int i;
        super.fetchAllSetRows(cells, model);
        if (cells == null || cells.size() == 0 || Discover.getSysVersionInterim().compareTo("1.3") < 0) {
            return;
        }
        Array changedRows = new Array();
        int preRow = -1;
        for (i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._row == preRow) continue;
            changedRows.addElement((Object)new Cell(cell._row, this.FICONPORT));
            preRow = cell._row;
        }
        for (i = 0; i < changedRows.size(); ++i) {
            Cell fetchCell = (Cell)changedRows.elementAt(i);
            int ifIndex = 0x4000000 + this._tableModel.getIndex(fetchCell._row)[0] - 1;
            int ficonPort = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getFiconPort(ifIndex);
            Object[] row = (Object[])model.getData().elementAt(fetchCell._row);
            row[this.FICONPORT] = new SnmpFiconPort(ficonPort);
            this._tableModel.setNoSuchInstance(fetchCell._row, this.FICONPORT, false);
        }
    }

    protected void delete() throws SnmpException {
        int i;
        int[] selected = this._table.getSelectedRows();
        Array deleteList = new Array();
        for (i = selected.length - 1; i >= 0; --i) {
            int ifIndex = 0x4000000 + this._tableModel.getIndex(selected[i])[0] - 1;
            if (FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getFiconPort(ifIndex) == -1) continue;
            deleteList.addElement((Object)new Integer(ifIndex));
        }
        super.delete();
        for (i = 0; i < deleteList.size(); ++i) {
            FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).setFiconPort(((Integer)deleteList.elementAt(i)).intValue(), -1);
        }
    }

    protected DmTableModel buildTableModel() {
        return new SnmpChannelTableModel();
    }

    static class MyInterfacePortsCellEditor
    extends InterfacePortsCellEditor {
        boolean _isFICON;

        MyInterfacePortsCellEditor(String windowTitle, int type, boolean exclusive, IfIndexIf ifIndexIf, PortEditorCardAttribute[] slotmembers, PortEditorFilter filters, SnmpPeer peer, int logicalType, boolean isFICON) {
            super(windowTitle, type, exclusive, ifIndexIf, slotmembers, filters, peer, logicalType);
            this._isFICON = isFICON;
        }

        protected void setIsFiconPortDialog(boolean isFicon) {
            super.setIsFiconPortDialog(this._isFICON);
        }

        protected void setPreSelectFilterEnable(boolean enabled) {
            super.setPreSelectFilterEnable(true);
        }
    }

    static class ficonPortIfIndex {
        int _ficonPort;
        int _ifIndex;

        public ficonPortIfIndex(int ficonPort, int ifIndex) {
            this._ficonPort = ficonPort;
            this._ifIndex = ifIndex;
        }

        public int getFiconPort() {
            return this._ficonPort;
        }

        public int getIfIndex() {
            return this._ifIndex;
        }
    }

    class SnmpChannelTableModel
    extends DmTableModel {
        SnmpChannelTableModel() {
        }

        protected Object getTextConventionFormat(MibNode mibNode, String tc, SnmpVar v, int col) {
            if (EditChannelTable.this._isFiconEnabled && col == EditChannelTable.this.FICONLIST + 1) {
                return new FiconPortList(((SnmpString)v).getValue(), (IfIndexIf)Discover.getRoot(), EditChannelTable.this.getPeer());
            }
            return super.getTextConventionFormat(mibNode, tc, v, col);
        }

        public Object toCellEditTable(MibNode mibNode, SnmpPDU pdu, SnmpVarBind vb, String var, SnmpOID index, int row, int col) {
            SnmpVar v = vb.getVar();
            if (var.equals("portChannelIfIndex")) {
                try {
                    return new InterfaceIndexWithFicon((SnmpInt)v, this.getIfIndexIf(0), EditChannelTable.this.getPeer());
                }
                catch (SnmpException ex) {
                    return null;
                }
            }
            if (var.equals("portChannelMemberOperStatus")) {
                if (EditChannelTable.this._memberList == null || v.getType() == 5) {
                    return null;
                }
                String membersStr = ((SnmpString)EditChannelTable.this._memberList).toString();
                if (membersStr == null || membersStr.equals("")) {
                    return null;
                }
                SnmpVar[] values = new SnmpVar[]{EditChannelTable.this._memberList, v};
                SwitchAttrIf ifIndexIf = Discover.getRoot();
                return MibVariableFormat.portChannelMemberOperStatus((SnmpVar)EditChannelTable.this._memberList, (SnmpVar)v, (IfIndexIf)ifIndexIf);
            }
            if (var.equals("portChannelMemberList")) {
                EditChannelTable.this._memberList = v;
            }
            return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
        }

        protected SnmpVar getChangedCell(int row, int col) throws Exception {
            if (col == EditChannelTable.this.FICONPORT) {
                return (SnmpVar)this.getValueAt(row, col);
            }
            return super.getChangedCell(row, col);
        }

        public boolean isCellActive(int row, int col) {
            if (col == EditChannelTable.this.FICONPORT && EditChannelTable.this._autoReply_col != -1) {
                Object o = this.getValueAt(row, EditChannelTable.this._autoReply_col);
                return o == null || (Boolean)o == false;
            }
            return super.isCellActive(row, col);
        }
    }
}

