/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.portchannel;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditEthSubIfTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.portchannel.EditChannelIfTable;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.renderers.PortIndexRenderer;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;

public class EditEChannelTable
extends EditEthSubIfTable {
    static final int IPADDRESS_BUTTON = 1;

    public EditEChannelTable(String[] vars) {
        super(vars);
        this._ifTypePos = this.getVarIndex("ifType") + 1;
        this._authMethodPos = this.getVarIndex("iscsiGigEIfAuthMethod") + 1;
        this._profileNamePos = this.getVarIndex("iscsiGigEIfIsnsServerProfileName") + 1;
    }

    protected int[] getIndex() {
        if (this.isSpecificInstance()) {
            if (this.isMultiple()) {
                return new int[]{0x4000000 + this.getMultipleIndex(0)[0] - 1};
            }
            if (super.getIndex() != null) {
                return new int[]{0x4000000 + super.getIndex()[0] - 1};
            }
        }
        return EditChannelIfTable._IfIndex;
    }

    protected int[] getIndexFor(MibNode mibNode, int[] index) {
        if (this.isSpecificInstance()) {
            String channelIfString = "channel" + index[0];
            int channelIf = Discover.getRoot().nameToIfIndex(channelIfString);
            int[] newIndex = new int[index.length];
            newIndex[0] = channelIf - 1;
            return newIndex;
        }
        return super.getIndexFor(mibNode, index);
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt((Object)"Edit SubInterface...", 1);
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        this._buttons[1].setActionCommand("VLAN");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('V', this._table.getSelectedRowCount() > 0);
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        this.enableButton('V', false);
    }

    protected void build() {
        super.build();
        if (this._ifTypePos != -1) {
            this._table.removeColumn(this._table.getColumnModel().getColumn(this._ifTypePos));
        }
        this._table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new PortIndexRenderer(this.getPeer()));
        this._buttons[1].setVisible(Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"));
    }

    protected boolean isSkip(SnmpPDU pdu) {
        int type = ((SnmpInt)pdu.getVariables().get(pdu.getVariables().size() - 1).getVar()).getValue();
        return type == 56;
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        int[] firstOid = new int[req.length - 1];
        System.arraycopy(req, 0, firstOid, 0, firstOid.length);
        return !SnmpOID.startsWith((int[])firstOid, (int[])vb.getOid().getValue()) || IfIndexUtil.getType((int)oid[oid.length - 1]) != 4;
    }

    public void dispose() {
        super.dispose();
        DMDialog d = DialogListener.getInstance().getDialog("Channel_SubInterface");
        if (d != null) {
            DialogListener.getInstance().remove("Channel_SubInterface");
            d.dispose();
        }
    }

    @Override
    public void get() {
        super.get();
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'V') {
            boolean isBuilt = false;
            int[] index = ((SnmpOID)this._tableModel.getValueAt(this._table.getSelectedRow(), 0)).getValue();
            DMDialog subIntDlg = DialogListener.getInstance().dialogAction("Channel_SubInterface", index);
            if (subIntDlg != null) {
                subIntDlg.setTitle(Discover.getDeviceName() + " - Create EthChannel SubInterface " + Discover.getRoot().ifIndexToName(index[0]));
                subIntDlg.setParentTable((EditTable)this);
            }
        } else {
            super.doIt(ch, e);
        }
    }
}

