/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.portchannel;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.GraphTable;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.PortChooser;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Dimension;
import java.awt.event.ActionEvent;

public class GraphPortChannelTable
extends GraphTable {
    int[] _interfaces = new int[0];
    boolean _isRepack = false;

    public GraphPortChannelTable(String[] vars) {
        super(vars);
    }

    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt((Object)"Update", 0);
        return btns;
    }

    protected void updateAll(long upTime) {
        super.updateAll(upTime);
        this.enableButton('U', MS_INTERVALS[this._pollInterval.getSelectedIndex()] == 0);
    }

    protected int getNumObjects() {
        if (this._interfaces == null || this._interfaces.length == 0) {
            try {
                this._interfaces = PortChooser.fetchInterfaces((SnmpPeer)this.getPeer(), (int)this.getInterfaceType(), (IfIndexIf)Discover.getRoot());
            }
            catch (SnmpException ex) {
                DefaultLogger._DefLogger.debug((Object)("GraphPortChannel, failed to get interfaces :" + ex.getMessage()));
            }
        }
        if (this._interfaces == null) {
            return 0;
        }
        return this._interfaces.length;
    }

    protected int[] getMultipleIndex(int row) {
        int[] index = new int[]{this._interfaces[this._interfaces.length > 1 ? row : 0]};
        return index;
    }

    protected void get() {
        this.preGet();
        boolean isFiconEnabled = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getIsFiconEnabled();
        if (isFiconEnabled) {
            for (int i = 0; i < this.getNumObjects(); ++i) {
                Object[] row = (Object[])this._data.elementAt(i);
                StringBuffer sb = new StringBuffer();
                int ficonPort = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getFiconPort(this.getMultipleIndex(i)[0]);
                if (ficonPort != -1) {
                    sb.append(" (");
                    sb.append(SnmpFiconPort.toString((int)ficonPort));
                    sb.append(")");
                }
                row[0] = Discover.getRoot().ifIndexToName(this.getMultipleIndex(i)[0]) + sb.toString();
            }
        }
        super.get();
    }

    protected void preGet() {
        Array data = new Array();
        for (int i = 0; i < this.getNumObjects(); ++i) {
            Object[] row = new Object[this._vars.length + 1];
            row[0] = Discover.getRoot().ifIndexToName(this.getMultipleIndex(i)[0]);
            data.addElement((Object)row);
        }
        this._data = data;
        this._model.setData(this._data);
        this._absolutes = new SnmpVar[this._data.size()][this._vars.length];
        this._cumulatives = new long[this._data.size()][this._vars.length];
        this._minimums = new long[this._data.size()][this._vars.length];
        this._maximums = new long[this._data.size()][this._vars.length];
        this._lastValues = new long[this._data.size()][this._vars.length];
        this._scrollPane.setPreferredSize(this._table.calcPreferredSize());
        if (this._interfaces == null || this._interfaces.length == 0) {
            Dimension d = this._table.calcPreferredSize();
            this._scrollPane.setPreferredSize(d);
            if (d.width > 1008) {
                this._table.setAutoResizeMode(0);
            }
            this._table.getTableHeader().resizeAndRepaint();
            ((KTableModel)this._table.getModel()).fireTableDataChanged();
            return;
        }
    }

    int getInterfaceType() {
        return 7;
    }

    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        super.callback(session, reqid, pdu, timedOut);
        if (this._isRepack) {
            this._isRepack = false;
            Dimension d = this._table.calcPreferredSize();
            this._scrollPane.setPreferredSize(d);
            if (d.width > 1008) {
                this._table.setAutoResizeMode(0);
            }
            this._table.getTableHeader().resizeAndRepaint();
            ((KTableModel)this._table.getModel()).fireTableDataChanged();
        }
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'U') {
            this._isRepack = true;
            this.resetTable();
            this._pollVbl = null;
            this.get();
            int mSecs = MS_INTERVALS[this._pollInterval.getSelectedIndex()];
            boolean bl = this._isPolling = mSecs > 0;
            if (this._statusTimer != null) {
                if (this._isPolling) {
                    this._statusTimer.setInitialDelay(mSecs);
                    this._statusTimer.setDelay(mSecs);
                    if (this._statusTimer.isRunning()) {
                        this._statusTimer.restart();
                    } else {
                        this._statusTimer.start();
                    }
                } else {
                    this._statusTimer.stop();
                }
            }
        } else {
            if (ch == 'i') {
                this.getButton('U').setEnabled(MS_INTERVALS[this._pollInterval.getSelectedIndex()] == 0);
            }
            super.doIt(ch, e);
        }
    }
}

