/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.portchannel;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ficon.FiconLogicalMenuButton;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.mds.ficon.FiconPortList;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class InsertPortChannel
extends InsertForm {
    boolean _isMemberChanged = false;
    static final int INDEX = 0;
    static final int TRUNKADMIN = 1;
    static final int OPERMODE = 2;
    static final int SPEED = 3;
    static final int FORCETYPE = 4;
    static final int VSANID = 5;
    static final int FICON_PORT = 6;
    static final int MEMBER = 7;
    static final int ALLOWEDVSAN = 8;
    MdsPortChooser _ports;
    boolean _isFiconEnabled;
    int _ficonPort;
    SnmpPDU _vsanPDU;
    SnmpPDU _allowedVsanPDU;
    EditTable _table;
    boolean _isEChannel = false;
    static final int[] _fcIfAdminSpeedOid = MibNode.get((String)"fcIfAdminSpeed").getOid();
    static final int SPEED_AUTOMAX2G = 5;
    static final int SPEED_8G = 6;
    static final int SPEED_AUTOMAX4G = 7;
    static String[] OPERMODE_SELECTION = new String[0];
    boolean _isMetal = UIManager.getLookAndFeel().getClass() == MetalLookAndFeel.class;

    public InsertPortChannel(InsertDialog parent, EditTable table) {
        super(parent, table);
        this._table = table;
        this._isFiconEnabled = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getIsFiconEnabled();
        if (Discover.isSysVersionGreaterThanEqual((String)"4.1(2)")) {
            String[] stringArray;
            if (DmSystem.getIsNPVMode()) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "auto";
                stringArray = stringArray2;
                stringArray2[1] = "NP";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "auto";
                stringArray3[1] = "E";
                stringArray = stringArray3;
                stringArray3[2] = "F";
            }
            OPERMODE_SELECTION = stringArray;
        } else {
            OPERMODE_SELECTION = new String[]{"auto", "E"};
        }
    }

    protected void build() {
        super.build();
        ((RadioButtonPanel)this._values[2]).getButton(DmSystem.getIsNPVMode() ? 1 : 0).setSelected(true);
        if (DmSystem.getIsNPVMode()) {
            ((RadioButtonPanel)this._values[2]).getButton(0).setVisible(false);
        }
    }

    protected void buildForm() {
        super.buildForm();
        ((KTextField)this._values[8]).setText("1-4093");
        this._labels[6].setVisible(this._isFiconEnabled);
        this._values[6].setVisible(this._isFiconEnabled);
        this._ports.getField().addFocusListener(new memeberListener());
        RadioButtonPanel commandPanel = (RadioButtonPanel)this.getComponentAt(1);
        for (int i = 0; i < commandPanel.getComponentCount(); ++i) {
            if (!commandPanel.getButton(i).isVisible()) continue;
            commandPanel.getButton(i).addActionListener((ActionListener)((Object)this));
        }
        int insets = this._isMetal ? 3 : 5;
        Dimension d = this._container.getPreferredSize();
        ((JPanel)this._container).setPreferredSize(new Dimension(d.width + 2 * insets, d.height + 2 * insets));
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 7) {
            int type = 3;
            if (DmId.isN5K(Discover.getSysObjectID())) {
                type = 1;
            }
            int[] excludedList = new int[]{22, 27, 39, 41, 10000005, 0x989686, 10000010, 10000019, 10000017, 0x989696, 10000023, 0x989698, 0x989699, 10000026, 10000027, 10000028, 70000004, 70000002, 70000018, 70000001, 70000003, 70000005, 70000011, 20000001, 20000002, 20000009, 20000015, 20000014, 20000005, 20000006, 20000011, 20000012, 20000013, 20000003, 20000004, 20000008, 10000002, 10000004, 10000011, 10000012, 10000013, 30000001, 30000005, 30000003, 30000004, 40000007, 40000018, 40000046, 60000004, 69, 52, 58, 57, 68};
            if (Discover.isSysVersionGreaterThanEqual((String)"4.0")) {
                int[] GE_MODULES = new int[]{6, 24, 44};
                int[] temp = new int[excludedList.length + 3];
                System.arraycopy(excludedList, 0, temp, 0, excludedList.length);
                System.arraycopy(GE_MODULES, 0, temp, excludedList.length, GE_MODULES.length);
                excludedList = temp;
            }
            SwitchAttrIf ifIndexIf = Discover.getRoot();
            this._ports = new MyMdsPortChooser(Discover.getDeviceName(), type, false, (IfIndexIf)Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(excludedList, null, 1, new int[]{ifIndexIf.getActualType(2), ifIndexIf.getActualType(26), ifIndexIf.getActualType(31)}), this.getPeer(), 1);
            return this._ports;
        }
        if (index == 6) {
            return new FieldPanel(mibNode.getMaxWidth(), (JComponent)((Object)new FiconLogicalMenuButton(null, this.getPeer())));
        }
        if (index == 5) {
            FieldPanel f = new FieldPanel(5, (JComponent)new VsanIdMenuButton(null, this.getPeer(), (IfIndexIf)Discover.getRoot()));
            f.setRange(1, 4093);
            return f;
        }
        if (index == 2) {
            return new RadioButtonPanel((Object[])OPERMODE_SELECTION, OPERMODE_SELECTION.length);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected MibEnum[] getApplicableEnums(MibNode mibNode) {
        MibEnum[] enums = super.getApplicableEnums(mibNode);
        if (DmId.isN5K(Discover.getSysObjectID()) && MibNode.equals((int[])_fcIfAdminSpeedOid, (int[])mibNode.getOid()) == 0) {
            ArrayList<MibEnum> al = new ArrayList<MibEnum>();
            for (int i = 0; i < enums.length; ++i) {
                int speed = enums[i].getValue();
                if (speed == 6 || speed == 7 || speed == 5) continue;
                al.add(enums[i]);
            }
            enums = al.toArray(new MibEnum[0]);
        }
        return enums;
    }

    protected int[] getLastIndex() {
        Array data = this.getTableModel().getData();
        int nextIndex = 1;
        for (int i = 0; i < data.size(); ++i) {
            SnmpOID index = (SnmpOID)((Object[])data.elementAt(i))[0];
            if (index.getValue()[0] > nextIndex) {
                return new int[]{nextIndex - 1};
            }
            if (++nextIndex != 4094) continue;
            return new int[]{4092};
        }
        if (nextIndex > 4093) {
            return new int[]{nextIndex - 1};
        }
        return new int[]{nextIndex - 1};
    }

    public void dispose() {
        if (this._ports != null) {
            this._ports.dismiss();
        }
        super.dispose();
    }

    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 1) {
            return new JLabel("TrunkAdmin:", 4);
        }
        if (index == 2) {
            return new JLabel("ModeAdmin:", 4);
        }
        if (index == 3) {
            return new JLabel("SpeedAdmin:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 6) {
            this._ficonPort = ((FieldPanel)this._values[6]).getText().equals("") || !this._isFiconEnabled ? -1 : SnmpFiconPort.parse((String)((FieldPanel)this._values[6]).getText(), (boolean)true);
            return null;
        }
        if (index == 7) {
            boolean isFICON = this._isFiconEnabled && !((FieldPanel)this._values[6]).getText().equals("");
            String ifName = ((MdsPortChooser)this._values[index]).getText();
            if (ifName.equals("")) {
                return null;
            }
            if (isFICON) {
                Discover.getInstance();
                return new FiconPortList(ifName, (IfIndexIf)Discover.getRoot(), this.getPeer());
            }
            Discover.getInstance();
            return new SnmpIntList(ifName, (IfIndexIf)Discover.getRoot(), DmSystem.getSlotMembers(), DmSystem.getIfNameTypes());
        }
        if (index == 2) {
            int selected = ((RadioButtonPanel)this._values[index]).getSelected();
            if (selected == -1) {
                throw new Exception(this._labels[index].getText() + " please make a selection");
            }
            String adminMode = ((RadioButtonPanel)this._values[2]).getButton(selected).getText();
            return new SnmpInt(MibEnum.getValue((MibEnum[])MibNode.get((String)"fcIfAdminMode").getEnums(), (String)adminMode));
        }
        return super.getComponentValue(index);
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpVar addTypeV = values[4];
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        this._vsanPDU = null;
        this._allowedVsanPDU = null;
        if (this._isEChannel) {
            pdu.removeVarAt(7);
            SnmpVarBind members = new SnmpVarBind(new SnmpOID(MibNode.get((String)"portChannelMemberList").getOid(), index), values[7]);
            pdu.addVar(members);
            this._isMemberChanged = true;
            return pdu;
        }
        this._vsanPDU = new SnmpPDU(-93, new VarBindList(1));
        this._allowedVsanPDU = new SnmpPDU(-93, new VarBindList(1));
        SnmpVar fcifAdminV = values[2];
        SnmpVar fcIfAdminTrunkModeV = values[1];
        SnmpVar fcIfAdminSpeedV = values[3];
        SnmpVar vsanIdV = values[5];
        SnmpVar allowedVsanV = null;
        if (values[8] != null) {
            pdu.removeVarAt(8);
            allowedVsanV = values[8];
        }
        if (values[7] != null) {
            pdu.removeVarAt(7);
        }
        pdu.removeVarAt(5);
        pdu.removeVarAt(3);
        pdu.removeVarAt(2);
        pdu.removeVarAt(1);
        int[] channelIndex = new int[]{0x4000000 + index[0] - 1};
        pdu.getVariables().add(1, new SnmpVarBind(new SnmpOID(MibNode.get((String)"fcIfAdminSpeed").getOid(), channelIndex), fcIfAdminSpeedV));
        SnmpVarBind vsanId = new SnmpVarBind(new SnmpOID(MibNode.get((String)"vsanIfVsan").getOid(), channelIndex), vsanIdV);
        SnmpVarBind fcifAdmin = new SnmpVarBind(new SnmpOID(MibNode.get((String)"fcIfAdminMode").getOid(), channelIndex), fcifAdminV);
        SnmpVarBind fcifAdminTrunkMode = new SnmpVarBind(new SnmpOID(MibNode.get((String)"fcIfAdminTrunkMode").getOid(), channelIndex), fcIfAdminTrunkModeV);
        this._vsanPDU.getVariables().add(fcifAdminTrunkMode);
        this._vsanPDU.getVariables().add(fcifAdmin);
        this._vsanPDU.addVar(vsanId);
        if (values[8] != null) {
            SnmpOID oid = new SnmpOID(MibNode.get((String)"fcIfAllowedVsanList2k").getOid(), channelIndex);
            SnmpVarBind allowedVsan = new SnmpVarBind(oid, allowedVsanV);
            this._allowedVsanPDU.addVar(allowedVsan);
            PortInterfaceUtil.getInstance((int)1).addVsan4k2Pdu(this._allowedVsanPDU, oid, allowedVsanV, channelIndex);
        }
        this._isMemberChanged = false;
        if (values[7] != null) {
            SnmpVarBind members = new SnmpVarBind(new SnmpOID(MibNode.get((String)"portChannelMemberList").getOid(), index), values[7]);
            this._vsanPDU.addVar(new SnmpVarBind(new SnmpOID(MibNode.get((String)"portChannelAddType").getOid(), index), addTypeV));
            this._vsanPDU.addVar(members);
            this._isMemberChanged = true;
        }
        if (this._ficonPort != -1) {
            this._vsanPDU.getVariables().add(pdu.getVariables().size(), new SnmpVarBind(new SnmpOID(FiconPortByIfIndexCache._cficonPortIfIndexOid, this._ficonPort), (SnmpVar)new SnmpInt(channelIndex[0])));
        }
        return pdu;
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        super.tableInsert(values, index);
        if (this._allowedVsanPDU != null && this._allowedVsanPDU.getVariables().size() > 0) {
            try {
                this.getPeer().set(this._allowedVsanPDU);
            }
            catch (SnmpException ex) {
                StringBuffer sb = new StringBuffer();
                sb.append(ex.getMessage());
                try {
                    this.portChannelRollback(index);
                }
                catch (SnmpException ex1) {
                    sb.append("; failed to rollback portChannel entry (");
                    sb.append(ex1.getMessage());
                    sb.append(")");
                }
                throw new Exception(sb.toString());
            }
        }
        if (this._vsanPDU != null) {
            try {
                this.getPeer().set(this._vsanPDU);
                if (this._isMemberChanged) {
                    JOptionPane.showMessageDialog((Component)this._parent, "You've changed membership list. Please do the same operation on the peer switch,\nthen admin up at both ends to bring them up.", this._parent.getTitle(), 2);
                }
            }
            catch (SnmpException ex) {
                StringBuffer sb = new StringBuffer();
                sb.append(ex.getMessage());
                try {
                    this.portChannelRollback(index);
                }
                catch (SnmpException ex1) {
                    sb.append("; failed to rollback portChannel entry (");
                    sb.append(ex1.getMessage());
                    sb.append(")");
                }
                throw new Exception(sb.toString());
            }
        }
        if (this._ficonPort != -1) {
            FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).setFiconPort(0x4000000 + index[0] - 1, this._ficonPort);
        }
    }

    private void portChannelRollback(int[] index) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(this._mibNodes.length + 1));
        pdu.addVar(new SnmpOID(MibNode.get((String)"portChannelRowStatus").getOid(), index), (SnmpVar)new SnmpInt(6));
        this.getPeer().set(pdu);
    }

    protected void insert() throws Exception {
        this._ficonPort = -1;
        this._isEChannel = this.isEChannel();
        super.insert();
        int lastIndex = 1;
        Array data = this._table.getTableModel().getData();
        if (data.size() > 0) {
            Object[] row = (Object[])data.elementAt(data.size() - 1);
            int[] idx = ((SnmpOID)row[0]).getValue();
            lastIndex = idx[idx.length - 1];
        }
        this.setComponentText(0, lastIndex < this._mibNodes[0].getHi() ? Integer.toString(lastIndex + 1) : "");
        this.setComponentText(7, "");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JRadioButton) {
            String cmd = ((JRadioButton)e.getSource()).getText();
            boolean isTrunk = cmd.equals("trunk");
            this._values[8].setEnabled(isTrunk);
            this._labels[8].setEnabled(isTrunk);
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean isEChannel() {
        boolean hasIPSPort;
        String member = this.getComponentText(7);
        boolean bl = hasIPSPort = member.indexOf("gigE") != -1 || member.indexOf("IPS") != -1;
        if (member.indexOf("gigE") != -1) {
            this._labels[8].setEnabled(!hasIPSPort);
            this._values[8].setEnabled(!hasIPSPort);
            this._labels[1].setEnabled(!hasIPSPort);
            this._values[1].setEnabled(!hasIPSPort);
            this._labels[2].setEnabled(!hasIPSPort);
            this._values[2].setEnabled(!hasIPSPort);
            this._labels[3].setEnabled(!hasIPSPort);
            this._values[3].setEnabled(!hasIPSPort);
            this._labels[5].setEnabled(!hasIPSPort);
            this._values[5].setEnabled(!hasIPSPort);
            return true;
        }
        return false;
    }

    class MyMdsPortChooser
    extends MdsPortChooser {
        MyMdsPortChooser(String windowTitle, int type, boolean exclusive, IfIndexIf ifIndexIf, PortEditorCardAttribute[] slotmembers, PortEditorFilter filters, SnmpPeer peer, int logicalInterfaceType) {
            super(windowTitle, type, exclusive, ifIndexIf, slotmembers, filters, peer, logicalInterfaceType);
        }

        protected void setIsFiconPortDialog(boolean isFicon) {
            boolean isFICON = InsertPortChannel.this._isFiconEnabled && !((FieldPanel)InsertPortChannel.this._values[6]).getText().equals("");
            super.setIsFiconPortDialog(isFICON);
        }

        protected void setPreSelectFilterEnable(boolean enabled) {
            super.setPreSelectFilterEnable(true);
        }

        public void portChooserCB(String ifName, Object context) {
            super.portChooserCB(ifName, context);
            InsertPortChannel.this._isEChannel = InsertPortChannel.this.isEChannel();
        }
    }

    class memeberListener
    extends FocusAdapter {
        memeberListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            InsertPortChannel.this._isEChannel = InsertPortChannel.this.isEChannel();
        }
    }
}

