/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.EditAAASvrTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class EditAAAFeatureTable
extends EditTable {
    private static final int KEY_TYPE = 1;
    private static final int KEY = 2;

    public EditAAAFeatureTable(String[] vars) {
        super(vars);
    }

    protected boolean isSkip(SnmpPDU pdu) {
        VarBindList vbl = pdu.getVariables();
        int[] oid = vbl.get(0).getOid().getValue();
        return oid[oid.length - 1] > EditAAASvrTable._protocolSupportUpto;
    }

    protected boolean validateChanges(Array cells, SnmpTableModel model, String[][] mibVars, String[] message, int offset) {
        boolean returnValue = super.validateChanges(cells, model, mibVars, message, offset);
        if (!returnValue) {
            return returnValue;
        }
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._col != 1) continue;
            if (i < cells.size() - 1) {
                Cell nextCell = (Cell)cells.elementAt(i + 1);
                if (nextCell._row == cell._row && nextCell._col == 2) {
                    ++i;
                    continue;
                }
            }
            if (JOptionPane.showConfirmDialog((Component)this.getParent(), "You should change the key as well as the key type.\nContinue?", this.getParent().getTitle(), 0, 2) == 0) continue;
            return false;
        }
        return true;
    }

    protected SnmpPDU getSetPDU() throws Exception {
        Array cells = this._tableModel.getChanged();
        int[][] indeces = new int[2][];
        int preRow = -1;
        if (cells != null && cells.size() > 0) {
            for (int i = 0; i < cells.size(); ++i) {
                Cell cell = (Cell)cells.elementAt(i);
                if (cell._row == preRow) continue;
                int[] protocol = this._tableModel.getIndex(cell._row, cell._col);
                if (protocol[0] == 2) {
                    indeces[0] = DmSystem.CFS_RADIUS_INDEX;
                    continue;
                }
                indeces[1] = DmSystem.CFS_TACACS_INDEX;
            }
            this.setCFSFeatureView(indeces);
        }
        return super.getSetPDU();
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        super.sendPdu(pdu);
        this.setCFSPending(this.getPeer());
    }

    protected MenuButton getCFSButton() {
        return new CFSApplyButton(null, "CFS");
    }

    class CFSApplyButton
    extends MenuButton {
        String[] _cfsActionMenu;

        public CFSApplyButton(JMenu menu, String name) {
            super(menu, name);
            this._cfsActionMenu = new String[]{"radius Commit", "radius Abort", "tacacs Commit", "tacacs Abort"};
        }

        public void actionPerformed(ActionEvent e) {
            block10: {
                if (this._menu == null) {
                    this._menu = new JMenu();
                    this.buildMenu(this._cfsActionMenu);
                }
                boolean[] isEnabled = EditAAAFeatureTable.this.isCFSEnabled(false);
                int i = 0;
                int j = 0;
                while (i < isEnabled.length) {
                    EditAAAFeatureTable.this._cfsButton.getMenu().getItem(j).setEnabled(isEnabled[i]);
                    EditAAAFeatureTable.this._cfsButton.getMenu().getItem(j + 1).setEnabled(isEnabled[i]);
                    ++i;
                    j += 2;
                }
                if (e.getSource() instanceof JMenuItem) {
                    try {
                        if (((JMenuItem)e.getSource()).getText().startsWith("Apply")) {
                            EditAAAFeatureTable.this.set();
                            break block10;
                        }
                        String cmd = ((JMenuItem)e.getSource()).getText();
                        int action = ((JMenuItem)e.getSource()).getText().endsWith("Commit") ? 4 : 5;
                        int offset = ((JMenuItem)e.getSource()).getText().startsWith("radius") ? 0 : 1;
                        EditAAAFeatureTable.this.cfsAction(action, EditAAAFeatureTable.this._cfsFeatureIndex[offset]);
                    }
                    catch (SnmpException ex) {
                        Util.errorMessage((Component)DeviceManager.getInstance(), (String)ex.getMessage());
                    }
                    catch (Exception ex) {
                        if (SnmpSession.isTrace()) {
                            ex.printStackTrace();
                        }
                        Util.errorMessage((Component)DeviceManager.getInstance(), (String)ex.getMessage());
                    }
                    catch (Error ex) {
                        Util.errorMessage((Component)EditAAAFeatureTable.this._parent, (String)ex.getMessage());
                    }
                } else {
                    super.actionPerformed(e);
                }
            }
        }
    }
}

