/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.EditAAASvrTable;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.IntHashMap;

public class EditAAASvrGrpTable
extends EditTable {
    private static final int NAME = 1;
    private static final int PROTOCOL = 2;
    private static final int GROUP_LIST = 3;
    IntHashMap _serverHash;

    public EditAAASvrGrpTable(String[] vars) {
        super(vars);
    }

    protected void preGet() {
        this._serverHash = new IntHashMap();
    }

    protected void postProcessing() throws SnmpException {
        this.getSvrHash();
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            Object o = row[3];
            if (!(o instanceof SnmpLongList)) continue;
            long[] groupList = SnmpLongList.valueOf((byte[])((SnmpLongList)o).getValue());
            int protocol = ((String)row[2]).equals("radius") ? 2 : 1;
            row[3] = this.getSvrList(protocol, groupList);
        }
    }

    void getSvrHash() {
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cAAAServerAddrType").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cAAAServerAddr").getOid())));
        try {
            SnmpPDU resp = SnmpFetch.getBulk((SnmpPeer)this.getPeer(), (VarBindList)vbl);
            vbl = resp.getVariables();
            if (vbl.size() == 0) {
                return;
            }
        }
        catch (SnmpException ex) {
            // empty catch block
        }
        for (int i = 0; i < vbl.size(); i += 2) {
            int[] oid = vbl.getVb(i).getOid().getValue();
            int id = oid[oid.length - 2] * 100 + oid[oid.length - 1];
            int type = vbl.intValue(i);
            String name = type == 16 ? vbl.stringValue(i + 1) : SnmpIpAddress.toString((byte[])((SnmpString)vbl.getVb(i + 1).getVar()).getValue());
            this._serverHash.put(id, (Object)name);
        }
    }

    private String getSvrList(int protocol, long[] groupList) {
        if (this._serverHash == null || this._serverHash.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < groupList.length; ++j) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            int id = protocol * 100 + (int)groupList[j];
            sb.append(this._serverHash.get(id));
        }
        return sb.toString();
    }

    protected boolean isSkip(SnmpPDU pdu) {
        VarBindList vbl = pdu.getVariables();
        int protocol = vbl.intValue(1);
        if (protocol == 3) {
            return true;
        }
        return protocol > EditAAASvrTable._protocolSupportUpto;
    }
}

