/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.CfsStatusCache;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class EditCommonUserTable
extends EditTable {
    private boolean _isV3;
    byte[] _engineId;
    private int USER = 0;
    private int ROLE = 1;
    private int PASSWORD = 2;
    private int EXPIRYDATE = 5;
    private int SSHFILE = 7;
    private int[] _ccmCommonUserRoleRowStatusOid = MibNode.get((String)"ccmCommonUserRoleRowStatus").getOid();
    public static final int[] CcmCommonUserPasswordOid = MibNode.get((String)"ccmCommonUserPassword").getOid();
    private boolean _isNetworkAdminRole;

    public EditCommonUserTable(String[] vars) {
        super(vars);
    }

    protected void build() {
        super.build();
        this._engineId = this.getPeer().getEngineId();
        boolean[] isEditable = this._tableModel.getEditable();
        boolean bl = this._isV3 = this._engineId != null && this.getPeer().getVersion() == 3;
        if (!this._isV3) {
            for (int i = 0; i < isEditable.length; ++i) {
                isEditable[i] = false;
            }
            this._tableModel.setEditable(isEditable);
            this.enableButton("Create", false);
            this.enableButton('D', false);
            this._rowStatus = null;
        }
        isEditable[this.ROLE] = false;
    }

    protected void updateTable() {
        if (this.getStatus().startsWith("timeout")) {
            super.updateTable();
        } else {
            block5: {
                for (int i = 0; i < this._data.size(); ++i) {
                    Object[] row = (Object[])this._data.elementAt(i);
                    row[this.PASSWORD] = new SnmpString("");
                }
                try {
                    this.fetchRole(-1);
                }
                catch (Exception ex) {
                    if (!SnmpSession.isTrace()) break block5;
                    ex.printStackTrace();
                }
            }
            super.updateTable();
        }
        this.setStatus(this.getStatus() + "    (Any User DB Change Requires Privacy Protocol.)");
    }

    void fetchRole(int fetchRow) throws SnmpException {
        SnmpOID bulkOid;
        if (fetchRow == -1) {
            for (int i = 0; i < this._data.size(); ++i) {
                Object[] row = (Object[])this._data.elementAt(i);
                row[this.ROLE] = "";
                this._tableModel.setNoSuchInstance(i, this.ROLE, false);
            }
        } else {
            Object[] row = (Object[])this._data.elementAt(fetchRow);
            row[this.ROLE] = "";
            this._tableModel.setNoSuchInstance(fetchRow, this.ROLE, false);
        }
        VarBindList vbl = new VarBindList(1);
        int[] userOid = null;
        if (fetchRow == -1) {
            this._isNetworkAdminRole = false;
            bulkOid = new SnmpOID(this._ccmCommonUserRoleRowStatusOid);
        } else {
            userOid = ((SnmpOID)((Object[])this._data.elementAt(fetchRow))[this.USER]).getValue();
            bulkOid = new SnmpOID(this._ccmCommonUserRoleRowStatusOid, userOid);
        }
        vbl.add(new SnmpVarBind(bulkOid));
        SnmpPDU resp = SnmpFetch.getBulk((SnmpPeer)this.getPeer(), (VarBindList)vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        int i = 0;
        while (i < vbl.size()) {
            int rowNo;
            SnmpVarBind vb = vbl.get(i++);
            int[] oid = vb.getOid().getValue();
            int[] userName = new int[oid[this._ccmCommonUserRoleRowStatusOid.length] + 1];
            System.arraycopy(oid, this._ccmCommonUserRoleRowStatusOid.length, userName, 0, userName.length);
            if (fetchRow != -1 && userOid != null && !SnmpOID.equals((int[])userOid, (int[])userName) || (rowNo = this.findRow(this._data, userName, (SnmpKTable)this._table)) == -1) continue;
            Object[] row = (Object[])this._data.elementAt(rowNo);
            StringBuffer sb = new StringBuffer((String)row[this.ROLE]);
            if (!sb.toString().equals("")) {
                sb.append(", ");
            }
            int rolePos = this._ccmCommonUserRoleRowStatusOid.length + oid[this._ccmCommonUserRoleRowStatusOid.length] + 2;
            String role = SnmpString.toString((int[])oid, (int)rolePos, (int)oid.length);
            sb.append(role);
            String rowUser = SnmpString.toString((int[])userName, (int)1, (int)userName.length);
            if (this.getPeer().getUserName() != null && rowUser.equals(this.getPeer().getUserName()) && role.equals("network-admin")) {
                this._isNetworkAdminRole = true;
            }
            row[this.ROLE] = sb.toString();
        }
    }

    int findRow(Array _data, int[] user, SnmpKTable _table) {
        for (int i = 0; i < _data.size(); ++i) {
            int[] rowIndex = ((SnmpOID)_table.getValueAt(i, 0)).getValue();
            if (!SnmpOID.equals((int[])user, (int[])rowIndex)) continue;
            return i;
        }
        return -1;
    }

    protected SnmpPDU getSetPDU() throws Exception {
        SnmpPDU pdu = super.getSetPDU();
        ArrayList<Integer> passwordlist = new ArrayList<Integer>();
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            if (!pdu.getVariables().get(i).getOid().startsWith(CcmCommonUserPasswordOid)) continue;
            passwordlist.add(new Integer(i));
        }
        int[] maskList = new int[passwordlist.size()];
        for (int i = 0; i < passwordlist.size(); ++i) {
            maskList[i] = (Integer)passwordlist.get(i);
        }
        pdu.setVarBindMask(maskList);
        return pdu;
    }

    protected void insert(SnmpPDU pdu, int[] index) throws SnmpException {
        this.fetchRow(index);
    }

    protected void postFetchRow(SnmpPDU pdu) {
        super.postFetchRow(pdu);
        try {
            this.fetchRole(this._data.size() - 1);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this._parent, (String)ex.getMessage());
        }
        Object[] row = (Object[])this._data.elementAt(this._data.size() - 1);
        row[this.PASSWORD] = new SnmpString("");
    }

    protected void postProcessFetchAllSetRowsPDU(Array changedRows, SnmpPDU pdu) {
        for (int i = 0; i < changedRows.size(); ++i) {
            int fetchRow = (Integer)changedRows.elementAt(i);
            try {
                this.fetchRole(fetchRow);
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this._parent, (String)ex.getMessage());
            }
            Object[] row = (Object[])this._data.elementAt(fetchRow);
            row[this.PASSWORD] = new SnmpString("");
        }
    }

    protected void delete() throws SnmpException {
        int[] selected = this._table.getSelectedRows();
        String sessionUser = this.getPeer().getUserName();
        for (int i = 0; i < selected.length; ++i) {
            int[] rowIndex = ((SnmpOID)this.getValueAt(selected[i], 0)).getValue();
            String newUser = SnmpString.toString((int[])rowIndex, (int)1, (int)rowIndex.length);
            if (sessionUser == null || !newUser.equals(sessionUser)) continue;
            throw new SnmpException("Cannot delete current user");
        }
        boolean encryptedNodes = false;
        if (Discover.getPeer().getPrivPassword() == null) {
            Discover.getPeer().setPrivPassword(Discover.getPeer().getAuthPassword());
            Discover.getPeer().setPrivProtocol(0);
            Discover.getPeer().calcLocalizedKey();
            encryptedNodes = true;
        }
        try {
            super.delete();
        }
        catch (SnmpException ex) {
            if (encryptedNodes) {
                Discover.getPeer().setPrivPassword(null);
                Discover.getPeer().setPrivKey(null);
                encryptedNodes = false;
            }
            throw new SnmpException(ex.getMessage());
        }
        if (encryptedNodes) {
            Discover.getPeer().setPrivPassword(null);
            Discover.getPeer().setPrivKey(null);
            encryptedNodes = false;
        }
    }

    private String[] parseRoles(String roles) {
        StringTokenizer st = new StringTokenizer(roles, ",");
        while (st.hasMoreTokens()) {
            String string = st.nextToken().trim();
        }
        return null;
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (Discover.isSysVersionGreaterThanEqual((String)"2.0(0)") && ch == 'C' && e.getActionCommand().charAt(1) == 'r') {
            boolean isPending = false;
            if (this.getCFSStatus() == null) {
                int[] cfsStatus = DmSystem.isCFSEnabled((JFrame)DeviceManager.getInstance(), this.getPeer(), new int[][]{DmSystem.CFS_ROLE_INDEX}, new String[]{"role"}, false);
                CfsStatusCache.getInstance().setCFSStatus(DmSystem.CFS_ROLE_INDEX, cfsStatus[0]);
                isPending = cfsStatus[0] == 2;
            } else {
                boolean bl = isPending = this.getCFSStatus()[0] == 2;
            }
            if (isPending) {
                Util.errorMessage((Component)this._parent, (String)"Please commit Common Roles pending changes before creation.");
                return;
            }
        }
        super.doIt(ch, e);
    }

    protected DmTableModel buildTableModel() {
        return new DmUserTableModel();
    }

    class DmUserTableModel
    extends DmTableModel {
        DmUserTableModel() {
        }

        public boolean isCellActive(int row, int col) {
            if (col == EditCommonUserTable.this.PASSWORD) {
                if (EditCommonUserTable.this.getPeer().getVersion() != 3) {
                    return false;
                }
                Object[] rowObj = (Object[])EditCommonUserTable.this._data.elementAt(row);
                if (rowObj == null || EditCommonUserTable.this._table.getValueAt(row, 0) == null || !(EditCommonUserTable.this._table.getValueAt(row, 0) instanceof SnmpOID)) {
                    return false;
                }
                int[] rowIndex = ((SnmpOID)EditCommonUserTable.this._table.getValueAt(row, 0)).getValue();
                boolean isSessionUser = EditCommonUserTable.this.getPeer().getUserName() != null && EditCommonUserTable.this.getPeer().getUserName().equals(SnmpString.toString((int[])rowIndex, (int)1, (int)rowIndex.length));
                return (isSessionUser || EditCommonUserTable.this._isNetworkAdminRole) && EditCommonUserTable.this.getPeer().isV3() && EditCommonUserTable.this.getPeer().getPrivPassword() != null;
            }
            if (col == EditCommonUserTable.this.EXPIRYDATE || col == EditCommonUserTable.this.SSHFILE) {
                return EditCommonUserTable.this.getPeer().isV3() && EditCommonUserTable.this.getPeer().getPrivPassword() != null;
            }
            return super.isCellActive(row, col);
        }

        public void setValueAt(Object aValue, int row, int col) {
            if (col == EditCommonUserTable.this.EXPIRYDATE) {
                if (aValue != null && ((String)aValue).indexOf(45) != -1) {
                    Util.errorMessage((Component)EditCommonUserTable.this._parent, (String)(this.getHeaders()[col] + ": Expected yyyy/mm/dd format"));
                }
                if (((String)aValue).length() == 0) {
                    super.setValueAt(aValue, row, col);
                } else {
                    super.setValueAt((Object)(aValue + "-00:00:00"), row, col);
                }
            }
            super.setValueAt(aValue, row, col);
        }
    }
}

