/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.VacmViewTree;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class EditGroupTable
extends EditTable {
    static final String[] _defRole = new String[]{"nwadminGroup", "stadminGroup", "nwoperGroup", "stoperGroup"};
    final String[] _varVbl = new String[]{"vacmViewTreeFamilyType"};
    final int[] _deleteVarOid = MibNode.get((String)"vacmViewTreeFamilyStatus").getOid();
    final int _SecurityModelOffset = MibNode.get((String)"vacmAccessReadViewName").getOid().length;
    final int _subTreeOffset = MibNode.get((String)"vacmViewTreeFamilyType").getOid().length;
    final String[] _subTreeVarVbl = new String[]{"vacmViewTreeFamilyType", "vacmViewTreeFamilyMask"};
    final int _viewNameOffset = MibNode.get((String)this._subTreeVarVbl[0]).getOid().length;
    static final int[][] _iscsiViews = new int[][]{{1, 3, 6, 1, 4, 1, 9, 9, 317}, {1, 3, 6, 1, 4, 1, 9, 10, 94}};
    static final int[][] _fcipViews = new int[][]{{1, 3, 6, 1, 4, 1, 9, 10, 96}, {1, 3, 6, 1, 4, 1, 9, 9, 329}};
    static final int _READACCESS = 2;
    static final int _WRITEACCESS = 3;
    Array _viewTreeList;

    public EditGroupTable(String[] vars) {
        super(vars);
    }

    protected void buildTable() {
        super.buildTable();
        this._viewTreeList = this.getSubtrees();
    }

    protected boolean isSkip(SnmpPDU pdu) {
        SnmpVarBind vb = pdu.getVariables().get(1);
        int[] responseOid = vb.getOid().getValue();
        int[] index = new int[responseOid.length - this._SecurityModelOffset];
        System.arraycopy(responseOid, this._SecurityModelOffset, index, 0, responseOid.length - this._SecurityModelOffset - 1);
        int securityModel = index[index[0] + 1];
        return securityModel != 3 && securityModel != 0;
    }

    protected void delete() throws SnmpException {
        int i;
        int[] selected = this._table.getSelectedRows();
        for (int i2 = 0; i2 < selected.length; ++i2) {
            int[] index = ((SnmpOID)this.getValueAt(selected[i2], 0)).getValue();
            String view = SnmpString.toString((int[])index, (int)1, (int)(index[0] + 1));
            if (!this.isDefaultRole(view)) continue;
            throw new SnmpException("Cannot delete a default role");
        }
        Array _viewTreeIdxList = new Array();
        Array _viewNameList = new Array();
        for (i = 0; i < selected.length; ++i) {
            for (int j = 1; j < 3; ++j) {
                Object o = this.getValueAt(selected[i], j);
                String s = o instanceof SnmpVar ? ((SnmpString)this.getValueAt(selected[i], j)).toString() : (String)this.getValueAt(selected[i], j);
                int[] view = new int[s.length() + 1];
                view[0] = s.length();
                for (int k = 0; k < s.length(); ++k) {
                    view[k + 1] = s.charAt(k);
                }
                if (view.length <= 1) continue;
                _viewNameList.addElement((Object)view);
            }
        }
        for (i = 0; i < _viewNameList.size(); ++i) {
            VarBindList vblArray = new VarBindList();
            vblArray.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)this._varVbl[0]).getOid(), (int[])_viewNameList.elementAt(i))));
            try {
                SnmpPDU response = SnmpFetch.getBulk((SnmpPeer)this.getPeer(), (VarBindList)vblArray);
                int varNum = this._varVbl.length;
                for (int j = 0; j < response.getVariables().size(); j += varNum) {
                    SnmpVarBind vb = response.getVariables().get(j);
                    int[] responseOid = vb.getOid().getValue();
                    int idxlength = responseOid.length - this._subTreeOffset;
                    int[] idx = new int[idxlength];
                    System.arraycopy(responseOid, this._subTreeOffset, idx, 0, idxlength);
                    _viewTreeIdxList.addElement((Object)idx);
                }
                continue;
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
        for (i = 0; i < _viewTreeIdxList.size(); ++i) {
            try {
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
                pdu.addVar(new SnmpOID(this._deleteVarOid, (int[])_viewTreeIdxList.elementAt(i)), (SnmpVar)new SnmpInt(6));
                this.getPeer().set(pdu);
                continue;
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.debug((Object)ex);
            }
        }
        super.delete();
    }

    boolean isDefaultRole(String role) {
        for (int i = 0; i < _defRole.length; ++i) {
            if (!_defRole[i].equals(role)) continue;
            return true;
        }
        return false;
    }

    public Array getSubtrees() {
        if (this._viewTreeList != null) {
            return this._viewTreeList;
        }
        Array viewTreeList = new Array();
        boolean isAddIscsi = true;
        boolean isAddFcip = true;
        VarBindList vblArray = new VarBindList();
        for (int i = 0; i < this._subTreeVarVbl.length; ++i) {
            vblArray.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)this._subTreeVarVbl[i]).getOid())));
        }
        try {
            SnmpPDU response = SnmpFetch.getBulk((SnmpPeer)this.getPeer(), (VarBindList)vblArray);
            int varNum = this._subTreeVarVbl.length;
            for (int i = 0; i < response.getVariables().size(); i += varNum) {
                SnmpVarBind vb = response.getVariables().get(i);
                int[] responseOid = vb.getOid().getValue();
                int[] viewName = new int[responseOid[this._viewNameOffset]];
                System.arraycopy(responseOid, this._viewNameOffset + 1, viewName, 0, responseOid[this._viewNameOffset]);
                String view = SnmpString.toString((int[])viewName, (int)0, (int)viewName.length);
                if (view.equals("iscsi")) {
                    isAddIscsi = false;
                }
                if (view.equals("fcip")) {
                    isAddFcip = false;
                }
                int subtreeOffset = this._viewNameOffset + viewName.length + 1;
                int[] subtree = new int[responseOid[subtreeOffset]];
                System.arraycopy(responseOid, subtreeOffset + 1, subtree, 0, subtree.length);
                SnmpVar type = vb.getVar();
                vb = response.getVariables().get(i + 1);
                SnmpVar mask = vb.getVar();
                VacmViewTree vt = new VacmViewTree(view, subtree, mask, type);
                viewTreeList.addElement((Object)vt);
            }
        }
        catch (SnmpException ex) {
            // empty catch block
        }
        if (isAddIscsi) {
            for (int i = 0; i < _iscsiViews.length; ++i) {
                byte[] b = new byte[]{-1};
                VacmViewTree vt = new VacmViewTree("iscsi", _iscsiViews[i], (SnmpVar)new SnmpString(b), (SnmpVar)new SnmpInt(1));
                viewTreeList.addElement((Object)vt);
            }
        }
        if (isAddFcip) {
            for (int i = 0; i < _fcipViews.length; ++i) {
                byte[] b = new byte[]{-1};
                VacmViewTree vt = new VacmViewTree("fcip", _fcipViews[i], (SnmpVar)new SnmpString(b), (SnmpVar)new SnmpInt(1));
                viewTreeList.addElement((Object)vt);
            }
        }
        return viewTreeList;
    }

    class ViewRenderer
    extends DefaultTableCellRenderer {
        ViewRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String tooltip;
            String view = value.toString();
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < EditGroupTable.this._viewTreeList.size(); ++i) {
                String stype;
                if (!view.equals(((VacmViewTree)EditGroupTable.this._viewTreeList.elementAt(i)).getViewName())) continue;
                int[] subtree = ((VacmViewTree)EditGroupTable.this._viewTreeList.elementAt(i)).getSubTree();
                int type = ((SnmpInt)((VacmViewTree)EditGroupTable.this._viewTreeList.elementAt(i)).getType()).getValue();
                String string = stype = type == 1 ? "(include)" : "(exclude)";
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(stype + SnmpOID.toString((int[])subtree));
                if (subtree.length != 1 || subtree[0] != 1) continue;
                String mask = ((SnmpString)((VacmViewTree)EditGroupTable.this._viewTreeList.elementAt(i)).getMask()).toString();
                view = mask.equals("ff") ? (type == 1 ? "all" : "") : view;
            }
            String string = tooltip = sb.toString().equals("") ? "n/a" : sb.toString();
            if (tooltip.equals("(include)1")) {
                tooltip = "";
            }
            this.setToolTipText(tooltip);
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setText(view);
            return this;
        }
    }
}

