/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.sme;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class InsertSmeInterface
extends InsertForm {
    static final int MODULE = 0;
    static final int PORT = 1;
    FieldPanel _modulePanel;
    FieldPanel _portPanel;
    JLabel _portLabel;
    Integer[] _ds_18Plus4_SlotList;
    Integer[] _ds_18Plus4_TypeList;
    static final String VER_STR_5_2_6 = "5.2(6)";
    protected int _smeTimeout = 60000;

    public InsertSmeInterface(InsertDialog parent, EditTable table) {
        super(parent, table);
        ArrayList<Integer> dsCards = new ArrayList<Integer>();
        ArrayList<Integer> dsCardTypes = new ArrayList<Integer>();
        int[] cardTypes = DmSystem.getCardTypes();
        for (int i = 0; i < cardTypes.length; ++i) {
            if (cardTypes[i] != 39 && cardTypes[i] != 41 && (cardTypes[i] != 44 || !Discover.isSysVersionGreaterThanEqual((String)"4.2(0)"))) continue;
            dsCards.add(new Integer(i + 1));
            dsCardTypes.add(new Integer(cardTypes[i]));
        }
        this._ds_18Plus4_SlotList = dsCards.toArray(new Integer[dsCards.size()]);
        this._ds_18Plus4_TypeList = dsCardTypes.toArray(new Integer[dsCardTypes.size()]);
    }

    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            return new JLabel("Module :", 4);
        }
        return new JLabel(this.getFormLabel(mibVar, index) + ":", 4);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            this._modulePanel = new FieldPanel(5, (JComponent)((Object)new ModuleIdMenuButton(null)));
            this._modulePanel.getField().addFocusListener(new moduleListener());
            return this._modulePanel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected void build() {
        super.build();
        if (this._ds_18Plus4_SlotList.length > 0) {
            this._modulePanel.setText(this._ds_18Plus4_SlotList[0].toString());
            this.updatePortPanel(0);
        }
    }

    private void updatePortPanel(int pos) {
        boolean isSsn16Card = this._ds_18Plus4_TypeList[pos] == 44;
        this._portPanel.setVisible(isSsn16Card);
        this._portLabel.setVisible(isSsn16Card);
    }

    protected void layoutForm() {
        JComponent[] labels = new JLabel[this._labels.length + 1];
        labels[0] = this._labels[0];
        System.arraycopy(this._labels, 1, labels, 2, this._labels.length - 1);
        labels[1] = this._portLabel = new JLabel("Node:", 4);
        JComponent[] values = new JComponent[this._values.length + 1];
        values[0] = this._values[0];
        System.arraycopy(this._values, 1, values, 2, this._values.length - 1);
        this._portPanel = new FieldPanel(5, (JComponent)((Object)new PortIdMenuButton(null)));
        values[1] = this._portPanel;
        DialogUtil.buildPanel((Container)this._container, (JComponent[])labels, (JComponent[])values);
    }

    protected SnmpVar getVarFromString(String text, int index) throws Exception {
        if (index == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("sme");
            sb.append(this._modulePanel.getText());
            if (this._portPanel.isVisible()) {
                sb.append("/");
                sb.append(this._portPanel.getText());
            } else {
                sb.append("/1");
            }
            return super.getVarFromString(sb.toString(), index);
        }
        return super.getVarFromString(text, index);
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        if (Discover.isSysVersionGreaterThanEqual((String)VER_STR_5_2_6)) {
            pdu.setTimeout(this._smeTimeout);
        }
        return pdu;
    }

    class moduleListener
    extends FocusAdapter {
        moduleListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String module = InsertSmeInterface.this.getComponentText(0);
            try {
                for (int i = 0; i < InsertSmeInterface.this._ds_18Plus4_SlotList.length; ++i) {
                    int slot = Integer.parseInt(module);
                    if (slot != InsertSmeInterface.this._ds_18Plus4_SlotList[i]) continue;
                    InsertSmeInterface.this.updatePortPanel(i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PortIdMenuButton
    extends MenuButton {
        EditForm _parent;

        PortIdMenuButton(JMenu menu) {
            super(menu);
            this._parent = null;
        }

        public void actionPerformed(ActionEvent e) {
            if (this._menu == null) {
                this._menu = new JMenu();
                Object[] names = new String[4];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = Integer.toString(i + 1);
                }
                if (names.length == 0) {
                    this.setEnabled(false);
                    return;
                }
                this.buildMenu(names);
            }
            super.actionPerformed(e);
        }
    }

    class ModuleIdMenuButton
    extends MenuButton {
        EditForm _parent;

        ModuleIdMenuButton(JMenu menu) {
            super(menu);
            this._parent = null;
        }

        public void actionPerformed(ActionEvent e) {
            if (this._menu == null) {
                if (InsertSmeInterface.this._ds_18Plus4_SlotList == null || InsertSmeInterface.this._ds_18Plus4_SlotList.length == 0) {
                    this.setEnabled(false);
                    return;
                }
                this._menu = new JMenu();
                Object[] names = new String[InsertSmeInterface.this._ds_18Plus4_SlotList.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = Integer.toString(InsertSmeInterface.this._ds_18Plus4_SlotList[i]);
                }
                if (names.length == 0) {
                    this.setEnabled(false);
                    return;
                }
                this.buildMenu(names);
            }
            if (e.getSource() instanceof JMenuItem) {
                try {
                    for (int i = 0; i < InsertSmeInterface.this._ds_18Plus4_SlotList.length; ++i) {
                        int slot = Integer.parseInt(((JMenuItem)e.getSource()).getText());
                        if (slot != InsertSmeInterface.this._ds_18Plus4_SlotList[i]) continue;
                        InsertSmeInterface.this.updatePortPanel(i);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.actionPerformed(e);
        }
    }
}

