/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.span;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fc.EditIfPortForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.span.EditSPANFCSrcTable;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.event.ListSelectionEvent;

public class EditSPANSrcTable
extends EditTable {
    static final int SESSION = 0;
    static final int SRCVSAN2KPOS = 1;
    static final int FCINTERFACE = 2;
    static final int[] _srcVsan4kOid = MibNode.get((String)"cspanSourcesVsans4k").getOid();
    MibEnum[] _cspanSourcesDirectionEnums = new MibEnum[]{new MibEnum("Rx", 1), new MibEnum("Tx", 2)};

    public EditSPANSrcTable(String[] vars) {
        super(vars);
    }

    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt((Object)"Edit Interface List...", 0);
        return btns;
    }

    protected void buildTable() {
        super.buildTable();
        boolean[] isEditable = this._tableModel.getEditable();
        isEditable[2] = false;
        this._tableModel.setEditable(isEditable);
        this._table.setFixedWidth(0, 35);
        this._table.setFixedWidth(2, 215);
    }

    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("FC");
    }

    public void valueChanged(ListSelectionEvent e) {
        boolean isEnabled;
        super.valueChanged(e);
        boolean bl = isEnabled = this._table.getSelectedRowCount() > 0;
        if (this._table.getSelectedRow() != -1) {
            Object vsanSource = this.getValueAt(this._table.getSelectedRow(), 1);
            this.enableButton('F', isEnabled && vsanSource.equals(""));
        } else {
            this.enableButton('F', isEnabled);
        }
    }

    protected void updateTable() {
        super.updateTable();
        this.enableButton('F', false);
    }

    protected void get() {
        super.get();
        this._needsRefresh = true;
    }

    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        int[] oid = pdu.getVariables().get(0).getOid().getValue();
        boolean firstGet = oid.length == _srcVsan4kOid.length;
        int[] index = new int[1];
        if (!firstGet) {
            index[0] = oid[_srcVsan4kOid.length];
        }
        pdu.addNull(firstGet ? new SnmpOID(_srcVsan4kOid) : new SnmpOID(_srcVsan4kOid, index));
        super.sendGetPdu(pdu);
    }

    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (!timedOut) {
            SnmpVarBind vb = pdu.getVariables().get(0);
            if (this._state == -95 && !this.isEnd(this._firstOid, vb) || this._state == -96) {
                pdu = EditIfPortForm.appendVsan4kTo2kVar(pdu, 5, 0, pdu.getVariables().size() - 1, -1, -1, true);
            }
        }
        super.callback(session, reqid, pdu, timedOut);
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        int i;
        Array pduList = new Array();
        pduList.addElement((Object)pdu);
        Array changedCells = this._tableModel.getChanged();
        int pduSize = pdu.getVariables().size();
        for (i = pduSize - 1; i >= 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            Cell cell = (Cell)changedCells.elementAt(i);
            Object[] values = (Object[])this._data.elementAt(cell._row);
            Object[] changed = (Object[])values[this._tableModel.getHeaders().length];
            if (cell._col != 1) continue;
            SnmpBitmap oldVsan2k = new SnmpBitmap((String)changed[cell._col]);
            SnmpBitmap newVsan2k = (SnmpBitmap)vb.getVar();
            pdu.removeVarAt(i);
            int[] index = new int[]{oid[oid.length - 1]};
            PortInterfaceUtil.getInstance((int)5).addSpanVsanCfg2Pdu(pduList, oldVsan2k, newVsan2k, index);
        }
        for (i = 0; i < pduList.size(); ++i) {
            if (((SnmpPDU)pduList.elementAt(i)).getVariables().size() <= 0) continue;
            this.getPeer().setFrag((SnmpPDU)pduList.elementAt(i));
        }
    }

    protected void postProcessing() throws SnmpException {
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            row[2] = "";
        }
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cspanSourcesRowStatus").getOid())));
        SnmpPDU resp = SnmpFetch.getBulk((SnmpPeer)this.getPeer(), (int)14, (VarBindList)vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.get(i);
            int[] oid = vb.getOid().getValue();
            int spanSess = oid[oid.length - 3];
            this.addToTable(spanSess, oid);
        }
    }

    String getFCSource(Object[] row, int[] oid, Object fcSource) {
        StringBuffer sb = new StringBuffer();
        if (fcSource != null) {
            sb.append(fcSource.toString());
            if (!fcSource.toString().equals("")) {
                sb.append(", ");
            }
        }
        sb.append(MibVariableFormat._IfIndexIf.ifIndexToName(oid[oid.length - 2]));
        sb.append(" (");
        for (int i = 0; i < this._cspanSourcesDirectionEnums.length; ++i) {
            if (oid[oid.length - 1] != this._cspanSourcesDirectionEnums[i].getValue()) continue;
            sb.append(this._cspanSourcesDirectionEnums[i].getLabel());
            break;
        }
        sb.append(")");
        return sb.toString();
    }

    void addToTable(int spanSess, int[] oid) {
        int i;
        for (i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            int vsan = Integer.parseInt(((SnmpOID)row[0]).toString());
            if (spanSess != vsan) continue;
            row[2] = this.getFCSource(row, oid, row[2]);
            return;
        }
        Object[] newRow = new Object[this._vars.length + 2];
        newRow[0] = ((Object[])this._data.elementAt(i))[0];
        newRow[2] = this.getFCSource(newRow, oid, null);
        this._data.insertElementAt((Object)newRow, i);
    }

    public void dispose() {
        super.dispose();
        DMDialog d = DialogListener.getInstance().getDialog("SPANFCSource");
        if (d != null) {
            DialogListener.getInstance().remove("SPANFCSource");
            d.dispose();
        }
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'F') {
            boolean isBuilt = false;
            int[] index = ((SnmpOID)this._tableModel.getValueAt(this._table.getSelectedRow(), 0)).getValue();
            DMDialog fcSourceDlg = DialogListener.getInstance().dialogAction("SPANFCSource", index);
            if (fcSourceDlg != null) {
                fcSourceDlg.setTitle(Discover.getDeviceName() + " - SPAN Session " + index[0] + ": Source Interfaces");
                fcSourceDlg.setParentTable((EditTable)this);
                InsertDialog insertD = ((EditSPANFCSrcTable)fcSourceDlg.getPanel(0)).getInsertDialog();
                if (insertD != null) {
                    insertD.dispose();
                }
            }
        } else {
            super.doIt(ch, e);
        }
    }

    protected DmTableModel buildTableModel() {
        return new SnmpSPANFilterTableModel();
    }

    static class SnmpSPANFilterTableModel
    extends DmTableModel {
        SnmpSPANFilterTableModel() {
        }

        public boolean isCellActive(int row, int col) {
            if (col == 1) {
                Object o = this.getValueAt(row, 2);
                return o != null && o.toString().equals("");
            }
            return super.isCellActive(row, col);
        }
    }
}

