/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.syslog;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.lib.jnm.VshLog;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;

public class RlirLog
extends VshLog {
    static final String[] COLS = new String[]{"Host Time", "Switch Time", "VSAN", "DOMAIN", "Port", "Interface", "Link Incident"};
    static final String[] COLS_3dot03 = new String[]{"Host Time", "Switch Time", "VSAN", "DOMAIN", "Port", "Interface", "Link Incident", "Loc/Rem"};
    static final int TIMESTAMP = 1;
    static final int FACILITY = 2;
    static final int SEVERITY = 3;
    static final int EVENT = 4;
    static final int VSAN_TIMESTAMP = 5;
    static final int VSAN = 6;
    static final int VSAN_ID = 7;
    static final int HOST_TIMESTAMP = 8;
    static final int PORT = 9;
    static final int INTERFACE = 10;
    static final int DESCRIPTION = 11;
    static final String RLIR_REGEX = "(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}) +\\S+ +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+):( +%\\$(VSAN (\\d+))?:? *(.*)%\\$)? +Interface (\\S+) \\[Port (\\w+)\\], (.*)";
    static Pattern _Pattern = Pattern.compile("(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2}) +\\S+ +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+):( +%\\$(VSAN (\\d+))?:? *(.*)%\\$)? +Interface (\\S+) \\[Port (\\w+)\\], (.*)");
    static final String RLIR_REGEX2 = "([a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\d*) +([a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\d*) +(\\w+) +(\\S+) +(.*)";
    static final String RLIR_REGEX3_3 = "(\\*\\*\\* \\*\\* \\*\\*:\\*\\*:\\*\\* \\*\\*\\*\\*|[a-zA-Z]{3} +\\d*+ +\\d{2}:\\d{2}:\\d{2} +\\d*) +([a-zA-Z]{3} +\\d*+ +\\d{2}:\\d{2}:\\d{2} +\\d*) +(\\*\\*\\*\\*|\\d*) +(\\*\\*\\*\\*|\\d*) +(\\w+) +(\\S+) +(.*) +(.*)";
    static Pattern _Pattern2 = Pattern.compile("([a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\d*) +([a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\d*) +(\\w+) +(\\S+) +(.*)");
    static Pattern _Pattern3_3 = Pattern.compile("(\\*\\*\\* \\*\\* \\*\\*:\\*\\*:\\*\\* \\*\\*\\*\\*|[a-zA-Z]{3} +\\d*+ +\\d{2}:\\d{2}:\\d{2} +\\d*) +([a-zA-Z]{3} +\\d*+ +\\d{2}:\\d{2}:\\d{2} +\\d*) +(\\*\\*\\*\\*|\\d*) +(\\*\\*\\*\\*|\\d*) +(\\w+) +(\\S+) +(.*) +(.*)");
    static final int HOST_TIMESTAMP2 = 1;
    static final int SWITCH_TIMESTAMP2 = 2;
    static final int VSAN2 = 3;
    static final int DOMAIN2 = 4;
    static final int PORT2 = 5;
    static final int INTERFACE2 = 6;
    static final int DESCRIPTION2 = 7;
    static final int LOC2 = 8;
    boolean _isGreaterThan3dot03;

    public RlirLog(JFrame parent, String cmd, SnmpPeer peer) throws IOException {
        super(parent, cmd, peer);
        this.setTitle(peer + " - Link Incident History");
        this._isGreaterThan3dot03 = Discover.isSysVersionGreaterThanEqual((String)"3.0(3)");
    }

    public RlirLog(JFrame parent, String title, String filename) {
        super(parent, title, filename);
    }

    protected String[] getHeaders() {
        this._isGreaterThan3dot03 = Discover.isSysVersionGreaterThanEqual((String)"3.0(3)");
        return this._isGreaterThan3dot03 ? COLS_3dot03 : COLS;
    }

    protected String[] tokenize(String line) {
        line = line.trim();
        String[] tokens = new String[this.getHeaders().length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = null;
        }
        if (this.isFileMode()) {
            Matcher m = _Pattern.matcher(line);
            if (m.matches()) {
                tokens[0] = m.group(8);
                tokens[1] = m.group(1);
                tokens[2] = m.group(9);
                tokens[3] = m.group(10);
                tokens[4] = m.group(11);
                if (m.group(6) != null) {
                    tokens[4] = m.group(6) + ", " + tokens[4];
                }
            } else {
                tokens[4] = line;
            }
        } else {
            if (line.length() == 0 || line.startsWith("Link incident") || line.startsWith("--") || line.startsWith("Host Time Stamp") || line.startsWith("Switch Time Stamp")) {
                return null;
            }
            Matcher m3 = _Pattern3_3.matcher(line);
            Matcher m = _Pattern2.matcher(line);
            if (m3.matches()) {
                tokens[0] = m3.group(1);
                tokens[1] = m3.group(2);
                tokens[2] = m3.group(3);
                tokens[3] = m3.group(4);
                tokens[4] = m3.group(5);
                tokens[5] = m3.group(6);
                tokens[6] = m3.group(7);
                tokens[7] = m3.group(8);
            } else if (m.matches()) {
                tokens[0] = m.group(1);
                tokens[1] = m.group(2);
                tokens[4] = m.group(5);
                tokens[5] = m.group(6);
                tokens[6] = m.group(7);
            } else {
                tokens[6] = line;
            }
        }
        return tokens;
    }
}

