/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.syslog;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EventManagerJAXC;
import com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.QlogicCommandHandlerDM;
import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SyslogVerification
extends JDialog
implements ActionListener {
    static final int AAAD = 1240;
    static final int INFO = 7;
    SnmpPeer _peer;
    JFrame _parent;
    JTextArea _log;
    private static final int DNS_TYPE = 16;
    EventManagerJAXC _eventMgrClient;
    String _ipAddr;
    boolean _isQuail;
    boolean _maybeFMSA;

    public SyslogVerification(JFrame parent, SnmpPeer peer, boolean isQuail) {
        super(parent);
        this._parent = parent;
        this._peer = peer;
        this._isQuail = isQuail;
        this._log = new JTextArea();
        this._log.setEditable(false);
        this._log.setWrapStyleWord(true);
        this._log.setLineWrap(true);
        JScrollPane sp = new JScrollPane(this._log);
        sp.setPreferredSize(new Dimension(450, 100));
        String[] btns = new String[]{"Close"};
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)sp, (AbstractButton[])DialogUtil.buildButtons((String[])btns, (ActionListener)this));
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void showDialog() {
        this.setTitle(this._peer + " - Syslog Verify");
        this._log.setText(this.updateLog());
        this.setVisible(true);
    }

    private String updateLog() {
        this._eventMgrClient = null;
        StringBuffer sb = new StringBuffer();
        this._maybeFMSA = false;
        if (!Service.isRunning((String)"SAN Server")) {
            this._maybeFMSA = true;
            try {
                Discover.getInstance();
                this._ipAddr = NetUtil.detectSourceAddress((InetAddress)Discover.getPeer().getAddress()).getHostAddress();
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.debug((Object)("failed to get localHost address " + ex));
            }
            sb.append("Step 1: DCNM-SAN server is not running locally.\nRun either DCNM-SAN server or DCNM-SAN Standalone.  The fabric with switch " + Discover.getLoginDeviceName() + " must be open.\n");
        } else {
            sb.append("Step 1: DCNM-SAN server is running.\n");
        }
        try {
            int nextSepNo;
            block21: {
                if (!this._maybeFMSA) {
                    this._ipAddr = this.getSyslogAddress();
                    if (this._ipAddr == null) {
                        throw new Exception("no syslog address (please check if 3rd party syslog is running)");
                    }
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._DefLogger.debug((Object)("getSyslogAddress from EventMgrClient=" + this._ipAddr));
                    }
                    try {
                        String endPoint = this.getEndPoint();
                        sb.append("        URL = " + endPoint + "\n\n");
                    }
                    catch (Exception epEX) {
                        if (this._maybeFMSA) break block21;
                        throw epEX;
                    }
                }
            }
            try {
                boolean isOnSwitch;
                boolean bl = isOnSwitch = this._isQuail ? this.checkSysLogRegisterOnSwitchQuail() : this.checkSysLogRegisterOnSwitch();
                if (!isOnSwitch) {
                    sb.append("Step 2: Switch is not sending Syslog messages to DCNM-SAN server or DCNM-SAN Standalone at " + this._ipAddr + "\n(See Logs->Syslog->Setup)\n");
                    return sb.toString();
                }
                sb.append("Step 2: Switch is sending Syslog messages to DCNM-SAN server or DCNM-SAN Standalone.\n");
            }
            catch (Exception ex) {
                sb.append(ex);
                return sb.toString();
            }
            if (!this._maybeFMSA) {
                sb.append("Step 3: Check if DCNM-SAN server is listening to " + Discover.getLoginDeviceName() + " from " + this._ipAddr + "... ");
                if (this.checkSyslogAddedtoEventManager()) {
                    sb.append("ok (added).\n");
                } else {
                    sb.append("ok.\n");
                }
            }
            int n = nextSepNo = this._maybeFMSA ? 3 : 4;
            if (!this._isQuail && !this.changeAAADSeverity()) {
                sb.append("Step " + nextSepNo + ": Switch is not sending Syslog Accounting messages\n(Set 'aaad' to 'info' in Logs->Syslog->Setup->Severity Levels)\n");
            }
        }
        catch (Exception ex) {
            if (this._maybeFMSA) {
                sb.append("error -" + ex.getMessage());
            } else {
                sb.append("Can't connect to DCNM-SAN server - " + ex.getMessage());
            }
            if (SnmpSession.isTrace()) {
                DefaultLogger._DefLogger.debug((Object)ex.getMessage());
            }
            return sb.toString();
        }
        sb.append("\nVerification succeeded.");
        return sb.toString();
    }

    private boolean checkSysLogRegisterOnSwitch() throws Exception {
        try {
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cseSyslogServerAddressType").getOid())));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cseSyslogServerAddress").getOid())));
            new SnmpFetch();
            SnmpPDU pdu = SnmpFetch.getBulk((SnmpPeer)this._peer, (VarBindList)vbl, (int)3);
            if (SnmpSession.isTrace()) {
                DefaultLogger._DefLogger.debug((Object)("checkSysLogRegisterOnSwitch,   dnsName from EventMgrClient=" + this._ipAddr));
            }
            vbl = pdu.getVariables();
            boolean found = false;
            for (int i = 0; i < vbl.size() && !found; i += 2) {
                if (vbl.intValue(i) == 16) {
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._DefLogger.debug((Object)("checkSysLogRegisterOnSwitch,   syslogAddr from switch=" + vbl.stringValue(i + 1)));
                    }
                    if (!(found = this._ipAddr.equals(vbl.stringValue(i + 1)))) continue;
                    break;
                }
                found = SnmpString.equals((byte[])InetAddress.getByName(this._ipAddr).getAddress(), (byte[])vbl.byteValue(i + 1));
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.debug((Object)("syslog server entry : " + SnmpIpAddress.toString((byte[])vbl.byteValue(i + 1)) + "  found=" + found));
                }
                if (found) break;
            }
            return found;
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)ex.getMessage());
            return false;
        }
    }

    private boolean checkSysLogRegisterOnSwitchQuail() throws Exception {
        QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance((JFrame)DeviceManager.getInstance(), Discover.getPeer());
        try {
            String[] out = cmdHandler.getSyslogEnable();
            boolean isEnabled = QlogicCommandHandlerDM.parseTrueValueString(out[0]);
            if (!isEnabled) {
                return false;
            }
            out = cmdHandler.getSyslogServer();
            String ipaddress = QlogicCommandHandlerDM.parseHexIpString(out[0]);
            byte[] b = SnmpIpAddress.parse((String)ipaddress);
            return SnmpString.equals((byte[])InetAddress.getByName(this._ipAddr).getAddress(), (byte[])b);
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)ex.getMessage());
            return false;
        }
    }

    private void initEventMgrClient() throws Exception {
        this._eventMgrClient = null;
        if (this._isQuail || !Discover.getPeer().isV3()) {
            String userCommunity = Discover.getPeer().getReadCommunity();
            if (Discover.getPeer().getWriteCommunity() != null && Discover.getPeer().getWriteCommunity().length() > 0) {
                userCommunity = Discover.getPeer().getWriteCommunity();
            }
            this._eventMgrClient = new EventManagerJAXC(userCommunity);
        } else {
            this._eventMgrClient = new EventManagerJAXC(Discover.getPeer().getUserName(), Discover.getPeer().getAuthPassword(), Discover.getPeer().getAuthProtocol());
        }
        if (SnmpSession.isTrace()) {
            DefaultLogger._DefLogger.debug((Object)("found _EventMgr " + this._eventMgrClient));
        }
        if (this._eventMgrClient == null) {
            throw new Exception("failed to locate EventMgrClient");
        }
    }

    private String getSyslogAddress() throws Exception {
        if (this._eventMgrClient == null) {
            this.initEventMgrClient();
        }
        if (SnmpSession.isTrace()) {
            DefaultLogger._DefLogger.debug((Object)("SyslogVerification getSyslogAddress for  " + Discover.getLoginDeviceName()));
        }
        if (Discover.getPeer().getAuthPassword() != null && Discover.getPeer().getPrivPassword() != null && Discover.getPeer().getPrivPassword().length() > 0) {
            return this._eventMgrClient.getSyslogAddress(Discover.getLoginDeviceName(), Discover.getPeer().getPrivProtocol(), Discover.getPeer().getPrivPassword());
        }
        return this._eventMgrClient.getSyslogAddress(Discover.getLoginDeviceName());
    }

    private String getEndPoint() throws Exception {
        if (this._eventMgrClient == null) {
            this.initEventMgrClient();
        }
        return this._eventMgrClient.getEndPoint();
    }

    private boolean isHttps() throws Exception {
        if (this._eventMgrClient == null) {
            this.initEventMgrClient();
        }
        return this._eventMgrClient.isHttps();
    }

    private boolean checkSyslogAddedtoEventManager() throws Exception {
        if (this._eventMgrClient == null) {
            this.initEventMgrClient();
        }
        if (SnmpSession.isTrace()) {
            DefaultLogger._DefLogger.debug((Object)("checkSyslogAddedtoEventManager for  " + Discover.getLoginDeviceName()));
        }
        if (Discover.getPeer().getAuthPassword() != null && Discover.getPeer().getPrivPassword() != null && Discover.getPeer().getPrivPassword().length() > 0) {
            return this._eventMgrClient.addSource(Discover.getLoginDeviceName(), Discover.getPeer().getPrivProtocol(), Discover.getPeer().getPrivPassword());
        }
        return this._eventMgrClient.addSource(Discover.getLoginDeviceName());
    }

    private boolean changeAAADSeverity() {
        if (SnmpSession.isTrace()) {
            DefaultLogger._DefLogger.debug((Object)"changeAAADSeverity....");
        }
        try {
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cseSyslogMessageSeverity").getOid(), 1240), (SnmpVar)new SnmpInt(7)));
            SnmpPDU pdu = new SnmpPDU(-96, vbl);
            pdu.setIgnoreSetCount(true);
            pdu = this._peer.send(pdu);
            return pdu.getVariables().intValue(0) == 7;
        }
        catch (SnmpException ex) {
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = ((JButton)e.getSource()).getText();
        switch (cmd.charAt(0)) {
            case 'C': {
                this.setVisible(false);
            }
        }
    }
}

