/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.vsif;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditVTPVLANForm
extends EditForm {
    static final int VLAN_TYPE = 0;
    static final int VLAN_STATUS = 1;
    static final int VLANS = 2;
    static final int VLAN2k = 3;
    static final int VLAN3k = 4;
    static final int VLAN4k = 5;
    boolean _removeHelpBtn;
    SnmpString _vlanVar;
    static final int[] _vlanTrunkPortVlansEnabledOid = MibNode.get((String)"vlanTrunkPortVlansEnabled").getOid();

    public EditVTPVLANForm(String[] vars) {
        super(vars);
    }

    protected void build() {
        super.build();
        if (this.isMultiple()) {
            this._table.removeColumn(this._table.getColumnModel().getColumn(6));
            this._table.removeColumn(this._table.getColumnModel().getColumn(5));
            this._table.removeColumn(this._table.getColumnModel().getColumn(4));
        } else {
            this._labels[3].setVisible(false);
            this._values[3].setVisible(false);
            this._labels[4].setVisible(false);
            this._values[4].setVisible(false);
            this._labels[5].setVisible(false);
            this._values[5].setVisible(false);
            this._labels[2].setText("VLAN List:");
        }
    }

    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (!timedOut) {
            pdu = this.appendVlan4kTo2kVar(pdu, 2);
        }
        super.callback(session, reqid, pdu, timedOut);
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        pdu = this.splitVar2k4k(pdu);
        this.getPeer().setFrag(pdu);
    }

    SnmpPDU appendVlan4kTo2kVar(SnmpPDU pdu, int _2kPos) {
        VarBindList vbl = pdu.getVariables();
        SnmpVar vlansVar = vbl.get(_2kPos).getVar();
        if (vlansVar.getType() != 5) {
            try {
                SnmpString vlans = (SnmpString)vlansVar;
                SnmpString vlan2k = (SnmpString)vbl.get(_2kPos + 1).getVar();
                SnmpString vlan3k = (SnmpString)vbl.get(_2kPos + 2).getVar();
                SnmpString vlan4k = (SnmpString)vbl.get(_2kPos + 3).getVar();
                vlans = PortInterfaceUtil.getInstance((int)3).getVlans(vlans, vlan2k, vlan3k, vlan4k);
            }
            catch (ClassCastException ex) {
                System.err.println("Agent does not return the proper number of VarBinds: vlans=" + vbl.get(_2kPos).getVar() + "vlan2k=" + vbl.get(_2kPos + 1).getVar());
                System.err.println("Agent does not return the proper number of VarBinds: vlan3k=" + vbl.get(_2kPos + 2).getVar() + "vlan4k=" + vbl.get(_2kPos + 3).getVar());
            }
        }
        vbl.removeRange(_2kPos + 1, _2kPos + 4);
        return pdu;
    }

    SnmpPDU splitVar2k4k(SnmpPDU pdu) {
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            if (!vb.getOid().startsWith(_vlanTrunkPortVlansEnabledOid)) continue;
            pdu.removeVarAt(pdu.getVariables().size() - 1);
            PortInterfaceUtil.getInstance((int)3).addVlanAllowed4k3k2Pdu(pdu, vb.getOid(), vb.getVar(), oid[oid.length - 1]);
        }
        return pdu;
    }

    protected void updateForm(SnmpPDU pdu) {
        super.updateForm(pdu);
        this._vlanVar = (SnmpString)pdu.getVar(2);
    }

    protected boolean isChanged(int index) {
        try {
            SnmpVar newVlanVar = this.getComponentValue(2);
            if (((SnmpString)newVlanVar).equals(this._vlanVar)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.isChanged(index);
    }

    protected Object[] buildTableRow(int[] index) {
        Object[] row = new Object[this._vars.length + 3];
        row[0] = new SnmpOID(index);
        return row;
    }

    protected void buildRow(Object[] row, SnmpPDU pdu, int rowNo) {
        super.buildRow(row, pdu, rowNo);
        row[row.length - 1] = row[3];
    }

    protected DmTableModel buildTableModel() {
        return new SnmpVlanTableModel();
    }

    class SnmpVlanTableModel
    extends DmTableModel {
        SnmpVlanTableModel() {
        }

        public void markUndo(int row, int col, Object aValue) {
            Object[] values = (Object[])EditVTPVLANForm.this._data.elementAt(row);
            Object[] changed = (Object[])values[this.getHeaders().length];
            if (col == 3 && ((String)aValue).equals((String)values[values.length - 1])) {
                if (changed != null && changed[col] != null) {
                    changed[col] = null;
                }
                return;
            }
            super.markUndo(row, col, aValue);
        }
    }
}

