/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.vsif;

import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.fcoe.FCoEConfigurationPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigCommandsIf;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigurationCommandsFactory;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigurationHelper;
import com.cisco.dcbu.lib.util.fcoe.UnAuthorizedUserException;
import com.cisco.dcbu.lib.util.vsif.VSifObj;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class QuickConfigForm
extends DMPanel
implements ActionListener {
    private FCoEConfigurationPanel tablePanel;
    private FCoEConfigCommandsIf cmdObj;

    public QuickConfigForm(String[] pVars) {
        super(pVars);
    }

    protected void build() throws SnmpException {
        try {
            DeviceManager.getInstance().setCursor(Cursor.getPredefinedCursor(3));
            DefaultLogger._DefLogger.debug((Object)"QuickConfigForm : Building the QuickConfigForm.");
            this.cmdObj = this.checkPreConditions();
            TreeMap<Integer, Integer> activeVlanVsans = QuickConfigForm.getActiveVlanVsans(Discover.getPeer());
            this.tablePanel = new FCoEConfigurationPanel(activeVlanVsans, new TreeMap(), Discover.getRoot(), (JFrame)DeviceManager.getInstance(), Discover.getPeer(), false, true, this.cmdObj, DmSystem.getIsNPVMode());
            this._container = new JPanel();
            this._container.setLayout(new BorderLayout());
            this._formPanel = this.tablePanel;
            this._formPanel.setPreferredSize(new Dimension(650, 550));
            this._container.add("Center", this._formPanel);
            this.buildButtons();
        }
        catch (SnmpException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SnmpException(e.getMessage());
        }
        finally {
            DeviceManager.getInstance().setCursor(Cursor.getDefaultCursor());
        }
    }

    private FCoEConfigCommandsIf checkPreConditions() throws Exception {
        String errorMsg = null;
        try {
            if (!this.getFCoEFeatureStatus(Discover.getRoot())) {
                errorMsg = "The fcoe feature is currently disabled. To continue, please enable the feature \nSave the current configuration and Reboot the switch to make the feature changes effective.";
            }
        }
        catch (SnmpException e) {
            errorMsg = e.getMessage();
        }
        FCoEConfigCommandsIf cmdObj = FCoEConfigurationCommandsFactory.getInstance().getFCoEConfigurationCommands((JFrame)DeviceManager.getInstance(), Discover.getPeer(), Discover.getRoot());
        if (!cmdObj.isTelnetSSHEnabled()) {
            errorMsg = "Please enable telnet or secure shell server on switch.";
        }
        try {
            cmdObj.connect();
        }
        catch (IOException e) {
            errorMsg = "Could not establish a telnet or secure shell connection to the switch. Please try again.";
        }
        catch (UnAuthorizedUserException e) {
            errorMsg = e.getMessage();
        }
        if (errorMsg != null) {
            if (cmdObj != null) {
                cmdObj.disconnect();
            }
            throw new Exception(errorMsg);
        }
        return cmdObj;
    }

    private boolean getFCoEFeatureStatus(SwitchAttrIf selectedSwitch) throws SnmpException {
        return FCoEConfigurationHelper.isFCoEEnabled((SwitchAttrIf)selectedSwitch, (SnmpPeer)Discover.getPeer());
    }

    private static TreeMap<Integer, Integer> getActiveVlanVsans(SnmpPeer node) throws Exception {
        DefaultLogger._DefLogger.debug((Object)"QuickConfigForm : Getting the active vlan-vsan map.");
        VSifObj vsifObj = VSifObj.get((SnmpPeer)node, (IfIndexIf)Discover.getRoot(), (byte[])new byte[]{8});
        TreeMap vlanVsanMap = vsifObj.getUpVlanVsanMap();
        if (vlanVsanMap == null || vlanVsanMap.size() <= 0) {
            throw new Exception("No Active Vlan Vsan mappings are available on the switch.");
        }
        return vlanVsanMap;
    }

    protected void get() {
        this.tablePanel.refresh();
    }

    protected Array getButtons() {
        Array b = new Array();
        b.addElement((Object)"Apply");
        b.addElement((Object)"Refresh");
        return b;
    }

    protected boolean isBuilt() {
        return this.tablePanel != null;
    }

    protected void removeMibVars() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() instanceof AbstractButton) {
                this.doIt(((AbstractButton)e.getSource()).getActionCommand().charAt(0));
            }
        }
        catch (Exception ex) {
            if (SnmpSession.isTrace()) {
                ex.printStackTrace();
            }
            Util.errorMessage((Component)DeviceManager.getInstance(), (String)ex.getMessage());
        }
    }

    protected void doIt(char ch) throws Exception {
        switch (ch) {
            case 'A': {
                this.enableButton('R', false);
                this._parent.setCursor(Cursor.getPredefinedCursor(3));
                this.tablePanel.startConfiguration();
                this._parent.setCursor(Cursor.getDefaultCursor());
                this.enableButton('R', true);
                break;
            }
            case 'R': {
                this._parent.setCursor(Cursor.getPredefinedCursor(3));
                this.tablePanel.refresh();
                this._parent.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 'H': {
                this.helpAction();
                break;
            }
            case 'C': {
                this.closeAction();
            }
        }
    }
}

