/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.zm;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ZoneInconsistencyDialog
extends JDialog
implements ActionListener {
    private JTextArea cmdInformation;
    private boolean cancelled = true;
    static ImageIcon IMG_WARN = Util.loadIcon((String)"icons/Warn.gif");

    public ZoneInconsistencyDialog(JFrame parent, HashMap inconsitencyMap) throws SnmpException {
        super(parent);
        this.setTitle(Discover.getDeviceName() + " - Discrepancies");
        this.cmdInformation = new JTextArea();
        this.cmdInformation.setOpaque(true);
        this.cmdInformation.setEditable(false);
        this.cmdInformation.setWrapStyleWord(true);
        JLabel explain = new JLabel(IMG_WARN, 2);
        explain.setText("<HTML>Caution: Traffic disruption may occur after pressing OK. Zone configurations on VSANs using <br>unsupported features are cleared. Please review before proceeding. <br><br> </HTML> ");
        for (Map.Entry obEntry : inconsitencyMap.entrySet()) {
            int vsan = (Integer)obEntry.getKey();
            StringBuffer info = (StringBuffer)obEntry.getValue();
            this.cmdInformation.append("VSAN:" + vsan + "\n");
            this.cmdInformation.append(info.toString());
        }
        JScrollPane pane = new JScrollPane(this.cmdInformation);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)explain, "North");
        mainPanel.add((Component)pane, "Center");
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)mainPanel, (AbstractButton[])DialogUtil.buildButtons((String[])new String[]{"OK", "Cancel"}, (ActionListener)this));
        this.setSize(600, 500);
        this.setModal(true);
        this.setResizable(true);
        this.setLocationRelativeTo(parent);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char ch = e.getActionCommand().charAt(0);
        switch (ch) {
            case 'O': {
                this.cancelled = false;
            }
        }
        this.dispose();
    }

    boolean isCancelled() {
        return this.cancelled;
    }
}

